/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.InsensitiveBinaryComparison;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.function.scalar.ip.CIDRMatch;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesFunction;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.PhysicalVerifier;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EsSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.EsStatsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EsTimeseriesQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EvalExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeExec;
import org.elasticsearch.xpack.esql.plan.physical.FieldExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.FilterExec;
import org.elasticsearch.xpack.esql.plan.physical.LimitExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.TopNExec;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;
import org.elasticsearch.xpack.esql.planner.AbstractPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.EsqlTranslatorHandler;
import org.elasticsearch.xpack.esql.stats.SearchStats;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.AttributeMap;
import org.elasticsearch.xpack.ql.expression.AttributeSet;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.MetadataAttribute;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.TypedAttribute;
import org.elasticsearch.xpack.ql.expression.function.aggregate.SpatialAggregateFunction;
import org.elasticsearch.xpack.ql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.ql.expression.predicate.Predicates;
import org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.expression.predicate.regex.RegexMatch;
import org.elasticsearch.xpack.ql.expression.predicate.regex.WildcardLike;
import org.elasticsearch.xpack.ql.optimizer.OptimizerRules;
import org.elasticsearch.xpack.ql.querydsl.query.Query;
import org.elasticsearch.xpack.ql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.Queries;

public class LocalPhysicalPlanOptimizer
extends ParameterizedRuleExecutor<PhysicalPlan, LocalPhysicalOptimizerContext> {
    public static final EsqlTranslatorHandler TRANSLATOR_HANDLER = new EsqlTranslatorHandler();
    private final PhysicalVerifier verifier = PhysicalVerifier.INSTANCE;
    private final boolean timeSeriesMode;

    public LocalPhysicalPlanOptimizer(LocalPhysicalOptimizerContext context) {
        super((Object)context);
        this.timeSeriesMode = context.configuration().pragmas().timeSeriesMode();
    }

    public PhysicalPlan localOptimize(PhysicalPlan plan) {
        return this.verify((PhysicalPlan)this.execute((Node)plan));
    }

    PhysicalPlan verify(PhysicalPlan plan) {
        Collection<Failure> failures = this.verifier.verify(plan);
        if (!failures.isEmpty()) {
            throw new VerificationException(failures);
        }
        return plan;
    }

    protected List<RuleExecutor.Batch<PhysicalPlan>> rules(boolean optimizeForEsSource) {
        ArrayList<Object> esSourceRules = new ArrayList<Object>(4);
        esSourceRules.add((Object)new ReplaceAttributeSourceWithDocId(this.timeSeriesMode));
        if (optimizeForEsSource) {
            esSourceRules.add((Object)new PushTopNToSource());
            esSourceRules.add((Object)new PushLimitToSource());
            esSourceRules.add((Object)new PushFiltersToSource());
            esSourceRules.add((Object)new PushStatsToSource());
        }
        RuleExecutor.Batch pushdown = new RuleExecutor.Batch("Push to ES", (Rule[])esSourceRules.toArray(Rule[]::new));
        RuleExecutor.Batch fieldExtraction = new RuleExecutor.Batch("Field extraction", RuleExecutor.Limiter.ONCE, new Rule[]{new InsertFieldExtraction(), new SpatialDocValuesExtraction()});
        return Arrays.asList(pushdown, fieldExtraction);
    }

    protected List<RuleExecutor.Batch<PhysicalPlan>> batches() {
        return this.rules(true);
    }

    private static boolean isAggregatable(FieldAttribute f) {
        return f.exactAttribute().field().isAggregatable();
    }

    public static boolean hasIdenticalDelegate(FieldAttribute attr, SearchStats stats) {
        return stats.hasIdenticalDelegate(attr.name());
    }

    public static boolean isPushableFieldAttribute(Expression exp, Predicate<FieldAttribute> hasIdenticalDelegate) {
        FieldAttribute fa;
        if (exp instanceof FieldAttribute && (fa = (FieldAttribute)exp).getExactInfo().hasExact() && LocalPhysicalPlanOptimizer.isAggregatable(fa)) {
            return fa.dataType() != DataTypes.TEXT || hasIdenticalDelegate.test(fa);
        }
        return false;
    }

    private static class ReplaceAttributeSourceWithDocId
    extends PhysicalOptimizerRules.OptimizerRule<EsSourceExec> {
        private final boolean timeSeriesMode;

        ReplaceAttributeSourceWithDocId(boolean timeSeriesMode) {
            super(OptimizerRules.TransformDirection.UP);
            this.timeSeriesMode = timeSeriesMode;
        }

        @Override
        protected PhysicalPlan rule(EsSourceExec plan) {
            if (this.timeSeriesMode) {
                return new EsTimeseriesQueryExec(plan.source(), plan.index(), plan.query());
            }
            return new EsQueryExec(plan.source(), plan.index(), plan.query());
        }
    }

    private static class PushTopNToSource
    extends PhysicalOptimizerRules.ParameterizedOptimizerRule<TopNExec, LocalPhysicalOptimizerContext> {
        private PushTopNToSource() {
        }

        @Override
        protected PhysicalPlan rule(TopNExec topNExec, LocalPhysicalOptimizerContext ctx) {
            ExchangeExec exchangeExec;
            boolean canPushDownTopN;
            PhysicalPlan plan = topNExec;
            PhysicalPlan child = topNExec.child();
            boolean bl = canPushDownTopN = child instanceof EsQueryExec || child instanceof ExchangeExec && (exchangeExec = (ExchangeExec)child).child() instanceof EsQueryExec;
            if (canPushDownTopN && this.canPushDownOrders(topNExec.order(), x -> LocalPhysicalPlanOptimizer.hasIdenticalDelegate(x, ctx.searchStats()))) {
                ExchangeExec exchangeExec2;
                PhysicalPlan physicalPlan;
                List<EsQueryExec.FieldSort> sorts = this.buildFieldSorts(topNExec.order());
                Expression limit = topNExec.limit();
                if (child instanceof ExchangeExec && (physicalPlan = (exchangeExec2 = (ExchangeExec)child).child()) instanceof EsQueryExec) {
                    EsQueryExec queryExec = (EsQueryExec)physicalPlan;
                    plan = exchangeExec2.replaceChild(queryExec.withSorts(sorts).withLimit(limit));
                } else {
                    plan = ((EsQueryExec)child).withSorts(sorts).withLimit(limit);
                }
            }
            return plan;
        }

        private boolean canPushDownOrders(List<Order> orders, Predicate<FieldAttribute> hasIdenticalDelegate) {
            return orders.stream().allMatch(o -> LocalPhysicalPlanOptimizer.isPushableFieldAttribute(o.child(), hasIdenticalDelegate));
        }

        private List<EsQueryExec.FieldSort> buildFieldSorts(List<Order> orders) {
            ArrayList<EsQueryExec.FieldSort> sorts = new ArrayList<EsQueryExec.FieldSort>(orders.size());
            for (Order o : orders) {
                sorts.add(new EsQueryExec.FieldSort(((FieldAttribute)o.child()).exactAttribute(), o.direction(), o.nullsPosition()));
            }
            return sorts;
        }
    }

    private static class PushLimitToSource
    extends PhysicalOptimizerRules.OptimizerRule<LimitExec> {
        private PushLimitToSource() {
        }

        @Override
        protected PhysicalPlan rule(LimitExec limitExec) {
            ExchangeExec exchangeExec;
            PhysicalPlan physicalPlan;
            PhysicalPlan plan = limitExec;
            PhysicalPlan child = limitExec.child();
            if (child instanceof EsQueryExec) {
                EsQueryExec queryExec = (EsQueryExec)child;
                plan = queryExec.withLimit(limitExec.limit());
            } else if (child instanceof ExchangeExec && (physicalPlan = (exchangeExec = (ExchangeExec)child).child()) instanceof EsQueryExec) {
                EsQueryExec queryExec = (EsQueryExec)physicalPlan;
                plan = exchangeExec.replaceChild(queryExec.withLimit(limitExec.limit()));
            }
            return plan;
        }
    }

    public static class PushFiltersToSource
    extends PhysicalOptimizerRules.ParameterizedOptimizerRule<FilterExec, LocalPhysicalOptimizerContext> {
        @Override
        protected PhysicalPlan rule(FilterExec filterExec, LocalPhysicalOptimizerContext ctx) {
            PhysicalPlan plan = filterExec;
            PhysicalPlan physicalPlan = filterExec.child();
            if (physicalPlan instanceof EsQueryExec) {
                EsQueryExec queryExec = (EsQueryExec)physicalPlan;
                ArrayList<Expression> pushable = new ArrayList<Expression>();
                ArrayList nonPushable = new ArrayList();
                for (Expression exp : Predicates.splitAnd((Expression)filterExec.condition())) {
                    (PushFiltersToSource.canPushToSource(exp, x -> LocalPhysicalPlanOptimizer.hasIdenticalDelegate(x, ctx.searchStats())) ? pushable : nonPushable).add(exp);
                }
                if (pushable.size() > 0) {
                    Query queryDSL = TRANSLATOR_HANDLER.asQuery(Predicates.combineAnd(pushable));
                    QueryBuilder planQuery = queryDSL.asBuilder();
                    QueryBuilder query = Queries.combine((Queries.Clause)Queries.Clause.FILTER, Arrays.asList(queryExec.query(), planQuery));
                    queryExec = new EsQueryExec(queryExec.source(), queryExec.index(), queryExec.output(), query, queryExec.limit(), queryExec.sorts(), queryExec.estimatedRowSize());
                    plan = nonPushable.size() > 0 ? new FilterExec(filterExec.source(), queryExec, Predicates.combineAnd(nonPushable)) : queryExec;
                }
            }
            return plan;
        }

        public static boolean canPushToSource(Expression exp, Predicate<FieldAttribute> hasIdenticalDelegate) {
            if (exp instanceof BinaryComparison) {
                BinaryComparison bc = (BinaryComparison)exp;
                return PushFiltersToSource.isAttributePushable(bc.left(), (Expression)bc, hasIdenticalDelegate) && bc.right().foldable();
            }
            if (exp instanceof InsensitiveBinaryComparison) {
                InsensitiveBinaryComparison bc = (InsensitiveBinaryComparison)exp;
                return PushFiltersToSource.isAttributePushable(bc.left(), (Expression)bc, hasIdenticalDelegate) && bc.right().foldable();
            }
            if (exp instanceof BinaryLogic) {
                BinaryLogic bl = (BinaryLogic)exp;
                return PushFiltersToSource.canPushToSource(bl.left(), hasIdenticalDelegate) && PushFiltersToSource.canPushToSource(bl.right(), hasIdenticalDelegate);
            }
            if (exp instanceof In) {
                In in = (In)exp;
                return PushFiltersToSource.isAttributePushable(in.value(), null, hasIdenticalDelegate) && Expressions.foldable((List)in.list());
            }
            if (exp instanceof Not) {
                Not not = (Not)exp;
                return PushFiltersToSource.canPushToSource(not.field(), hasIdenticalDelegate);
            }
            if (exp instanceof UnaryScalarFunction) {
                UnaryScalarFunction usf = (UnaryScalarFunction)exp;
                if (usf instanceof RegexMatch || usf instanceof IsNull || usf instanceof IsNotNull) {
                    FieldAttribute fa;
                    Expression expression;
                    if ((usf instanceof IsNull || usf instanceof IsNotNull) && (expression = usf.field()) instanceof FieldAttribute && (fa = (FieldAttribute)expression).dataType().equals((Object)DataTypes.TEXT)) {
                        return true;
                    }
                    return PushFiltersToSource.isAttributePushable(usf.field(), (Expression)usf, hasIdenticalDelegate);
                }
            } else {
                if (exp instanceof CIDRMatch) {
                    CIDRMatch cidrMatch = (CIDRMatch)exp;
                    return PushFiltersToSource.isAttributePushable(cidrMatch.ipField(), (Expression)cidrMatch, hasIdenticalDelegate) && Expressions.foldable(cidrMatch.matches());
                }
                if (exp instanceof SpatialRelatesFunction) {
                    SpatialRelatesFunction bc = (SpatialRelatesFunction)exp;
                    return bc.canPushToSource(LocalPhysicalPlanOptimizer::isAggregatable);
                }
            }
            return false;
        }

        private static boolean isAttributePushable(Expression expression, Expression operation, Predicate<FieldAttribute> hasIdenticalDelegate) {
            MetadataAttribute ma;
            if (LocalPhysicalPlanOptimizer.isPushableFieldAttribute(expression, hasIdenticalDelegate)) {
                return true;
            }
            if (expression instanceof MetadataAttribute && (ma = (MetadataAttribute)expression).searchable()) {
                return operation == null || operation instanceof Equals || operation instanceof NotEquals || operation instanceof WildcardLike;
            }
            return false;
        }
    }

    private static class PushStatsToSource
    extends PhysicalOptimizerRules.ParameterizedOptimizerRule<AggregateExec, LocalPhysicalOptimizerContext> {
        private PushStatsToSource() {
        }

        @Override
        protected PhysicalPlan rule(AggregateExec aggregateExec, LocalPhysicalOptimizerContext context) {
            PhysicalPlan plan = aggregateExec;
            PhysicalPlan physicalPlan = aggregateExec.child();
            if (physicalPlan instanceof EsQueryExec) {
                EsQueryExec queryExec = (EsQueryExec)physicalPlan;
                Tuple<List<Attribute>, List<EsStatsQueryExec.Stat>> tuple = this.pushableStats(aggregateExec, context);
                List stats = (List)tuple.v2();
                if (stats.size() > 1) {
                    return aggregateExec;
                }
                if (((List)tuple.v2()).size() == aggregateExec.aggregates().size()) {
                    plan = new EsStatsQueryExec(aggregateExec.source(), queryExec.index(), queryExec.query(), queryExec.limit(), (List)tuple.v1(), (List)tuple.v2());
                }
            }
            return plan;
        }

        private Tuple<List<Attribute>, List<EsStatsQueryExec.Stat>> pushableStats(AggregateExec aggregate, LocalPhysicalOptimizerContext context) {
            AttributeMap stats = new AttributeMap();
            Tuple tuple = new Tuple(new ArrayList(), new ArrayList());
            if (aggregate.groupings().isEmpty()) {
                for (NamedExpression namedExpression : aggregate.aggregates()) {
                    Attribute attribute = namedExpression.toAttribute();
                    EsStatsQueryExec.Stat stat = (EsStatsQueryExec.Stat)stats.computeIfAbsent((Object)attribute, a -> {
                        Alias as;
                        Expression child;
                        if (agg instanceof Alias && (child = (as = (Alias)agg).child()) instanceof Count) {
                            Count count = (Count)child;
                            Expression target = count.field();
                            String fieldName = null;
                            ExistsQueryBuilder query = null;
                            if (target.foldable()) {
                                fieldName = "*";
                            } else if (target instanceof FieldAttribute) {
                                FieldAttribute fa = (FieldAttribute)target;
                                String fName = fa.name();
                                if (context.searchStats().isSingleValue(fName)) {
                                    fieldName = fa.name();
                                    query = QueryBuilders.existsQuery((String)fieldName);
                                }
                            }
                            if (fieldName != null) {
                                return new EsStatsQueryExec.Stat(fieldName, EsStatsQueryExec.StatsType.COUNT, (QueryBuilder)query);
                            }
                        }
                        return null;
                    });
                    if (stat == null) continue;
                    List<Attribute> intermediateAttributes = AbstractPhysicalOperationProviders.intermediateAttributes(Collections.singletonList(namedExpression), Collections.emptyList());
                    ((List)tuple.v1()).addAll(intermediateAttributes);
                    ((List)tuple.v2()).add(stat);
                }
            }
            return tuple;
        }
    }

    static class InsertFieldExtraction
    extends Rule<PhysicalPlan, PhysicalPlan> {
        InsertFieldExtraction() {
        }

        public PhysicalPlan apply(PhysicalPlan plan) {
            plan = (PhysicalPlan)plan.transformUp(UnaryExec.class, p -> {
                AggregateExec agg;
                Set<Attribute> missing = InsertFieldExtraction.missingAttributes(p);
                if (p instanceof AggregateExec && (agg = (AggregateExec)p).groupings().size() == 1) {
                    LinkedList leaves = new LinkedList();
                    agg.aggregates().stream().filter(a -> !agg.groupings().contains(a)).forEach(a -> leaves.addAll(a.collectLeaves()));
                    List<Expression> remove = agg.groupings().stream().filter(g -> !leaves.contains(g)).toList();
                    missing.removeAll((Collection<?>)Expressions.references(remove));
                }
                if (!missing.isEmpty()) {
                    FieldExtractExec extractor = new FieldExtractExec(p.source(), p.child(), List.copyOf(missing));
                    p = p.replaceChild(extractor);
                }
                return p;
            });
            return plan;
        }

        private static Set<Attribute> missingAttributes(PhysicalPlan p) {
            LinkedHashSet<Attribute> missing = new LinkedHashSet<Attribute>();
            AttributeSet input = p.inputSet();
            p.forEachExpression(TypedAttribute.class, f -> {
                if ((f instanceof FieldAttribute || f instanceof MetadataAttribute) && !input.contains(f)) {
                    missing.add((Attribute)f);
                }
            });
            return missing;
        }
    }

    private static class SpatialDocValuesExtraction
    extends PhysicalOptimizerRules.OptimizerRule<AggregateExec> {
        private SpatialDocValuesExtraction() {
        }

        @Override
        protected PhysicalPlan rule(AggregateExec aggregate) {
            HashSet foundAttributes = new HashSet();
            PhysicalPlan plan = (PhysicalPlan)aggregate.transformDown(UnaryExec.class, exec -> {
                EvalExec evalExec;
                List<Alias> fields;
                List<Alias> changed;
                if (exec instanceof AggregateExec) {
                    AggregateExec agg = (AggregateExec)exec;
                    ArrayList<Object> orderedAggregates = new ArrayList<Object>();
                    boolean changedAggregates = false;
                    for (NamedExpression namedExpression : agg.aggregates()) {
                        Alias as;
                        Expression patt22845$temp;
                        if (namedExpression instanceof Alias && (patt22845$temp = (as = (Alias)namedExpression).child()) instanceof SpatialAggregateFunction) {
                            FieldAttribute fieldAttribute;
                            SpatialAggregateFunction af = (SpatialAggregateFunction)patt22845$temp;
                            Expression patt22930$temp = af.field();
                            if (patt22930$temp instanceof FieldAttribute && this.allowedForDocValues(fieldAttribute = (FieldAttribute)patt22930$temp, agg, foundAttributes)) {
                                foundAttributes.add(fieldAttribute);
                                changedAggregates = true;
                                orderedAggregates.add(as.replaceChild((Expression)af.withDocValues()));
                                continue;
                            }
                            orderedAggregates.add(namedExpression);
                            continue;
                        }
                        orderedAggregates.add(namedExpression);
                    }
                    if (changedAggregates) {
                        exec = new AggregateExec(agg.source(), agg.child(), agg.groupings(), orderedAggregates, agg.getMode(), agg.estimatedRowSize());
                    }
                }
                if (exec instanceof EvalExec && !(changed = (fields = (evalExec = (EvalExec)exec).fields()).stream().map(f -> (Alias)f.transformDown(SpatialRelatesFunction.class, spatialRelatesFunction -> spatialRelatesFunction.hasFieldAttribute(foundAttributes) ? spatialRelatesFunction.withDocValues(foundAttributes) : spatialRelatesFunction)).toList()).equals(fields)) {
                    exec = new EvalExec(exec.source(), exec.child(), changed);
                }
                if (exec instanceof FilterExec) {
                    FilterExec filterExec = (FilterExec)((Object)exec);
                    Expression condition = (Expression)filterExec.condition().transformDown(SpatialRelatesFunction.class, spatialRelatesFunction -> spatialRelatesFunction.hasFieldAttribute(foundAttributes) ? spatialRelatesFunction.withDocValues(foundAttributes) : spatialRelatesFunction);
                    if (!filterExec.condition().equals((Object)condition)) {
                        exec = new FilterExec(filterExec.source(), filterExec.child(), condition);
                    }
                }
                if (exec instanceof FieldExtractExec) {
                    FieldExtractExec fieldExtractExec = (FieldExtractExec)exec;
                    List<Attribute> attributesToExtract = fieldExtractExec.attributesToExtract();
                    HashSet<Attribute> docValuesAttributes = new HashSet<Attribute>();
                    for (Attribute attribute : foundAttributes) {
                        if (!attributesToExtract.contains(attribute)) continue;
                        docValuesAttributes.add(attribute);
                    }
                    if (docValuesAttributes.size() > 0) {
                        exec = new FieldExtractExec(exec.source(), exec.child(), attributesToExtract, docValuesAttributes);
                    }
                }
                return exec;
            });
            return plan;
        }

        private boolean allowedForDocValues(FieldAttribute fieldAttribute, AggregateExec agg, Set<FieldAttribute> foundAttributes) {
            HashSet<FieldAttribute> candidateDocValuesAttributes = new HashSet<FieldAttribute>(foundAttributes);
            candidateDocValuesAttributes.add(fieldAttribute);
            HashSet spatialRelatesAttributes = new HashSet();
            agg.forEachExpressionDown(SpatialRelatesFunction.class, relatesFunction -> candidateDocValuesAttributes.forEach(candidate -> {
                if (relatesFunction.hasFieldAttribute(Set.of(candidate))) {
                    spatialRelatesAttributes.add(candidate);
                }
            }));
            return spatialRelatesAttributes.size() < 2;
        }
    }
}

