/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.io.stream;

import java.io.IOException;
import java.util.function.Function;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.io.stream.PlanNameRegistry;
import org.elasticsearch.xpack.esql.io.stream.PlanNamedTypes;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.SourceUtils;

public final class PlanStreamOutput
extends StreamOutput {
    private final StreamOutput delegate;
    private final PlanNameRegistry registry;
    private final Function<Class<?>, String> nameSupplier;

    public PlanStreamOutput(StreamOutput delegate, PlanNameRegistry registry) {
        this(delegate, registry, PlanNamedTypes::name);
    }

    public PlanStreamOutput(StreamOutput delegate, PlanNameRegistry registry, Function<Class<?>, String> nameSupplier) {
        this.delegate = delegate;
        this.registry = registry;
        this.nameSupplier = nameSupplier;
    }

    public void writeLogicalPlanNode(LogicalPlan logicalPlan) throws IOException {
        assert (logicalPlan.children().size() <= 1);
        this.writeNamed(LogicalPlan.class, logicalPlan);
    }

    public void writePhysicalPlanNode(PhysicalPlan physicalPlan) throws IOException {
        assert (physicalPlan.children().size() <= 1);
        this.writeNamed(PhysicalPlan.class, physicalPlan);
    }

    public void writeOptionalPhysicalPlanNode(PhysicalPlan physicalPlan) throws IOException {
        if (physicalPlan == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writePhysicalPlanNode(physicalPlan);
        }
    }

    public void writeSource(Source source) throws IOException {
        this.writeBoolean(true);
        SourceUtils.writeSourceNoText((StreamOutput)this, (Source)source);
    }

    public void writeNoSource() throws IOException {
        this.writeBoolean(false);
    }

    public void writeExpression(Expression expression) throws IOException {
        this.writeNamed(Expression.class, expression);
    }

    public void writeNamedExpression(NamedExpression namedExpression) throws IOException {
        this.writeNamed(NamedExpression.class, namedExpression);
    }

    public void writeAttribute(Attribute attribute) throws IOException {
        this.writeNamed(Attribute.class, attribute);
    }

    public void writeOptionalExpression(Expression expression) throws IOException {
        if (expression == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeExpression(expression);
        }
    }

    public <T> void writeNamed(Class<T> type, T value) throws IOException {
        String name = this.nameSupplier.apply(value.getClass());
        PlanNameRegistry.PlanWriter<T> writer = this.registry.getWriter(type, name);
        this.writeString(name);
        writer.write(this, value);
    }

    public void writeByte(byte b) throws IOException {
        this.delegate.writeByte(b);
    }

    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.delegate.writeBytes(b, offset, length);
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public TransportVersion getTransportVersion() {
        return this.delegate.getTransportVersion();
    }

    public void setTransportVersion(TransportVersion version) {
        this.delegate.setTransportVersion(version);
        super.setTransportVersion(version);
    }
}

