/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.io.stream;

import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.dissect.DissectParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.InsensitiveEquals;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.esql.expression.function.UnsupportedAttribute;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Avg;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.function.aggregate.CountDistinct;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Median;
import org.elasticsearch.xpack.esql.expression.function.aggregate.MedianAbsoluteDeviation;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Percentile;
import org.elasticsearch.xpack.esql.expression.function.aggregate.SpatialCentroid;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Sum;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Values;
import org.elasticsearch.xpack.esql.expression.function.grouping.Bucket;
import org.elasticsearch.xpack.esql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Case;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Greatest;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Least;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.FromBase64;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBase64;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBoolean;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToCartesianPoint;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToCartesianShape;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDatetime;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDegrees;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDouble;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToGeoPoint;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToGeoShape;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIP;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToInteger;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLong;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToRadians;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToString;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLong;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToVersion;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateDiff;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateExtract;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateFormat;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateParse;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateTrunc;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.Now;
import org.elasticsearch.xpack.esql.expression.function.scalar.ip.CIDRMatch;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Abs;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Acos;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Asin;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Atan;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Atan2;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Ceil;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cos;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cosh;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.E;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Floor;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Log;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Log10;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Pi;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Pow;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Round;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Signum;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Sin;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Sinh;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Sqrt;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Tan;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Tanh;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Tau;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvg;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvConcat;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvCount;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvDedupe;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvFirst;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvLast;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMax;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMedian;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMin;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSlice;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSort;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSum;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvZip;
import org.elasticsearch.xpack.esql.expression.function.scalar.nulls.Coalesce;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContains;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialDisjoint;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialIntersects;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialWithin;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StX;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StY;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Concat;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.EndsWith;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.LTrim;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Left;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Length;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Locate;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.RLike;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.RTrim;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Replace;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Right;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Split;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.StartsWith;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Substring;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ToLower;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ToUpper;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Trim;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.WildcardLike;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Add;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Div;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mod;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Neg;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Sub;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NullEquals;
import org.elasticsearch.xpack.esql.io.stream.PlanNameRegistry;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;
import org.elasticsearch.xpack.esql.plan.logical.Dissect;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Grok;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.TopN;
import org.elasticsearch.xpack.esql.plan.logical.local.EsqlProject;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.DissectExec;
import org.elasticsearch.xpack.esql.plan.physical.EnrichExec;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EsSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.EvalExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSinkExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.FieldExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.FilterExec;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.GrokExec;
import org.elasticsearch.xpack.esql.plan.physical.LimitExec;
import org.elasticsearch.xpack.esql.plan.physical.MvExpandExec;
import org.elasticsearch.xpack.esql.plan.physical.OrderExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.ProjectExec;
import org.elasticsearch.xpack.esql.plan.physical.RowExec;
import org.elasticsearch.xpack.esql.plan.physical.ShowExec;
import org.elasticsearch.xpack.esql.plan.physical.TopNExec;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.MetadataAttribute;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.ReferenceAttribute;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.ql.expression.predicate.logical.And;
import org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.ql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.ql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.ArithmeticOperation;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparisonProcessor;
import org.elasticsearch.xpack.ql.expression.predicate.regex.RLikePattern;
import org.elasticsearch.xpack.ql.expression.predicate.regex.RegexMatch;
import org.elasticsearch.xpack.ql.expression.predicate.regex.WildcardPattern;
import org.elasticsearch.xpack.ql.index.EsIndex;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.EsRelation;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DateEsField;
import org.elasticsearch.xpack.ql.type.EsField;
import org.elasticsearch.xpack.ql.type.InvalidMappedField;
import org.elasticsearch.xpack.ql.type.KeywordEsField;
import org.elasticsearch.xpack.ql.type.TextEsField;
import org.elasticsearch.xpack.ql.type.UnsupportedEsField;
import org.elasticsearch.xpack.ql.util.SpatialCoordinateTypes;

public final class PlanNamedTypes {
    static final Class<UnaryScalarFunction> QL_UNARY_SCLR_CLS = UnaryScalarFunction.class;
    static final Class<org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction> ESQL_UNARY_SCLR_CLS = org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction.class;
    static final Map<String, TriFunction<Source, Expression, Expression, BinaryLogic>> BINARY_LOGIC_CTRS = Map.ofEntries(Map.entry(PlanNamedTypes.name(And.class), And::new), Map.entry(PlanNamedTypes.name(Or.class), Or::new));
    static final Map<String, BiFunction<Source, Expression, org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction>> ESQL_UNARY_SCALAR_CTRS = Map.ofEntries(Map.entry(PlanNamedTypes.name(Abs.class), Abs::new), Map.entry(PlanNamedTypes.name(Acos.class), Acos::new), Map.entry(PlanNamedTypes.name(Asin.class), Asin::new), Map.entry(PlanNamedTypes.name(Atan.class), Atan::new), Map.entry(PlanNamedTypes.name(Ceil.class), Ceil::new), Map.entry(PlanNamedTypes.name(Cos.class), Cos::new), Map.entry(PlanNamedTypes.name(Cosh.class), Cosh::new), Map.entry(PlanNamedTypes.name(Floor.class), Floor::new), Map.entry(PlanNamedTypes.name(FromBase64.class), FromBase64::new), Map.entry(PlanNamedTypes.name(Length.class), Length::new), Map.entry(PlanNamedTypes.name(Log10.class), Log10::new), Map.entry(PlanNamedTypes.name(LTrim.class), LTrim::new), Map.entry(PlanNamedTypes.name(RTrim.class), RTrim::new), Map.entry(PlanNamedTypes.name(Neg.class), Neg::new), Map.entry(PlanNamedTypes.name(Signum.class), Signum::new), Map.entry(PlanNamedTypes.name(Sin.class), Sin::new), Map.entry(PlanNamedTypes.name(Sinh.class), Sinh::new), Map.entry(PlanNamedTypes.name(Sqrt.class), Sqrt::new), Map.entry(PlanNamedTypes.name(StX.class), StX::new), Map.entry(PlanNamedTypes.name(StY.class), StY::new), Map.entry(PlanNamedTypes.name(Tan.class), Tan::new), Map.entry(PlanNamedTypes.name(Tanh.class), Tanh::new), Map.entry(PlanNamedTypes.name(ToBase64.class), ToBase64::new), Map.entry(PlanNamedTypes.name(ToBoolean.class), ToBoolean::new), Map.entry(PlanNamedTypes.name(ToCartesianPoint.class), ToCartesianPoint::new), Map.entry(PlanNamedTypes.name(ToDatetime.class), ToDatetime::new), Map.entry(PlanNamedTypes.name(ToDegrees.class), ToDegrees::new), Map.entry(PlanNamedTypes.name(ToDouble.class), ToDouble::new), Map.entry(PlanNamedTypes.name(ToGeoShape.class), ToGeoShape::new), Map.entry(PlanNamedTypes.name(ToCartesianShape.class), ToCartesianShape::new), Map.entry(PlanNamedTypes.name(ToGeoPoint.class), ToGeoPoint::new), Map.entry(PlanNamedTypes.name(ToIP.class), ToIP::new), Map.entry(PlanNamedTypes.name(ToInteger.class), ToInteger::new), Map.entry(PlanNamedTypes.name(ToLong.class), ToLong::new), Map.entry(PlanNamedTypes.name(ToRadians.class), ToRadians::new), Map.entry(PlanNamedTypes.name(ToString.class), ToString::new), Map.entry(PlanNamedTypes.name(ToUnsignedLong.class), ToUnsignedLong::new), Map.entry(PlanNamedTypes.name(ToVersion.class), ToVersion::new), Map.entry(PlanNamedTypes.name(Trim.class), Trim::new));
    static final Map<String, Function<Source, ScalarFunction>> NO_ARG_SCALAR_CTRS = Map.ofEntries(Map.entry(PlanNamedTypes.name(E.class), E::new), Map.entry(PlanNamedTypes.name(Pi.class), Pi::new), Map.entry(PlanNamedTypes.name(Tau.class), Tau::new));
    static final Map<String, BiFunction<Source, Expression, UnaryScalarFunction>> QL_UNARY_SCALAR_CTRS = Map.ofEntries(Map.entry(PlanNamedTypes.name(IsNotNull.class), IsNotNull::new), Map.entry(PlanNamedTypes.name(IsNull.class), IsNull::new), Map.entry(PlanNamedTypes.name(Not.class), Not::new));
    static final Map<String, TriFunction<Source, Expression, List<Expression>, ScalarFunction>> VARARG_CTORS = Map.ofEntries(Map.entry(PlanNamedTypes.name(Case.class), Case::new), Map.entry(PlanNamedTypes.name(Coalesce.class), Coalesce::new), Map.entry(PlanNamedTypes.name(Concat.class), Concat::new), Map.entry(PlanNamedTypes.name(Greatest.class), Greatest::new), Map.entry(PlanNamedTypes.name(Least.class), Least::new));
    static final Map<String, TriFunction<Source, Expression, Expression, ArithmeticOperation>> ARITHMETIC_CTRS = Map.ofEntries(Map.entry(PlanNamedTypes.name(Add.class), Add::new), Map.entry(PlanNamedTypes.name(Sub.class), Sub::new), Map.entry(PlanNamedTypes.name(Mul.class), Mul::new), Map.entry(PlanNamedTypes.name(Div.class), Div::new), Map.entry(PlanNamedTypes.name(Mod.class), Mod::new));
    static final Map<String, BiFunction<Source, Expression, AggregateFunction>> AGG_CTRS = Map.ofEntries(Map.entry(PlanNamedTypes.name(Avg.class), Avg::new), Map.entry(PlanNamedTypes.name(Count.class), Count::new), Map.entry(PlanNamedTypes.name(Sum.class), Sum::new), Map.entry(PlanNamedTypes.name(Min.class), Min::new), Map.entry(PlanNamedTypes.name(Max.class), Max::new), Map.entry(PlanNamedTypes.name(Median.class), Median::new), Map.entry(PlanNamedTypes.name(MedianAbsoluteDeviation.class), MedianAbsoluteDeviation::new), Map.entry(PlanNamedTypes.name(SpatialCentroid.class), SpatialCentroid::new), Map.entry(PlanNamedTypes.name(Values.class), Values::new));
    static final Map<String, BiFunction<Source, Expression, AbstractMultivalueFunction>> MV_CTRS = Map.ofEntries(Map.entry(PlanNamedTypes.name(MvAvg.class), MvAvg::new), Map.entry(PlanNamedTypes.name(MvCount.class), MvCount::new), Map.entry(PlanNamedTypes.name(MvDedupe.class), MvDedupe::new), Map.entry(PlanNamedTypes.name(MvFirst.class), MvFirst::new), Map.entry(PlanNamedTypes.name(MvLast.class), MvLast::new), Map.entry(PlanNamedTypes.name(MvMax.class), MvMax::new), Map.entry(PlanNamedTypes.name(MvMedian.class), MvMedian::new), Map.entry(PlanNamedTypes.name(MvMin.class), MvMin::new), Map.entry(PlanNamedTypes.name(MvSum.class), MvSum::new));

    private PlanNamedTypes() {
    }

    public static String name(Class<?> cls) {
        return cls.getSimpleName();
    }

    public static List<PlanNameRegistry.Entry> namedTypeEntries() {
        return List.of(PlanNameRegistry.Entry.of(PhysicalPlan.class, AggregateExec.class, PlanNamedTypes::writeAggregateExec, PlanNamedTypes::readAggregateExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, DissectExec.class, PlanNamedTypes::writeDissectExec, PlanNamedTypes::readDissectExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, EsQueryExec.class, PlanNamedTypes::writeEsQueryExec, PlanNamedTypes::readEsQueryExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, EsSourceExec.class, PlanNamedTypes::writeEsSourceExec, PlanNamedTypes::readEsSourceExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, EvalExec.class, PlanNamedTypes::writeEvalExec, PlanNamedTypes::readEvalExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, EnrichExec.class, PlanNamedTypes::writeEnrichExec, PlanNamedTypes::readEnrichExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, ExchangeExec.class, PlanNamedTypes::writeExchangeExec, PlanNamedTypes::readExchangeExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, ExchangeSinkExec.class, PlanNamedTypes::writeExchangeSinkExec, PlanNamedTypes::readExchangeSinkExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, ExchangeSourceExec.class, PlanNamedTypes::writeExchangeSourceExec, PlanNamedTypes::readExchangeSourceExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, FieldExtractExec.class, PlanNamedTypes::writeFieldExtractExec, PlanNamedTypes::readFieldExtractExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, FilterExec.class, PlanNamedTypes::writeFilterExec, PlanNamedTypes::readFilterExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, FragmentExec.class, PlanNamedTypes::writeFragmentExec, PlanNamedTypes::readFragmentExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, GrokExec.class, PlanNamedTypes::writeGrokExec, PlanNamedTypes::readGrokExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, LimitExec.class, PlanNamedTypes::writeLimitExec, PlanNamedTypes::readLimitExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, MvExpandExec.class, PlanNamedTypes::writeMvExpandExec, PlanNamedTypes::readMvExpandExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, OrderExec.class, PlanNamedTypes::writeOrderExec, PlanNamedTypes::readOrderExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, ProjectExec.class, PlanNamedTypes::writeProjectExec, PlanNamedTypes::readProjectExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, RowExec.class, PlanNamedTypes::writeRowExec, PlanNamedTypes::readRowExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, ShowExec.class, PlanNamedTypes::writeShowExec, PlanNamedTypes::readShowExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, TopNExec.class, PlanNamedTypes::writeTopNExec, PlanNamedTypes::readTopNExec), PlanNameRegistry.Entry.of(LogicalPlan.class, Aggregate.class, PlanNamedTypes::writeAggregate, PlanNamedTypes::readAggregate), PlanNameRegistry.Entry.of(LogicalPlan.class, Dissect.class, PlanNamedTypes::writeDissect, PlanNamedTypes::readDissect), PlanNameRegistry.Entry.of(LogicalPlan.class, EsRelation.class, PlanNamedTypes::writeEsRelation, PlanNamedTypes::readEsRelation), PlanNameRegistry.Entry.of(LogicalPlan.class, Eval.class, PlanNamedTypes::writeEval, PlanNamedTypes::readEval), PlanNameRegistry.Entry.of(LogicalPlan.class, Enrich.class, PlanNamedTypes::writeEnrich, PlanNamedTypes::readEnrich), PlanNameRegistry.Entry.of(LogicalPlan.class, EsqlProject.class, PlanNamedTypes::writeEsqlProject, PlanNamedTypes::readEsqlProject), PlanNameRegistry.Entry.of(LogicalPlan.class, Filter.class, PlanNamedTypes::writeFilter, PlanNamedTypes::readFilter), PlanNameRegistry.Entry.of(LogicalPlan.class, Grok.class, PlanNamedTypes::writeGrok, PlanNamedTypes::readGrok), PlanNameRegistry.Entry.of(LogicalPlan.class, Limit.class, PlanNamedTypes::writeLimit, PlanNamedTypes::readLimit), PlanNameRegistry.Entry.of(LogicalPlan.class, MvExpand.class, PlanNamedTypes::writeMvExpand, PlanNamedTypes::readMvExpand), PlanNameRegistry.Entry.of(LogicalPlan.class, OrderBy.class, PlanNamedTypes::writeOrderBy, PlanNamedTypes::readOrderBy), PlanNameRegistry.Entry.of(LogicalPlan.class, Project.class, PlanNamedTypes::writeProject, PlanNamedTypes::readProject), PlanNameRegistry.Entry.of(LogicalPlan.class, TopN.class, PlanNamedTypes::writeTopN, PlanNamedTypes::readTopN), PlanNameRegistry.Entry.of(Attribute.class, FieldAttribute.class, PlanNamedTypes::writeFieldAttribute, PlanNamedTypes::readFieldAttribute), PlanNameRegistry.Entry.of(Attribute.class, ReferenceAttribute.class, PlanNamedTypes::writeReferenceAttr, PlanNamedTypes::readReferenceAttr), PlanNameRegistry.Entry.of(Attribute.class, MetadataAttribute.class, PlanNamedTypes::writeMetadataAttr, PlanNamedTypes::readMetadataAttr), PlanNameRegistry.Entry.of(Attribute.class, UnsupportedAttribute.class, PlanNamedTypes::writeUnsupportedAttr, PlanNamedTypes::readUnsupportedAttr), PlanNameRegistry.Entry.of(EsField.class, EsField.class, PlanNamedTypes::writeEsField, PlanNamedTypes::readEsField), PlanNameRegistry.Entry.of(EsField.class, DateEsField.class, PlanNamedTypes::writeDateEsField, PlanNamedTypes::readDateEsField), PlanNameRegistry.Entry.of(EsField.class, InvalidMappedField.class, PlanNamedTypes::writeInvalidMappedField, PlanNamedTypes::readInvalidMappedField), PlanNameRegistry.Entry.of(EsField.class, KeywordEsField.class, PlanNamedTypes::writeKeywordEsField, PlanNamedTypes::readKeywordEsField), PlanNameRegistry.Entry.of(EsField.class, TextEsField.class, PlanNamedTypes::writeTextEsField, PlanNamedTypes::readTextEsField), PlanNameRegistry.Entry.of(EsField.class, UnsupportedEsField.class, PlanNamedTypes::writeUnsupportedEsField, PlanNamedTypes::readUnsupportedEsField), PlanNameRegistry.Entry.of(NamedExpression.class, Alias.class, PlanNamedTypes::writeAlias, PlanNamedTypes::readAlias), PlanNameRegistry.Entry.of(BinaryComparison.class, Equals.class, PlanNamedTypes::writeBinComparison, PlanNamedTypes::readBinComparison), PlanNameRegistry.Entry.of(BinaryComparison.class, NullEquals.class, PlanNamedTypes::writeBinComparison, PlanNamedTypes::readBinComparison), PlanNameRegistry.Entry.of(BinaryComparison.class, NotEquals.class, PlanNamedTypes::writeBinComparison, PlanNamedTypes::readBinComparison), PlanNameRegistry.Entry.of(BinaryComparison.class, GreaterThan.class, PlanNamedTypes::writeBinComparison, PlanNamedTypes::readBinComparison), PlanNameRegistry.Entry.of(BinaryComparison.class, GreaterThanOrEqual.class, PlanNamedTypes::writeBinComparison, PlanNamedTypes::readBinComparison), PlanNameRegistry.Entry.of(BinaryComparison.class, LessThan.class, PlanNamedTypes::writeBinComparison, PlanNamedTypes::readBinComparison), PlanNameRegistry.Entry.of(BinaryComparison.class, LessThanOrEqual.class, PlanNamedTypes::writeBinComparison, PlanNamedTypes::readBinComparison), PlanNameRegistry.Entry.of(InsensitiveEquals.class, InsensitiveEquals.class, PlanNamedTypes::writeInsensitiveEquals, PlanNamedTypes::readInsensitiveEquals), PlanNameRegistry.Entry.of(ScalarFunction.class, In.class, PlanNamedTypes::writeInComparison, PlanNamedTypes::readInComparison), PlanNameRegistry.Entry.of(RegexMatch.class, WildcardLike.class, PlanNamedTypes::writeWildcardLike, PlanNamedTypes::readWildcardLike), PlanNameRegistry.Entry.of(RegexMatch.class, RLike.class, PlanNamedTypes::writeRLike, PlanNamedTypes::readRLike), PlanNameRegistry.Entry.of(BinaryLogic.class, And.class, PlanNamedTypes::writeBinaryLogic, PlanNamedTypes::readBinaryLogic), PlanNameRegistry.Entry.of(BinaryLogic.class, Or.class, PlanNamedTypes::writeBinaryLogic, PlanNamedTypes::readBinaryLogic), PlanNameRegistry.Entry.of(QL_UNARY_SCLR_CLS, IsNotNull.class, PlanNamedTypes::writeQLUnaryScalar, PlanNamedTypes::readQLUnaryScalar), PlanNameRegistry.Entry.of(QL_UNARY_SCLR_CLS, IsNull.class, PlanNamedTypes::writeQLUnaryScalar, PlanNamedTypes::readQLUnaryScalar), PlanNameRegistry.Entry.of(QL_UNARY_SCLR_CLS, Not.class, PlanNamedTypes::writeQLUnaryScalar, PlanNamedTypes::readQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, Neg.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, Abs.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, Acos.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, Asin.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, Atan.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, Ceil.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, Cos.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, Cosh.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, Floor.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, FromBase64.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, Length.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, Log10.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, LTrim.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, RTrim.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, Signum.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, Sin.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, Sinh.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, Sqrt.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, StX.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, StY.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, Tan.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, Tanh.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, ToBase64.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, ToBoolean.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, ToCartesianPoint.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, ToDatetime.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, ToDegrees.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, ToDouble.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, ToGeoShape.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, ToCartesianShape.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, ToGeoPoint.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, ToIP.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, ToInteger.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, ToLong.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, ToRadians.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, ToString.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, ToUnsignedLong.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, ToVersion.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ESQL_UNARY_SCLR_CLS, Trim.class, PlanNamedTypes::writeESQLUnaryScalar, PlanNamedTypes::readESQLUnaryScalar), PlanNameRegistry.Entry.of(ScalarFunction.class, Atan2.class, PlanNamedTypes::writeAtan2, PlanNamedTypes::readAtan2), PlanNameRegistry.Entry.of(ScalarFunction.class, Case.class, PlanNamedTypes::writeVararg, PlanNamedTypes::readVarag), PlanNameRegistry.Entry.of(ScalarFunction.class, CIDRMatch.class, PlanNamedTypes::writeCIDRMatch, PlanNamedTypes::readCIDRMatch), PlanNameRegistry.Entry.of(ScalarFunction.class, Coalesce.class, PlanNamedTypes::writeVararg, PlanNamedTypes::readVarag), PlanNameRegistry.Entry.of(ScalarFunction.class, Concat.class, PlanNamedTypes::writeVararg, PlanNamedTypes::readVarag), PlanNameRegistry.Entry.of(ScalarFunction.class, DateDiff.class, PlanNamedTypes::writeDateDiff, PlanNamedTypes::readDateDiff), PlanNameRegistry.Entry.of(ScalarFunction.class, DateExtract.class, PlanNamedTypes::writeDateExtract, PlanNamedTypes::readDateExtract), PlanNameRegistry.Entry.of(ScalarFunction.class, DateFormat.class, PlanNamedTypes::writeDateFormat, PlanNamedTypes::readDateFormat), PlanNameRegistry.Entry.of(ScalarFunction.class, DateParse.class, PlanNamedTypes::writeDateTimeParse, PlanNamedTypes::readDateTimeParse), PlanNameRegistry.Entry.of(ScalarFunction.class, DateTrunc.class, PlanNamedTypes::writeDateTrunc, PlanNamedTypes::readDateTrunc), PlanNameRegistry.Entry.of(ScalarFunction.class, E.class, PlanNamedTypes::writeNoArgScalar, PlanNamedTypes::readNoArgScalar), PlanNameRegistry.Entry.of(ScalarFunction.class, Greatest.class, PlanNamedTypes::writeVararg, PlanNamedTypes::readVarag), PlanNameRegistry.Entry.of(ScalarFunction.class, Least.class, PlanNamedTypes::writeVararg, PlanNamedTypes::readVarag), PlanNameRegistry.Entry.of(ScalarFunction.class, Log.class, PlanNamedTypes::writeLog, PlanNamedTypes::readLog), PlanNameRegistry.Entry.of(ScalarFunction.class, Now.class, PlanNamedTypes::writeNow, PlanNamedTypes::readNow), PlanNameRegistry.Entry.of(ScalarFunction.class, Pi.class, PlanNamedTypes::writeNoArgScalar, PlanNamedTypes::readNoArgScalar), PlanNameRegistry.Entry.of(ScalarFunction.class, Round.class, PlanNamedTypes::writeRound, PlanNamedTypes::readRound), PlanNameRegistry.Entry.of(ScalarFunction.class, Pow.class, PlanNamedTypes::writePow, PlanNamedTypes::readPow), PlanNameRegistry.Entry.of(ScalarFunction.class, StartsWith.class, PlanNamedTypes::writeStartsWith, PlanNamedTypes::readStartsWith), PlanNameRegistry.Entry.of(ScalarFunction.class, EndsWith.class, PlanNamedTypes::writeEndsWith, PlanNamedTypes::readEndsWith), PlanNameRegistry.Entry.of(ScalarFunction.class, SpatialIntersects.class, PlanNamedTypes::writeSpatialRelatesFunction, PlanNamedTypes::readIntersects), PlanNameRegistry.Entry.of(ScalarFunction.class, SpatialDisjoint.class, PlanNamedTypes::writeSpatialRelatesFunction, PlanNamedTypes::readDisjoint), PlanNameRegistry.Entry.of(ScalarFunction.class, SpatialContains.class, PlanNamedTypes::writeSpatialRelatesFunction, PlanNamedTypes::readContains), PlanNameRegistry.Entry.of(ScalarFunction.class, SpatialWithin.class, PlanNamedTypes::writeSpatialRelatesFunction, PlanNamedTypes::readWithin), PlanNameRegistry.Entry.of(ScalarFunction.class, Substring.class, PlanNamedTypes::writeSubstring, PlanNamedTypes::readSubstring), PlanNameRegistry.Entry.of(ScalarFunction.class, Locate.class, PlanNamedTypes::writeLocate, PlanNamedTypes::readLocate), PlanNameRegistry.Entry.of(ScalarFunction.class, Left.class, PlanNamedTypes::writeLeft, PlanNamedTypes::readLeft), PlanNameRegistry.Entry.of(ScalarFunction.class, Right.class, PlanNamedTypes::writeRight, PlanNamedTypes::readRight), PlanNameRegistry.Entry.of(ScalarFunction.class, Split.class, PlanNamedTypes::writeSplit, PlanNamedTypes::readSplit), PlanNameRegistry.Entry.of(ScalarFunction.class, Tau.class, PlanNamedTypes::writeNoArgScalar, PlanNamedTypes::readNoArgScalar), PlanNameRegistry.Entry.of(ScalarFunction.class, Replace.class, PlanNamedTypes::writeReplace, PlanNamedTypes::readReplace), PlanNameRegistry.Entry.of(ScalarFunction.class, ToLower.class, PlanNamedTypes::writeToLower, PlanNamedTypes::readToLower), PlanNameRegistry.Entry.of(ScalarFunction.class, ToUpper.class, PlanNamedTypes::writeToUpper, PlanNamedTypes::readToUpper), PlanNameRegistry.Entry.of(ArithmeticOperation.class, Add.class, PlanNamedTypes::writeArithmeticOperation, PlanNamedTypes::readArithmeticOperation), PlanNameRegistry.Entry.of(ArithmeticOperation.class, Sub.class, PlanNamedTypes::writeArithmeticOperation, PlanNamedTypes::readArithmeticOperation), PlanNameRegistry.Entry.of(ArithmeticOperation.class, Mul.class, PlanNamedTypes::writeArithmeticOperation, PlanNamedTypes::readArithmeticOperation), PlanNameRegistry.Entry.of(ArithmeticOperation.class, Div.class, PlanNamedTypes::writeArithmeticOperation, PlanNamedTypes::readArithmeticOperation), PlanNameRegistry.Entry.of(ArithmeticOperation.class, Mod.class, PlanNamedTypes::writeArithmeticOperation, PlanNamedTypes::readArithmeticOperation), PlanNameRegistry.Entry.of(GroupingFunction.class, Bucket.class, PlanNamedTypes::writeBucket, PlanNamedTypes::readBucket), PlanNameRegistry.Entry.of(AggregateFunction.class, Avg.class, PlanNamedTypes::writeAggFunction, PlanNamedTypes::readAggFunction), PlanNameRegistry.Entry.of(AggregateFunction.class, Count.class, PlanNamedTypes::writeAggFunction, PlanNamedTypes::readAggFunction), PlanNameRegistry.Entry.of(AggregateFunction.class, CountDistinct.class, PlanNamedTypes::writeCountDistinct, PlanNamedTypes::readCountDistinct), PlanNameRegistry.Entry.of(AggregateFunction.class, Min.class, PlanNamedTypes::writeAggFunction, PlanNamedTypes::readAggFunction), PlanNameRegistry.Entry.of(AggregateFunction.class, Max.class, PlanNamedTypes::writeAggFunction, PlanNamedTypes::readAggFunction), PlanNameRegistry.Entry.of(AggregateFunction.class, Median.class, PlanNamedTypes::writeAggFunction, PlanNamedTypes::readAggFunction), PlanNameRegistry.Entry.of(AggregateFunction.class, MedianAbsoluteDeviation.class, PlanNamedTypes::writeAggFunction, PlanNamedTypes::readAggFunction), PlanNameRegistry.Entry.of(AggregateFunction.class, Percentile.class, PlanNamedTypes::writePercentile, PlanNamedTypes::readPercentile), PlanNameRegistry.Entry.of(AggregateFunction.class, SpatialCentroid.class, PlanNamedTypes::writeAggFunction, PlanNamedTypes::readAggFunction), PlanNameRegistry.Entry.of(AggregateFunction.class, Sum.class, PlanNamedTypes::writeAggFunction, PlanNamedTypes::readAggFunction), PlanNameRegistry.Entry.of(AggregateFunction.class, Values.class, PlanNamedTypes::writeAggFunction, PlanNamedTypes::readAggFunction), PlanNameRegistry.Entry.of(ScalarFunction.class, MvAvg.class, PlanNamedTypes::writeMvFunction, PlanNamedTypes::readMvFunction), PlanNameRegistry.Entry.of(ScalarFunction.class, MvCount.class, PlanNamedTypes::writeMvFunction, PlanNamedTypes::readMvFunction), PlanNameRegistry.Entry.of(ScalarFunction.class, MvConcat.class, PlanNamedTypes::writeMvConcat, PlanNamedTypes::readMvConcat), PlanNameRegistry.Entry.of(ScalarFunction.class, MvDedupe.class, PlanNamedTypes::writeMvFunction, PlanNamedTypes::readMvFunction), PlanNameRegistry.Entry.of(ScalarFunction.class, MvFirst.class, PlanNamedTypes::writeMvFunction, PlanNamedTypes::readMvFunction), PlanNameRegistry.Entry.of(ScalarFunction.class, MvLast.class, PlanNamedTypes::writeMvFunction, PlanNamedTypes::readMvFunction), PlanNameRegistry.Entry.of(ScalarFunction.class, MvMax.class, PlanNamedTypes::writeMvFunction, PlanNamedTypes::readMvFunction), PlanNameRegistry.Entry.of(ScalarFunction.class, MvMedian.class, PlanNamedTypes::writeMvFunction, PlanNamedTypes::readMvFunction), PlanNameRegistry.Entry.of(ScalarFunction.class, MvMin.class, PlanNamedTypes::writeMvFunction, PlanNamedTypes::readMvFunction), PlanNameRegistry.Entry.of(ScalarFunction.class, MvSort.class, PlanNamedTypes::writeMvSort, PlanNamedTypes::readMvSort), PlanNameRegistry.Entry.of(ScalarFunction.class, MvSlice.class, PlanNamedTypes::writeMvSlice, PlanNamedTypes::readMvSlice), PlanNameRegistry.Entry.of(ScalarFunction.class, MvSum.class, PlanNamedTypes::writeMvFunction, PlanNamedTypes::readMvFunction), PlanNameRegistry.Entry.of(ScalarFunction.class, MvZip.class, PlanNamedTypes::writeMvZip, PlanNamedTypes::readMvZip), PlanNameRegistry.Entry.of(Expression.class, Literal.class, PlanNamedTypes::writeLiteral, PlanNamedTypes::readLiteral), PlanNameRegistry.Entry.of(Expression.class, Order.class, PlanNamedTypes::writeOrder, PlanNamedTypes::readOrder));
    }

    static AggregateExec readAggregateExec(PlanStreamInput in) throws IOException {
        return new AggregateExec(in.readSource(), in.readPhysicalPlanNode(), in.readCollectionAsList(PlanNameRegistry.PlanReader.readerFromPlanReader(PlanStreamInput::readExpression)), PlanNamedTypes.readNamedExpressions(in), (AggregateExec.Mode)in.readEnum(AggregateExec.Mode.class), in.readOptionalVInt());
    }

    static void writeAggregateExec(PlanStreamOutput out, AggregateExec aggregateExec) throws IOException {
        out.writeNoSource();
        out.writePhysicalPlanNode(aggregateExec.child());
        out.writeCollection(aggregateExec.groupings(), PlanNameRegistry.PlanWriter.writerFromPlanWriter(PlanStreamOutput::writeExpression));
        PlanNamedTypes.writeNamedExpressions(out, aggregateExec.aggregates());
        out.writeEnum(aggregateExec.getMode());
        out.writeOptionalVInt(aggregateExec.estimatedRowSize());
    }

    static DissectExec readDissectExec(PlanStreamInput in) throws IOException {
        return new DissectExec(in.readSource(), in.readPhysicalPlanNode(), in.readExpression(), PlanNamedTypes.readDissectParser(in), PlanNamedTypes.readAttributes(in));
    }

    static void writeDissectExec(PlanStreamOutput out, DissectExec dissectExec) throws IOException {
        out.writeNoSource();
        out.writePhysicalPlanNode(dissectExec.child());
        out.writeExpression(dissectExec.inputExpression());
        PlanNamedTypes.writeDissectParser(out, dissectExec.parser());
        PlanNamedTypes.writeAttributes(out, dissectExec.extractedFields());
    }

    static EsQueryExec readEsQueryExec(PlanStreamInput in) throws IOException {
        return new EsQueryExec(in.readSource(), PlanNamedTypes.readEsIndex(in), PlanNamedTypes.readAttributes(in), (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class), in.readOptionalNamed(Expression.class), in.readOptionalCollectionAsList(PlanNameRegistry.PlanReader.readerFromPlanReader(PlanNamedTypes::readFieldSort)), in.readOptionalVInt());
    }

    static void writeEsQueryExec(PlanStreamOutput out, EsQueryExec esQueryExec) throws IOException {
        assert (esQueryExec.children().size() == 0);
        out.writeNoSource();
        PlanNamedTypes.writeEsIndex(out, esQueryExec.index());
        PlanNamedTypes.writeAttributes(out, esQueryExec.output());
        out.writeOptionalNamedWriteable((NamedWriteable)esQueryExec.query());
        out.writeOptionalExpression(esQueryExec.limit());
        out.writeOptionalCollection(esQueryExec.sorts(), PlanNameRegistry.PlanWriter.writerFromPlanWriter(PlanNamedTypes::writeFieldSort));
        out.writeOptionalInt(esQueryExec.estimatedRowSize());
    }

    static EsSourceExec readEsSourceExec(PlanStreamInput in) throws IOException {
        return new EsSourceExec(in.readSource(), PlanNamedTypes.readEsIndex(in), PlanNamedTypes.readAttributes(in), (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class));
    }

    static void writeEsSourceExec(PlanStreamOutput out, EsSourceExec esSourceExec) throws IOException {
        out.writeNoSource();
        PlanNamedTypes.writeEsIndex(out, esSourceExec.index());
        PlanNamedTypes.writeAttributes(out, esSourceExec.output());
        out.writeOptionalNamedWriteable((NamedWriteable)esSourceExec.query());
    }

    static EvalExec readEvalExec(PlanStreamInput in) throws IOException {
        return new EvalExec(in.readSource(), in.readPhysicalPlanNode(), PlanNamedTypes.readAliases(in));
    }

    static void writeEvalExec(PlanStreamOutput out, EvalExec evalExec) throws IOException {
        out.writeNoSource();
        out.writePhysicalPlanNode(evalExec.child());
        PlanNamedTypes.writeAliases(out, evalExec.fields());
    }

    static EnrichExec readEnrichExec(PlanStreamInput in) throws IOException {
        Map<String, String> concreteIndices;
        Enrich.Mode mode;
        Source source = in.readSource();
        PhysicalPlan child = in.readPhysicalPlanNode();
        NamedExpression matchField = in.readNamedExpression();
        String policyName = in.readString();
        String matchType = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_EXTENDED_ENRICH_TYPES) ? in.readString() : "match";
        String policyMatchField = in.readString();
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_MULTI_CLUSTERS_ENRICH)) {
            mode = (Enrich.Mode)in.readEnum(Enrich.Mode.class);
            concreteIndices = in.readMap(StreamInput::readString, StreamInput::readString);
        } else {
            mode = Enrich.Mode.ANY;
            EsIndex esIndex = PlanNamedTypes.readEsIndex(in);
            if (esIndex.concreteIndices().size() != 1) {
                throw new IllegalStateException("expected a single concrete enrich index; got " + esIndex.concreteIndices());
            }
            concreteIndices = Map.of("", (String)Iterables.get((Iterable)esIndex.concreteIndices(), (int)0));
        }
        return new EnrichExec(source, child, mode, matchType, matchField, policyName, policyMatchField, concreteIndices, PlanNamedTypes.readNamedExpressions(in));
    }

    static void writeEnrichExec(PlanStreamOutput out, EnrichExec enrich) throws IOException {
        out.writeNoSource();
        out.writePhysicalPlanNode(enrich.child());
        out.writeNamedExpression(enrich.matchField());
        out.writeString(enrich.policyName());
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_EXTENDED_ENRICH_TYPES)) {
            out.writeString(enrich.matchType());
        }
        out.writeString(enrich.policyMatchField());
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_MULTI_CLUSTERS_ENRICH)) {
            out.writeEnum(enrich.mode());
            out.writeMap(enrich.concreteIndices(), StreamOutput::writeString, StreamOutput::writeString);
        } else if (enrich.concreteIndices().keySet().equals(Set.of(""))) {
            String concreteIndex = enrich.concreteIndices().get("");
            PlanNamedTypes.writeEsIndex(out, new EsIndex(concreteIndex, Map.of(), Set.of(concreteIndex)));
        } else {
            throw new IllegalStateException("expected a single concrete enrich index; got " + enrich.concreteIndices());
        }
        PlanNamedTypes.writeNamedExpressions(out, enrich.enrichFields());
    }

    static ExchangeExec readExchangeExec(PlanStreamInput in) throws IOException {
        return new ExchangeExec(in.readSource(), PlanNamedTypes.readAttributes(in), in.readBoolean(), in.readPhysicalPlanNode());
    }

    static void writeExchangeExec(PlanStreamOutput out, ExchangeExec exchangeExec) throws IOException {
        out.writeNoSource();
        PlanNamedTypes.writeAttributes(out, exchangeExec.output());
        out.writeBoolean(exchangeExec.isInBetweenAggs());
        out.writePhysicalPlanNode(exchangeExec.child());
    }

    static ExchangeSinkExec readExchangeSinkExec(PlanStreamInput in) throws IOException {
        return new ExchangeSinkExec(in.readSource(), PlanNamedTypes.readAttributes(in), in.readBoolean(), in.readPhysicalPlanNode());
    }

    static void writeExchangeSinkExec(PlanStreamOutput out, ExchangeSinkExec exchangeSinkExec) throws IOException {
        out.writeNoSource();
        PlanNamedTypes.writeAttributes(out, exchangeSinkExec.output());
        out.writeBoolean(exchangeSinkExec.isIntermediateAgg());
        out.writePhysicalPlanNode(exchangeSinkExec.child());
    }

    static ExchangeSourceExec readExchangeSourceExec(PlanStreamInput in) throws IOException {
        return new ExchangeSourceExec(in.readSource(), PlanNamedTypes.readAttributes(in), in.readBoolean());
    }

    static void writeExchangeSourceExec(PlanStreamOutput out, ExchangeSourceExec exchangeSourceExec) throws IOException {
        PlanNamedTypes.writeAttributes(out, exchangeSourceExec.output());
        out.writeBoolean(exchangeSourceExec.isIntermediateAgg());
    }

    static FieldExtractExec readFieldExtractExec(PlanStreamInput in) throws IOException {
        return new FieldExtractExec(in.readSource(), in.readPhysicalPlanNode(), PlanNamedTypes.readAttributes(in));
    }

    static void writeFieldExtractExec(PlanStreamOutput out, FieldExtractExec fieldExtractExec) throws IOException {
        out.writeNoSource();
        out.writePhysicalPlanNode(fieldExtractExec.child());
        PlanNamedTypes.writeAttributes(out, fieldExtractExec.attributesToExtract());
    }

    static FilterExec readFilterExec(PlanStreamInput in) throws IOException {
        return new FilterExec(in.readSource(), in.readPhysicalPlanNode(), in.readExpression());
    }

    static void writeFilterExec(PlanStreamOutput out, FilterExec filterExec) throws IOException {
        out.writeNoSource();
        out.writePhysicalPlanNode(filterExec.child());
        out.writeExpression(filterExec.condition());
    }

    static FragmentExec readFragmentExec(PlanStreamInput in) throws IOException {
        return new FragmentExec(in.readSource(), in.readLogicalPlanNode(), (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class), in.readOptionalVInt(), in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_REDUCER_NODE_FRAGMENT) ? in.readOptionalPhysicalPlanNode() : null);
    }

    static void writeFragmentExec(PlanStreamOutput out, FragmentExec fragmentExec) throws IOException {
        out.writeNoSource();
        out.writeLogicalPlanNode(fragmentExec.fragment());
        out.writeOptionalNamedWriteable((NamedWriteable)fragmentExec.esFilter());
        out.writeOptionalVInt(fragmentExec.estimatedRowSize());
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_REDUCER_NODE_FRAGMENT)) {
            out.writeOptionalPhysicalPlanNode(fragmentExec.reducer());
        }
    }

    static GrokExec readGrokExec(PlanStreamInput in) throws IOException {
        Source source = in.readSource();
        return new GrokExec(source, in.readPhysicalPlanNode(), in.readExpression(), Grok.pattern(source, in.readString()), PlanNamedTypes.readAttributes(in));
    }

    static void writeGrokExec(PlanStreamOutput out, GrokExec grokExec) throws IOException {
        out.writeNoSource();
        out.writePhysicalPlanNode(grokExec.child());
        out.writeExpression(grokExec.inputExpression());
        out.writeString(grokExec.pattern().pattern());
        PlanNamedTypes.writeAttributes(out, grokExec.extractedFields());
    }

    static LimitExec readLimitExec(PlanStreamInput in) throws IOException {
        return new LimitExec(in.readSource(), in.readPhysicalPlanNode(), in.readNamed(Expression.class));
    }

    static void writeLimitExec(PlanStreamOutput out, LimitExec limitExec) throws IOException {
        out.writeNoSource();
        out.writePhysicalPlanNode(limitExec.child());
        out.writeExpression(limitExec.limit());
    }

    static MvExpandExec readMvExpandExec(PlanStreamInput in) throws IOException {
        return new MvExpandExec(in.readSource(), in.readPhysicalPlanNode(), in.readNamedExpression(), in.readAttribute());
    }

    static void writeMvExpandExec(PlanStreamOutput out, MvExpandExec mvExpandExec) throws IOException {
        out.writeNoSource();
        out.writePhysicalPlanNode(mvExpandExec.child());
        out.writeNamedExpression(mvExpandExec.target());
        out.writeAttribute(mvExpandExec.expanded());
    }

    static OrderExec readOrderExec(PlanStreamInput in) throws IOException {
        return new OrderExec(in.readSource(), in.readPhysicalPlanNode(), in.readCollectionAsList(PlanNameRegistry.PlanReader.readerFromPlanReader(PlanNamedTypes::readOrder)));
    }

    static void writeOrderExec(PlanStreamOutput out, OrderExec orderExec) throws IOException {
        out.writeNoSource();
        out.writePhysicalPlanNode(orderExec.child());
        out.writeCollection(orderExec.order(), PlanNameRegistry.PlanWriter.writerFromPlanWriter(PlanNamedTypes::writeOrder));
    }

    static ProjectExec readProjectExec(PlanStreamInput in) throws IOException {
        return new ProjectExec(in.readSource(), in.readPhysicalPlanNode(), PlanNamedTypes.readNamedExpressions(in));
    }

    static void writeProjectExec(PlanStreamOutput out, ProjectExec projectExec) throws IOException {
        out.writeNoSource();
        out.writePhysicalPlanNode(projectExec.child());
        PlanNamedTypes.writeNamedExpressions(out, projectExec.projections());
    }

    static RowExec readRowExec(PlanStreamInput in) throws IOException {
        return new RowExec(in.readSource(), PlanNamedTypes.readAliases(in));
    }

    static void writeRowExec(PlanStreamOutput out, RowExec rowExec) throws IOException {
        assert (rowExec.children().size() == 0);
        out.writeNoSource();
        PlanNamedTypes.writeAliases(out, rowExec.fields());
    }

    static ShowExec readShowExec(PlanStreamInput in) throws IOException {
        return new ShowExec(in.readSource(), PlanNamedTypes.readAttributes(in), (List)in.readGenericValue());
    }

    static void writeShowExec(PlanStreamOutput out, ShowExec showExec) throws IOException {
        out.writeNoSource();
        PlanNamedTypes.writeAttributes(out, showExec.output());
        out.writeGenericValue(showExec.values());
    }

    static TopNExec readTopNExec(PlanStreamInput in) throws IOException {
        return new TopNExec(in.readSource(), in.readPhysicalPlanNode(), in.readCollectionAsList(PlanNameRegistry.PlanReader.readerFromPlanReader(PlanNamedTypes::readOrder)), in.readNamed(Expression.class), in.readOptionalVInt());
    }

    static void writeTopNExec(PlanStreamOutput out, TopNExec topNExec) throws IOException {
        out.writeNoSource();
        out.writePhysicalPlanNode(topNExec.child());
        out.writeCollection(topNExec.order(), PlanNameRegistry.PlanWriter.writerFromPlanWriter(PlanNamedTypes::writeOrder));
        out.writeExpression(topNExec.limit());
        out.writeOptionalVInt(topNExec.estimatedRowSize());
    }

    static Aggregate readAggregate(PlanStreamInput in) throws IOException {
        return new Aggregate(in.readSource(), in.readLogicalPlanNode(), in.readCollectionAsList(PlanNameRegistry.PlanReader.readerFromPlanReader(PlanStreamInput::readExpression)), PlanNamedTypes.readNamedExpressions(in));
    }

    static void writeAggregate(PlanStreamOutput out, Aggregate aggregate) throws IOException {
        out.writeNoSource();
        out.writeLogicalPlanNode(aggregate.child());
        out.writeCollection(aggregate.groupings(), PlanNameRegistry.PlanWriter.writerFromPlanWriter(PlanStreamOutput::writeExpression));
        PlanNamedTypes.writeNamedExpressions(out, aggregate.aggregates());
    }

    static Dissect readDissect(PlanStreamInput in) throws IOException {
        return new Dissect(in.readSource(), in.readLogicalPlanNode(), in.readExpression(), PlanNamedTypes.readDissectParser(in), PlanNamedTypes.readAttributes(in));
    }

    static void writeDissect(PlanStreamOutput out, Dissect dissect) throws IOException {
        out.writeNoSource();
        out.writeLogicalPlanNode(dissect.child());
        out.writeExpression(dissect.input());
        PlanNamedTypes.writeDissectParser(out, dissect.parser());
        PlanNamedTypes.writeAttributes(out, dissect.extractedFields());
    }

    static EsRelation readEsRelation(PlanStreamInput in) throws IOException {
        Source source = in.readSource();
        EsIndex esIndex = PlanNamedTypes.readEsIndex(in);
        List<Attribute> attributes = PlanNamedTypes.readAttributes(in);
        if (PlanNamedTypes.supportingEsSourceOptions(in.getTransportVersion())) {
            PlanNamedTypes.readEsSourceOptions(in);
        }
        boolean frozen = in.readBoolean();
        return new EsRelation(source, esIndex, attributes, frozen);
    }

    static void writeEsRelation(PlanStreamOutput out, EsRelation relation) throws IOException {
        assert (relation.children().size() == 0);
        out.writeNoSource();
        PlanNamedTypes.writeEsIndex(out, relation.index());
        PlanNamedTypes.writeAttributes(out, relation.output());
        if (PlanNamedTypes.supportingEsSourceOptions(out.getTransportVersion())) {
            PlanNamedTypes.writeEsSourceOptions(out);
        }
        out.writeBoolean(relation.frozen());
    }

    private static boolean supportingEsSourceOptions(TransportVersion version) {
        return version.onOrAfter((VersionId)TransportVersions.ESQL_ES_SOURCE_OPTIONS);
    }

    private static void readEsSourceOptions(PlanStreamInput in) throws IOException {
        in.readOptionalString();
        in.readOptionalString();
        in.readOptionalString();
    }

    private static void writeEsSourceOptions(PlanStreamOutput out) throws IOException {
        out.writeOptionalString(null);
        out.writeOptionalString(null);
        out.writeOptionalString(null);
    }

    static Eval readEval(PlanStreamInput in) throws IOException {
        return new Eval(in.readSource(), in.readLogicalPlanNode(), PlanNamedTypes.readAliases(in));
    }

    static void writeEval(PlanStreamOutput out, Eval eval) throws IOException {
        out.writeNoSource();
        out.writeLogicalPlanNode(eval.child());
        PlanNamedTypes.writeAliases(out, eval.fields());
    }

    static Enrich readEnrich(PlanStreamInput in) throws IOException {
        Map<String, String> concreteIndices;
        Enrich.Mode mode = Enrich.Mode.ANY;
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_ENRICH_POLICY_CCQ_MODE)) {
            mode = (Enrich.Mode)in.readEnum(Enrich.Mode.class);
        }
        Source source = in.readSource();
        LogicalPlan child = in.readLogicalPlanNode();
        Expression policyName = in.readExpression();
        NamedExpression matchField = in.readNamedExpression();
        if (in.getTransportVersion().before((VersionId)TransportVersions.ESQL_MULTI_CLUSTERS_ENRICH)) {
            in.readString();
        }
        EnrichPolicy policy = new EnrichPolicy((StreamInput)in);
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_MULTI_CLUSTERS_ENRICH)) {
            concreteIndices = in.readMap(StreamInput::readString, StreamInput::readString);
        } else {
            EsIndex esIndex = PlanNamedTypes.readEsIndex(in);
            if (esIndex.concreteIndices().size() > 1) {
                throw new IllegalStateException("expected a single enrich index; got " + esIndex);
            }
            concreteIndices = Map.of("", (String)Iterables.get((Iterable)esIndex.concreteIndices(), (int)0));
        }
        return new Enrich(source, child, mode, policyName, matchField, policy, concreteIndices, PlanNamedTypes.readNamedExpressions(in));
    }

    static void writeEnrich(PlanStreamOutput out, Enrich enrich) throws IOException {
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_ENRICH_POLICY_CCQ_MODE)) {
            out.writeEnum(enrich.mode());
        }
        out.writeNoSource();
        out.writeLogicalPlanNode(enrich.child());
        out.writeExpression(enrich.policyName());
        out.writeNamedExpression(enrich.matchField());
        if (out.getTransportVersion().before((VersionId)TransportVersions.ESQL_MULTI_CLUSTERS_ENRICH)) {
            out.writeString(BytesRefs.toString((Object)enrich.policyName().fold()));
        }
        enrich.policy().writeTo((StreamOutput)out);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_MULTI_CLUSTERS_ENRICH)) {
            out.writeMap(enrich.concreteIndices(), StreamOutput::writeString, StreamOutput::writeString);
        } else {
            Map<String, String> concreteIndices = enrich.concreteIndices();
            if (concreteIndices.keySet().equals(Set.of(""))) {
                String enrichIndex = concreteIndices.get("");
                EsIndex esIndex = new EsIndex(enrichIndex, Map.of(), Set.of(enrichIndex));
                PlanNamedTypes.writeEsIndex(out, esIndex);
            } else {
                throw new IllegalStateException("expected a single enrich index; got " + concreteIndices);
            }
        }
        PlanNamedTypes.writeNamedExpressions(out, enrich.enrichFields());
    }

    static EsqlProject readEsqlProject(PlanStreamInput in) throws IOException {
        return new EsqlProject(in.readSource(), in.readLogicalPlanNode(), PlanNamedTypes.readNamedExpressions(in));
    }

    static void writeEsqlProject(PlanStreamOutput out, EsqlProject project) throws IOException {
        out.writeNoSource();
        out.writeLogicalPlanNode(project.child());
        PlanNamedTypes.writeNamedExpressions(out, project.projections());
    }

    static Filter readFilter(PlanStreamInput in) throws IOException {
        return new Filter(in.readSource(), in.readLogicalPlanNode(), in.readExpression());
    }

    static void writeFilter(PlanStreamOutput out, Filter filter) throws IOException {
        out.writeNoSource();
        out.writeLogicalPlanNode(filter.child());
        out.writeExpression(filter.condition());
    }

    static Grok readGrok(PlanStreamInput in) throws IOException {
        Source source = in.readSource();
        return new Grok(source, in.readLogicalPlanNode(), in.readExpression(), Grok.pattern(source, in.readString()), PlanNamedTypes.readAttributes(in));
    }

    static void writeGrok(PlanStreamOutput out, Grok grok) throws IOException {
        out.writeNoSource();
        out.writeLogicalPlanNode(grok.child());
        out.writeExpression(grok.input());
        out.writeString(grok.parser().pattern());
        PlanNamedTypes.writeAttributes(out, grok.extractedFields());
    }

    static Limit readLimit(PlanStreamInput in) throws IOException {
        return new Limit(in.readSource(), in.readNamed(Expression.class), in.readLogicalPlanNode());
    }

    static void writeLimit(PlanStreamOutput out, Limit limit) throws IOException {
        out.writeNoSource();
        out.writeExpression(limit.limit());
        out.writeLogicalPlanNode(limit.child());
    }

    static MvExpand readMvExpand(PlanStreamInput in) throws IOException {
        return new MvExpand(in.readSource(), in.readLogicalPlanNode(), in.readNamedExpression(), in.readAttribute());
    }

    static void writeMvExpand(PlanStreamOutput out, MvExpand mvExpand) throws IOException {
        out.writeNoSource();
        out.writeLogicalPlanNode(mvExpand.child());
        out.writeNamedExpression(mvExpand.target());
        out.writeAttribute(mvExpand.expanded());
    }

    static OrderBy readOrderBy(PlanStreamInput in) throws IOException {
        return new OrderBy(in.readSource(), in.readLogicalPlanNode(), in.readCollectionAsList(PlanNameRegistry.PlanReader.readerFromPlanReader(PlanNamedTypes::readOrder)));
    }

    static void writeOrderBy(PlanStreamOutput out, OrderBy order) throws IOException {
        out.writeNoSource();
        out.writeLogicalPlanNode(order.child());
        out.writeCollection(order.order(), PlanNameRegistry.PlanWriter.writerFromPlanWriter(PlanNamedTypes::writeOrder));
    }

    static Project readProject(PlanStreamInput in) throws IOException {
        return new Project(in.readSource(), in.readLogicalPlanNode(), PlanNamedTypes.readNamedExpressions(in));
    }

    static void writeProject(PlanStreamOutput out, Project project) throws IOException {
        out.writeNoSource();
        out.writeLogicalPlanNode(project.child());
        PlanNamedTypes.writeNamedExpressions(out, project.projections());
    }

    static TopN readTopN(PlanStreamInput in) throws IOException {
        return new TopN(in.readSource(), in.readLogicalPlanNode(), in.readCollectionAsList(PlanNameRegistry.PlanReader.readerFromPlanReader(PlanNamedTypes::readOrder)), in.readNamed(Expression.class));
    }

    static void writeTopN(PlanStreamOutput out, TopN topN) throws IOException {
        out.writeNoSource();
        out.writeLogicalPlanNode(topN.child());
        out.writeCollection(topN.order(), PlanNameRegistry.PlanWriter.writerFromPlanWriter(PlanNamedTypes::writeOrder));
        out.writeExpression(topN.limit());
    }

    private static List<Attribute> readAttributes(PlanStreamInput in) throws IOException {
        return in.readCollectionAsList(PlanNameRegistry.PlanReader.readerFromPlanReader(PlanStreamInput::readAttribute));
    }

    static void writeAttributes(PlanStreamOutput out, List<Attribute> attributes) throws IOException {
        out.writeCollection(attributes, PlanNameRegistry.PlanWriter.writerFromPlanWriter(PlanStreamOutput::writeAttribute));
    }

    private static List<NamedExpression> readNamedExpressions(PlanStreamInput in) throws IOException {
        return in.readCollectionAsList(PlanNameRegistry.PlanReader.readerFromPlanReader(PlanStreamInput::readNamedExpression));
    }

    static void writeNamedExpressions(PlanStreamOutput out, List<? extends NamedExpression> namedExpressions) throws IOException {
        out.writeCollection(namedExpressions, PlanNameRegistry.PlanWriter.writerFromPlanWriter(PlanStreamOutput::writeNamedExpression));
    }

    private static List<Alias> readAliases(PlanStreamInput in) throws IOException {
        return in.readCollectionAsList(PlanNameRegistry.PlanReader.readerFromPlanReader(PlanNamedTypes::readAlias));
    }

    static void writeAliases(PlanStreamOutput out, List<Alias> aliases) throws IOException {
        out.writeCollection(aliases, PlanNameRegistry.PlanWriter.writerFromPlanWriter(PlanNamedTypes::writeAlias));
    }

    static FieldAttribute readFieldAttribute(PlanStreamInput in) throws IOException {
        return new FieldAttribute(in.readSource(), in.readOptionalWithReader(PlanNamedTypes::readFieldAttribute), in.readString(), in.dataTypeFromTypeName(in.readString()), in.readEsFieldNamed(), in.readOptionalString(), (Nullability)in.readEnum(Nullability.class), in.nameIdFromLongValue(in.readLong()), in.readBoolean());
    }

    static void writeFieldAttribute(PlanStreamOutput out, FieldAttribute fileAttribute) throws IOException {
        out.writeNoSource();
        out.writeOptionalWriteable(fileAttribute.parent() == null ? null : o -> PlanNamedTypes.writeFieldAttribute(out, fileAttribute.parent()));
        out.writeString(fileAttribute.name());
        out.writeString(fileAttribute.dataType().typeName());
        out.writeNamed(EsField.class, fileAttribute.field());
        out.writeOptionalString(fileAttribute.qualifier());
        out.writeEnum((Enum)fileAttribute.nullable());
        out.writeLong(EsqlDataTypeConverter.stringToLong(fileAttribute.id().toString()));
        out.writeBoolean(fileAttribute.synthetic());
    }

    static ReferenceAttribute readReferenceAttr(PlanStreamInput in) throws IOException {
        return new ReferenceAttribute(in.readSource(), in.readString(), in.dataTypeFromTypeName(in.readString()), in.readOptionalString(), (Nullability)in.readEnum(Nullability.class), in.nameIdFromLongValue(in.readLong()), in.readBoolean());
    }

    static void writeReferenceAttr(PlanStreamOutput out, ReferenceAttribute referenceAttribute) throws IOException {
        out.writeNoSource();
        out.writeString(referenceAttribute.name());
        out.writeString(referenceAttribute.dataType().typeName());
        out.writeOptionalString(referenceAttribute.qualifier());
        out.writeEnum((Enum)referenceAttribute.nullable());
        out.writeLong(EsqlDataTypeConverter.stringToLong(referenceAttribute.id().toString()));
        out.writeBoolean(referenceAttribute.synthetic());
    }

    static MetadataAttribute readMetadataAttr(PlanStreamInput in) throws IOException {
        return new MetadataAttribute(in.readSource(), in.readString(), in.dataTypeFromTypeName(in.readString()), in.readOptionalString(), (Nullability)in.readEnum(Nullability.class), in.nameIdFromLongValue(in.readLong()), in.readBoolean(), in.readBoolean());
    }

    static void writeMetadataAttr(PlanStreamOutput out, MetadataAttribute metadataAttribute) throws IOException {
        out.writeNoSource();
        out.writeString(metadataAttribute.name());
        out.writeString(metadataAttribute.dataType().typeName());
        out.writeOptionalString(metadataAttribute.qualifier());
        out.writeEnum((Enum)metadataAttribute.nullable());
        out.writeLong(EsqlDataTypeConverter.stringToLong(metadataAttribute.id().toString()));
        out.writeBoolean(metadataAttribute.synthetic());
        out.writeBoolean(metadataAttribute.searchable());
    }

    static UnsupportedAttribute readUnsupportedAttr(PlanStreamInput in) throws IOException {
        return new UnsupportedAttribute(in.readSource(), in.readString(), PlanNamedTypes.readUnsupportedEsField(in), in.readOptionalString(), in.nameIdFromLongValue(in.readLong()));
    }

    static void writeUnsupportedAttr(PlanStreamOutput out, UnsupportedAttribute unsupportedAttribute) throws IOException {
        out.writeNoSource();
        out.writeString(unsupportedAttribute.name());
        PlanNamedTypes.writeUnsupportedEsField(out, unsupportedAttribute.field());
        out.writeOptionalString(unsupportedAttribute.hasCustomMessage() ? unsupportedAttribute.unresolvedMessage() : null);
        out.writeLong(EsqlDataTypeConverter.stringToLong(unsupportedAttribute.id().toString()));
    }

    static EsField readEsField(PlanStreamInput in) throws IOException {
        return new EsField(in.readString(), in.dataTypeFromTypeName(in.readString()), in.readImmutableMap(StreamInput::readString, PlanNameRegistry.PlanReader.readerFromPlanReader(PlanStreamInput::readEsFieldNamed)), in.readBoolean(), in.readBoolean());
    }

    static void writeEsField(PlanStreamOutput out, EsField esField) throws IOException {
        out.writeString(esField.getName());
        out.writeString(esField.getDataType().typeName());
        out.writeMap(esField.getProperties(), (o, v) -> out.writeNamed(EsField.class, v));
        out.writeBoolean(esField.isAggregatable());
        out.writeBoolean(esField.isAlias());
    }

    static DateEsField readDateEsField(PlanStreamInput in) throws IOException {
        return DateEsField.dateEsField((String)in.readString(), (Map)in.readImmutableMap(StreamInput::readString, PlanNameRegistry.PlanReader.readerFromPlanReader(PlanStreamInput::readEsFieldNamed)), (boolean)in.readBoolean());
    }

    static void writeDateEsField(PlanStreamOutput out, DateEsField dateEsField) throws IOException {
        out.writeString(dateEsField.getName());
        out.writeMap(dateEsField.getProperties(), (o, v) -> out.writeNamed(EsField.class, v));
        out.writeBoolean(dateEsField.isAggregatable());
    }

    static InvalidMappedField readInvalidMappedField(PlanStreamInput in) throws IOException {
        return new InvalidMappedField(in.readString(), in.readString(), in.readImmutableMap(StreamInput::readString, PlanNameRegistry.PlanReader.readerFromPlanReader(PlanStreamInput::readEsFieldNamed)));
    }

    static void writeInvalidMappedField(PlanStreamOutput out, InvalidMappedField field) throws IOException {
        out.writeString(field.getName());
        out.writeString(field.errorMessage());
        out.writeMap(field.getProperties(), (o, v) -> out.writeNamed(EsField.class, v));
    }

    static KeywordEsField readKeywordEsField(PlanStreamInput in) throws IOException {
        return new KeywordEsField(in.readString(), in.readImmutableMap(StreamInput::readString, PlanNameRegistry.PlanReader.readerFromPlanReader(PlanStreamInput::readEsFieldNamed)), in.readBoolean(), in.readInt(), in.readBoolean(), in.readBoolean());
    }

    static void writeKeywordEsField(PlanStreamOutput out, KeywordEsField keywordEsField) throws IOException {
        out.writeString(keywordEsField.getName());
        out.writeMap(keywordEsField.getProperties(), (o, v) -> out.writeNamed(EsField.class, v));
        out.writeBoolean(keywordEsField.isAggregatable());
        out.writeInt(keywordEsField.getPrecision());
        out.writeBoolean(keywordEsField.getNormalized());
        out.writeBoolean(keywordEsField.isAlias());
    }

    static TextEsField readTextEsField(PlanStreamInput in) throws IOException {
        return new TextEsField(in.readString(), in.readImmutableMap(StreamInput::readString, PlanNameRegistry.PlanReader.readerFromPlanReader(PlanStreamInput::readEsFieldNamed)), in.readBoolean(), in.readBoolean());
    }

    static void writeTextEsField(PlanStreamOutput out, TextEsField textEsField) throws IOException {
        out.writeString(textEsField.getName());
        out.writeMap(textEsField.getProperties(), (o, v) -> out.writeNamed(EsField.class, v));
        out.writeBoolean(textEsField.isAggregatable());
        out.writeBoolean(textEsField.isAlias());
    }

    static UnsupportedEsField readUnsupportedEsField(PlanStreamInput in) throws IOException {
        return new UnsupportedEsField(in.readString(), in.readString(), in.readOptionalString(), in.readImmutableMap(StreamInput::readString, PlanNameRegistry.PlanReader.readerFromPlanReader(PlanStreamInput::readEsFieldNamed)));
    }

    static void writeUnsupportedEsField(PlanStreamOutput out, UnsupportedEsField unsupportedEsField) throws IOException {
        out.writeString(unsupportedEsField.getName());
        out.writeString(unsupportedEsField.getOriginalType());
        out.writeOptionalString(unsupportedEsField.getInherited());
        out.writeMap(unsupportedEsField.getProperties(), (o, v) -> out.writeNamed(EsField.class, v));
    }

    static BinaryComparison readBinComparison(PlanStreamInput in, String name) throws IOException {
        Source source = in.readSource();
        BinaryComparisonProcessor.BinaryComparisonOperation operation = (BinaryComparisonProcessor.BinaryComparisonOperation)in.readEnum(BinaryComparisonProcessor.BinaryComparisonOperation.class);
        Expression left = in.readExpression();
        Expression right = in.readExpression();
        ZoneId zoneId = in.readOptionalZoneId();
        return switch (operation) {
            default -> throw new IncompatibleClassChangeError();
            case BinaryComparisonProcessor.BinaryComparisonOperation.EQ -> new Equals(source, left, right, zoneId);
            case BinaryComparisonProcessor.BinaryComparisonOperation.NULLEQ -> new NullEquals(source, left, right, zoneId);
            case BinaryComparisonProcessor.BinaryComparisonOperation.NEQ -> new NotEquals(source, left, right, zoneId);
            case BinaryComparisonProcessor.BinaryComparisonOperation.GT -> new GreaterThan(source, left, right, zoneId);
            case BinaryComparisonProcessor.BinaryComparisonOperation.GTE -> new GreaterThanOrEqual(source, left, right, zoneId);
            case BinaryComparisonProcessor.BinaryComparisonOperation.LT -> new LessThan(source, left, right, zoneId);
            case BinaryComparisonProcessor.BinaryComparisonOperation.LTE -> new LessThanOrEqual(source, left, right, zoneId);
        };
    }

    static void writeBinComparison(PlanStreamOutput out, BinaryComparison binaryComparison) throws IOException {
        out.writeSource(binaryComparison.source());
        out.writeEnum((Enum)((BinaryComparisonProcessor.BinaryComparisonOperation)binaryComparison.function()));
        out.writeExpression(binaryComparison.left());
        out.writeExpression(binaryComparison.right());
        out.writeOptionalZoneId(binaryComparison.zoneId());
    }

    static InsensitiveEquals readInsensitiveEquals(PlanStreamInput in, String name) throws IOException {
        Source source = in.readSource();
        Expression left = in.readExpression();
        Expression right = in.readExpression();
        return new InsensitiveEquals(source, left, right);
    }

    static void writeInsensitiveEquals(PlanStreamOutput out, InsensitiveEquals eq) throws IOException {
        out.writeSource(eq.source());
        out.writeExpression(eq.left());
        out.writeExpression(eq.right());
    }

    static In readInComparison(PlanStreamInput in) throws IOException {
        return new In(in.readSource(), in.readExpression(), in.readCollectionAsList(PlanNameRegistry.PlanReader.readerFromPlanReader(PlanStreamInput::readExpression)));
    }

    static void writeInComparison(PlanStreamOutput out, In in) throws IOException {
        out.writeSource(in.source());
        out.writeExpression(in.value());
        out.writeCollection(in.list(), PlanNameRegistry.PlanWriter.writerFromPlanWriter(PlanStreamOutput::writeExpression));
    }

    static WildcardLike readWildcardLike(PlanStreamInput in, String name) throws IOException {
        return new WildcardLike(in.readSource(), in.readExpression(), new WildcardPattern(in.readString()));
    }

    static void writeWildcardLike(PlanStreamOutput out, WildcardLike like) throws IOException {
        out.writeSource(like.source());
        out.writeExpression(like.field());
        out.writeString(((WildcardPattern)like.pattern()).pattern());
    }

    static RLike readRLike(PlanStreamInput in, String name) throws IOException {
        return new RLike(in.readSource(), in.readExpression(), new RLikePattern(in.readString()));
    }

    static void writeRLike(PlanStreamOutput out, RLike like) throws IOException {
        out.writeSource(like.source());
        out.writeExpression(like.field());
        out.writeString(((RLikePattern)like.pattern()).asJavaRegex());
    }

    static BinaryLogic readBinaryLogic(PlanStreamInput in, String name) throws IOException {
        Source source = in.readSource();
        Expression left = in.readExpression();
        Expression right = in.readExpression();
        return (BinaryLogic)BINARY_LOGIC_CTRS.get(name).apply((Object)source, (Object)left, (Object)right);
    }

    static void writeBinaryLogic(PlanStreamOutput out, BinaryLogic binaryLogic) throws IOException {
        out.writeNoSource();
        out.writeExpression(binaryLogic.left());
        out.writeExpression(binaryLogic.right());
    }

    static org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction readESQLUnaryScalar(PlanStreamInput in, String name) throws IOException {
        BiFunction<Source, Expression, org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction> ctr = ESQL_UNARY_SCALAR_CTRS.get(name);
        if (ctr == null) {
            throw new IOException("Constructor for ESQLUnaryScalar not found for name:" + name);
        }
        return ctr.apply(in.readSource(), in.readExpression());
    }

    static void writeESQLUnaryScalar(PlanStreamOutput out, org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction function) throws IOException {
        out.writeSource(function.source());
        out.writeExpression(function.field());
    }

    static ScalarFunction readNoArgScalar(PlanStreamInput in, String name) throws IOException {
        Function<Source, ScalarFunction> ctr = NO_ARG_SCALAR_CTRS.get(name);
        if (ctr == null) {
            throw new IOException("Constructor not found:" + name);
        }
        return ctr.apply(in.readSource());
    }

    static void writeNoArgScalar(PlanStreamOutput out, ScalarFunction function) throws IOException {
        out.writeNoSource();
    }

    static UnaryScalarFunction readQLUnaryScalar(PlanStreamInput in, String name) throws IOException {
        BiFunction<Source, Expression, UnaryScalarFunction> ctr = QL_UNARY_SCALAR_CTRS.get(name);
        if (ctr == null) {
            throw new IOException("Constructor for QLUnaryScalar not found for name:" + name);
        }
        return ctr.apply(in.readSource(), in.readExpression());
    }

    static void writeQLUnaryScalar(PlanStreamOutput out, UnaryScalarFunction function) throws IOException {
        out.writeSource(function.source());
        out.writeExpression(function.field());
    }

    static Atan2 readAtan2(PlanStreamInput in) throws IOException {
        return new Atan2(in.readSource(), in.readExpression(), in.readExpression());
    }

    static void writeAtan2(PlanStreamOutput out, Atan2 atan2) throws IOException {
        out.writeSource(atan2.source());
        out.writeExpression(atan2.y());
        out.writeExpression(atan2.x());
    }

    static Bucket readBucket(PlanStreamInput in) throws IOException {
        return new Bucket(in.readSource(), in.readExpression(), in.readExpression(), in.readOptionalNamed(Expression.class), in.readOptionalNamed(Expression.class));
    }

    static void writeBucket(PlanStreamOutput out, Bucket bucket) throws IOException {
        out.writeSource(bucket.source());
        out.writeExpression(bucket.field());
        out.writeExpression(bucket.buckets());
        out.writeOptionalExpression(bucket.from());
        out.writeOptionalExpression(bucket.to());
    }

    static ScalarFunction readVarag(PlanStreamInput in, String name) throws IOException {
        return (ScalarFunction)VARARG_CTORS.get(name).apply((Object)in.readSource(), (Object)in.readExpression(), (Object)in.readCollectionAsList(PlanNameRegistry.PlanReader.readerFromPlanReader(PlanStreamInput::readExpression)));
    }

    static void writeVararg(PlanStreamOutput out, ScalarFunction vararg) throws IOException {
        out.writeSource(vararg.source());
        out.writeExpression((Expression)vararg.children().get(0));
        out.writeCollection(vararg.children().subList(1, vararg.children().size()), PlanNameRegistry.PlanWriter.writerFromPlanWriter(PlanStreamOutput::writeExpression));
    }

    static CountDistinct readCountDistinct(PlanStreamInput in) throws IOException {
        return new CountDistinct(in.readSource(), in.readExpression(), in.readOptionalNamed(Expression.class));
    }

    static void writeCountDistinct(PlanStreamOutput out, CountDistinct countDistinct) throws IOException {
        List fields = countDistinct.children();
        assert (fields.size() == 1 || fields.size() == 2);
        out.writeNoSource();
        out.writeExpression((Expression)fields.get(0));
        out.writeOptionalWriteable(fields.size() == 2 ? o -> out.writeExpression((Expression)fields.get(1)) : null);
    }

    static DateDiff readDateDiff(PlanStreamInput in) throws IOException {
        return new DateDiff(in.readSource(), in.readExpression(), in.readExpression(), in.readExpression());
    }

    static void writeDateDiff(PlanStreamOutput out, DateDiff function) throws IOException {
        out.writeNoSource();
        List fields = function.children();
        assert (fields.size() == 3);
        out.writeExpression((Expression)fields.get(0));
        out.writeExpression((Expression)fields.get(1));
        out.writeExpression((Expression)fields.get(2));
    }

    static DateExtract readDateExtract(PlanStreamInput in) throws IOException {
        return new DateExtract(in.readSource(), in.readExpression(), in.readExpression(), in.configuration());
    }

    static void writeDateExtract(PlanStreamOutput out, DateExtract function) throws IOException {
        out.writeSource(function.source());
        List fields = function.children();
        assert (fields.size() == 2);
        out.writeExpression((Expression)fields.get(0));
        out.writeExpression((Expression)fields.get(1));
    }

    static DateFormat readDateFormat(PlanStreamInput in) throws IOException {
        return new DateFormat(in.readSource(), in.readExpression(), in.readOptionalNamed(Expression.class), in.configuration());
    }

    static void writeDateFormat(PlanStreamOutput out, DateFormat dateFormat) throws IOException {
        out.writeSource(dateFormat.source());
        List fields = dateFormat.children();
        assert (fields.size() == 1 || fields.size() == 2);
        out.writeExpression((Expression)fields.get(0));
        out.writeOptionalWriteable(fields.size() == 2 ? o -> out.writeExpression((Expression)fields.get(1)) : null);
    }

    static DateParse readDateTimeParse(PlanStreamInput in) throws IOException {
        return new DateParse(in.readSource(), in.readExpression(), in.readOptionalNamed(Expression.class));
    }

    static void writeDateTimeParse(PlanStreamOutput out, DateParse function) throws IOException {
        out.writeSource(function.source());
        List fields = function.children();
        assert (fields.size() == 1 || fields.size() == 2);
        out.writeExpression((Expression)fields.get(0));
        out.writeOptionalWriteable(fields.size() == 2 ? o -> out.writeExpression((Expression)fields.get(1)) : null);
    }

    static DateTrunc readDateTrunc(PlanStreamInput in) throws IOException {
        return new DateTrunc(in.readSource(), in.readExpression(), in.readExpression());
    }

    static void writeDateTrunc(PlanStreamOutput out, DateTrunc dateTrunc) throws IOException {
        out.writeSource(dateTrunc.source());
        List fields = dateTrunc.children();
        assert (fields.size() == 2);
        out.writeExpression((Expression)fields.get(0));
        out.writeExpression((Expression)fields.get(1));
    }

    static SpatialIntersects readIntersects(PlanStreamInput in) throws IOException {
        return new SpatialIntersects(Source.EMPTY, in.readExpression(), in.readExpression());
    }

    static SpatialDisjoint readDisjoint(PlanStreamInput in) throws IOException {
        return new SpatialDisjoint(Source.EMPTY, in.readExpression(), in.readExpression());
    }

    static SpatialContains readContains(PlanStreamInput in) throws IOException {
        return new SpatialContains(Source.EMPTY, in.readExpression(), in.readExpression());
    }

    static SpatialWithin readWithin(PlanStreamInput in) throws IOException {
        return new SpatialWithin(Source.EMPTY, in.readExpression(), in.readExpression());
    }

    static void writeSpatialRelatesFunction(PlanStreamOutput out, SpatialRelatesFunction spatialRelatesFunction) throws IOException {
        out.writeExpression(spatialRelatesFunction.left());
        out.writeExpression(spatialRelatesFunction.right());
    }

    static Now readNow(PlanStreamInput in) throws IOException {
        return new Now(in.readSource(), in.configuration());
    }

    static void writeNow(PlanStreamOutput out, Now function) throws IOException {
        out.writeNoSource();
    }

    static Round readRound(PlanStreamInput in) throws IOException {
        return new Round(in.readSource(), in.readExpression(), in.readOptionalNamed(Expression.class));
    }

    static void writeRound(PlanStreamOutput out, Round round) throws IOException {
        out.writeSource(round.source());
        out.writeExpression(round.field());
        out.writeOptionalExpression(round.decimals());
    }

    static Pow readPow(PlanStreamInput in) throws IOException {
        return new Pow(in.readSource(), in.readExpression(), in.readExpression());
    }

    static void writePow(PlanStreamOutput out, Pow pow) throws IOException {
        out.writeSource(pow.source());
        out.writeExpression(pow.base());
        out.writeExpression(pow.exponent());
    }

    static Percentile readPercentile(PlanStreamInput in) throws IOException {
        return new Percentile(in.readSource(), in.readExpression(), in.readExpression());
    }

    static void writePercentile(PlanStreamOutput out, Percentile percentile) throws IOException {
        List fields = percentile.children();
        assert (fields.size() == 2) : "percentile() aggregation must have two arguments";
        out.writeNoSource();
        out.writeExpression((Expression)fields.get(0));
        out.writeExpression((Expression)fields.get(1));
    }

    static StartsWith readStartsWith(PlanStreamInput in) throws IOException {
        return new StartsWith(in.readSource(), in.readExpression(), in.readExpression());
    }

    static void writeStartsWith(PlanStreamOutput out, StartsWith startsWith) throws IOException {
        out.writeSource(startsWith.source());
        List fields = startsWith.children();
        assert (fields.size() == 2);
        out.writeExpression((Expression)fields.get(0));
        out.writeExpression((Expression)fields.get(1));
    }

    static EndsWith readEndsWith(PlanStreamInput in) throws IOException {
        return new EndsWith(in.readSource(), in.readExpression(), in.readExpression());
    }

    static void writeEndsWith(PlanStreamOutput out, EndsWith endsWith) throws IOException {
        List fields = endsWith.children();
        assert (fields.size() == 2);
        out.writeNoSource();
        out.writeExpression((Expression)fields.get(0));
        out.writeExpression((Expression)fields.get(1));
    }

    static Substring readSubstring(PlanStreamInput in) throws IOException {
        return new Substring(in.readSource(), in.readExpression(), in.readExpression(), in.readOptionalNamed(Expression.class));
    }

    static void writeSubstring(PlanStreamOutput out, Substring substring) throws IOException {
        out.writeSource(substring.source());
        List fields = substring.children();
        assert (fields.size() == 2 || fields.size() == 3);
        out.writeExpression((Expression)fields.get(0));
        out.writeExpression((Expression)fields.get(1));
        out.writeOptionalWriteable(fields.size() == 3 ? o -> out.writeExpression((Expression)fields.get(2)) : null);
    }

    static Locate readLocate(PlanStreamInput in) throws IOException {
        return new Locate(in.readSource(), in.readExpression(), in.readExpression(), in.readOptionalNamed(Expression.class));
    }

    static void writeLocate(PlanStreamOutput out, Locate locate) throws IOException {
        out.writeSource(locate.source());
        List fields = locate.children();
        assert (fields.size() == 2 || fields.size() == 3);
        out.writeExpression((Expression)fields.get(0));
        out.writeExpression((Expression)fields.get(1));
        out.writeOptionalWriteable(fields.size() == 3 ? o -> out.writeExpression((Expression)fields.get(2)) : null);
    }

    static Replace readReplace(PlanStreamInput in) throws IOException {
        return new Replace(Source.EMPTY, in.readExpression(), in.readExpression(), in.readExpression());
    }

    static void writeReplace(PlanStreamOutput out, Replace replace) throws IOException {
        List fields = replace.children();
        assert (fields.size() == 3);
        out.writeExpression((Expression)fields.get(0));
        out.writeExpression((Expression)fields.get(1));
        out.writeExpression((Expression)fields.get(2));
    }

    static ToLower readToLower(PlanStreamInput in) throws IOException {
        return new ToLower(Source.EMPTY, in.readExpression(), (Configuration)in.configuration());
    }

    static void writeToLower(PlanStreamOutput out, ToLower toLower) throws IOException {
        out.writeExpression(toLower.field());
    }

    static ToUpper readToUpper(PlanStreamInput in) throws IOException {
        return new ToUpper(Source.EMPTY, in.readExpression(), (Configuration)in.configuration());
    }

    static void writeToUpper(PlanStreamOutput out, ToUpper toUpper) throws IOException {
        out.writeExpression(toUpper.field());
    }

    static Left readLeft(PlanStreamInput in) throws IOException {
        return new Left(in.readSource(), in.readExpression(), in.readExpression());
    }

    static void writeLeft(PlanStreamOutput out, Left left) throws IOException {
        out.writeSource(left.source());
        List fields = left.children();
        assert (fields.size() == 2);
        out.writeExpression((Expression)fields.get(0));
        out.writeExpression((Expression)fields.get(1));
    }

    static Right readRight(PlanStreamInput in) throws IOException {
        return new Right(in.readSource(), in.readExpression(), in.readExpression());
    }

    static void writeRight(PlanStreamOutput out, Right right) throws IOException {
        out.writeSource(right.source());
        List fields = right.children();
        assert (fields.size() == 2);
        out.writeExpression((Expression)fields.get(0));
        out.writeExpression((Expression)fields.get(1));
    }

    static Split readSplit(PlanStreamInput in) throws IOException {
        return new Split(in.readSource(), in.readExpression(), in.readExpression());
    }

    static void writeSplit(PlanStreamOutput out, Split split) throws IOException {
        out.writeSource(split.source());
        out.writeExpression(split.left());
        out.writeExpression(split.right());
    }

    static CIDRMatch readCIDRMatch(PlanStreamInput in) throws IOException {
        return new CIDRMatch(in.readSource(), in.readExpression(), in.readCollectionAsList(PlanNameRegistry.PlanReader.readerFromPlanReader(PlanStreamInput::readExpression)));
    }

    static void writeCIDRMatch(PlanStreamOutput out, CIDRMatch cidrMatch) throws IOException {
        out.writeSource(cidrMatch.source());
        List children = cidrMatch.children();
        assert (children.size() > 1);
        out.writeExpression((Expression)children.get(0));
        out.writeCollection(children.subList(1, children.size()), PlanNameRegistry.PlanWriter.writerFromPlanWriter(PlanStreamOutput::writeExpression));
    }

    static ArithmeticOperation readArithmeticOperation(PlanStreamInput in, String name) throws IOException {
        Source source = in.readSource();
        Expression left = in.readExpression();
        Expression right = in.readExpression();
        return (ArithmeticOperation)ARITHMETIC_CTRS.get(name).apply((Object)source, (Object)left, (Object)right);
    }

    static void writeArithmeticOperation(PlanStreamOutput out, ArithmeticOperation arithmeticOperation) throws IOException {
        out.writeSource(arithmeticOperation.source());
        out.writeExpression(arithmeticOperation.left());
        out.writeExpression(arithmeticOperation.right());
    }

    static AggregateFunction readAggFunction(PlanStreamInput in, String name) throws IOException {
        return AGG_CTRS.get(name).apply(in.readSource(), in.readExpression());
    }

    static void writeAggFunction(PlanStreamOutput out, AggregateFunction aggregateFunction) throws IOException {
        out.writeNoSource();
        out.writeExpression(aggregateFunction.field());
    }

    static AbstractMultivalueFunction readMvFunction(PlanStreamInput in, String name) throws IOException {
        return MV_CTRS.get(name).apply(in.readSource(), in.readExpression());
    }

    static void writeMvFunction(PlanStreamOutput out, AbstractMultivalueFunction fn) throws IOException {
        out.writeNoSource();
        out.writeExpression(fn.field());
    }

    static MvConcat readMvConcat(PlanStreamInput in) throws IOException {
        return new MvConcat(in.readSource(), in.readExpression(), in.readExpression());
    }

    static void writeMvConcat(PlanStreamOutput out, MvConcat fn) throws IOException {
        out.writeNoSource();
        out.writeExpression(fn.left());
        out.writeExpression(fn.right());
    }

    static Alias readAlias(PlanStreamInput in) throws IOException {
        return new Alias(in.readSource(), in.readString(), in.readOptionalString(), in.readNamed(Expression.class), in.nameIdFromLongValue(in.readLong()), in.readBoolean());
    }

    static void writeAlias(PlanStreamOutput out, Alias alias) throws IOException {
        out.writeNoSource();
        out.writeString(alias.name());
        out.writeOptionalString(alias.qualifier());
        out.writeExpression(alias.child());
        out.writeLong(EsqlDataTypeConverter.stringToLong(alias.id().toString()));
        out.writeBoolean(alias.synthetic());
    }

    static Literal readLiteral(PlanStreamInput in) throws IOException {
        Source source = in.readSource();
        Object value = in.readGenericValue();
        DataType dataType = in.dataTypeFromTypeName(in.readString());
        return new Literal(source, PlanNamedTypes.mapToLiteralValue(in, dataType, value), dataType);
    }

    static void writeLiteral(PlanStreamOutput out, Literal literal) throws IOException {
        out.writeNoSource();
        out.writeGenericValue(PlanNamedTypes.mapFromLiteralValue(out, literal.dataType(), literal.value()));
        out.writeString(literal.dataType().typeName());
    }

    private static Object mapFromLiteralValue(PlanStreamOutput out, DataType dataType, Object value) {
        if ((dataType == EsqlDataTypes.GEO_POINT || dataType == EsqlDataTypes.CARTESIAN_POINT) && out.getTransportVersion().before((VersionId)TransportVersions.ESQL_PLAN_POINT_LITERAL_WKB)) {
            if (value instanceof List) {
                List list = (List)value;
                return list.stream().map(v -> PlanNamedTypes.mapFromLiteralValue(out, dataType, v)).toList();
            }
            return PlanNamedTypes.wkbAsLong(dataType, (BytesRef)value);
        }
        return value;
    }

    private static Object mapToLiteralValue(PlanStreamInput in, DataType dataType, Object value) {
        if ((dataType == EsqlDataTypes.GEO_POINT || dataType == EsqlDataTypes.CARTESIAN_POINT) && in.getTransportVersion().before((VersionId)TransportVersions.ESQL_PLAN_POINT_LITERAL_WKB)) {
            if (value instanceof List) {
                List list = (List)value;
                return list.stream().map(v -> PlanNamedTypes.mapToLiteralValue(in, dataType, v)).toList();
            }
            return PlanNamedTypes.longAsWKB(dataType, (Long)value);
        }
        return value;
    }

    private static BytesRef longAsWKB(DataType dataType, long encoded) {
        return dataType == EsqlDataTypes.GEO_POINT ? SpatialCoordinateTypes.GEO.longAsWkb(encoded) : SpatialCoordinateTypes.CARTESIAN.longAsWkb(encoded);
    }

    private static long wkbAsLong(DataType dataType, BytesRef wkb) {
        return dataType == EsqlDataTypes.GEO_POINT ? SpatialCoordinateTypes.GEO.wkbAsLong(wkb) : SpatialCoordinateTypes.CARTESIAN.wkbAsLong(wkb);
    }

    static Order readOrder(PlanStreamInput in) throws IOException {
        return new org.elasticsearch.xpack.esql.expression.Order(in.readSource(), in.readNamed(Expression.class), (Order.OrderDirection)in.readEnum(Order.OrderDirection.class), (Order.NullsPosition)in.readEnum(Order.NullsPosition.class));
    }

    static void writeOrder(PlanStreamOutput out, Order order) throws IOException {
        out.writeNoSource();
        out.writeExpression(order.child());
        out.writeEnum((Enum)order.direction());
        out.writeEnum((Enum)order.nullsPosition());
    }

    static EsQueryExec.FieldSort readFieldSort(PlanStreamInput in) throws IOException {
        return new EsQueryExec.FieldSort(PlanNamedTypes.readFieldAttribute(in), (Order.OrderDirection)in.readEnum(Order.OrderDirection.class), (Order.NullsPosition)in.readEnum(Order.NullsPosition.class));
    }

    static void writeFieldSort(PlanStreamOutput out, EsQueryExec.FieldSort fieldSort) throws IOException {
        PlanNamedTypes.writeFieldAttribute(out, fieldSort.field());
        out.writeEnum((Enum)fieldSort.direction());
        out.writeEnum((Enum)fieldSort.nulls());
    }

    static EsIndex readEsIndex(PlanStreamInput in) throws IOException {
        return new EsIndex(in.readString(), in.readImmutableMap(StreamInput::readString, PlanNameRegistry.PlanReader.readerFromPlanReader(PlanStreamInput::readEsFieldNamed)), (Set)in.readGenericValue());
    }

    static void writeEsIndex(PlanStreamOutput out, EsIndex esIndex) throws IOException {
        out.writeString(esIndex.name());
        out.writeMap(esIndex.mapping(), (o, v) -> out.writeNamed(EsField.class, v));
        out.writeGenericValue(esIndex.concreteIndices());
    }

    static Dissect.Parser readDissectParser(PlanStreamInput in) throws IOException {
        String pattern = in.readString();
        String appendSeparator = in.readString();
        return new Dissect.Parser(pattern, appendSeparator, new DissectParser(pattern, appendSeparator));
    }

    static void writeDissectParser(PlanStreamOutput out, Dissect.Parser dissectParser) throws IOException {
        out.writeString(dissectParser.pattern());
        out.writeString(dissectParser.appendSeparator());
    }

    static Log readLog(PlanStreamInput in) throws IOException {
        return new Log(in.readSource(), in.readExpression(), in.readOptionalNamed(Expression.class));
    }

    static void writeLog(PlanStreamOutput out, Log log) throws IOException {
        out.writeSource(log.source());
        List fields = log.children();
        assert (fields.size() == 1 || fields.size() == 2);
        out.writeExpression((Expression)fields.get(0));
        out.writeOptionalWriteable(fields.size() == 2 ? o -> out.writeExpression((Expression)fields.get(1)) : null);
    }

    static MvSort readMvSort(PlanStreamInput in) throws IOException {
        return new MvSort(in.readSource(), in.readExpression(), in.readOptionalNamed(Expression.class));
    }

    static void writeMvSort(PlanStreamOutput out, MvSort mvSort) throws IOException {
        out.writeSource(mvSort.source());
        List fields = mvSort.children();
        assert (fields.size() == 1 || fields.size() == 2);
        out.writeExpression((Expression)fields.get(0));
        out.writeOptionalWriteable(fields.size() == 2 ? o -> out.writeExpression((Expression)fields.get(1)) : null);
    }

    static MvSlice readMvSlice(PlanStreamInput in) throws IOException {
        return new MvSlice(in.readSource(), in.readExpression(), in.readExpression(), in.readOptionalNamed(Expression.class));
    }

    static void writeMvSlice(PlanStreamOutput out, MvSlice fn) throws IOException {
        out.writeNoSource();
        List fields = fn.children();
        assert (fields.size() == 2 || fields.size() == 3);
        out.writeExpression((Expression)fields.get(0));
        out.writeExpression((Expression)fields.get(1));
        out.writeOptionalWriteable(fields.size() == 3 ? o -> out.writeExpression((Expression)fields.get(2)) : null);
    }

    static MvZip readMvZip(PlanStreamInput in) throws IOException {
        return new MvZip(in.readSource(), in.readExpression(), in.readExpression(), in.readOptionalNamed(Expression.class));
    }

    static void writeMvZip(PlanStreamOutput out, MvZip fn) throws IOException {
        out.writeNoSource();
        List fields = fn.children();
        assert (fields.size() == 2 || fields.size() == 3);
        out.writeExpression((Expression)fields.get(0));
        out.writeExpression((Expression)fields.get(1));
        out.writeOptionalWriteable(fields.size() == 3 ? o -> out.writeExpression((Expression)fields.get(2)) : null);
    }
}

