/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Add;
import org.elasticsearch.xpack.ql.tree.Source;

public final class AddIntsEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator lhs;
    private final EvalOperator.ExpressionEvaluator rhs;
    private final DriverContext driverContext;

    public AddIntsEvaluator(Source source, EvalOperator.ExpressionEvaluator lhs, EvalOperator.ExpressionEvaluator rhs, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.lhs = lhs;
        this.rhs = rhs;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (IntBlock lhsBlock = (IntBlock)this.lhs.eval(page);){
            IntBlock intBlock;
            block20: {
                IntVector rhsVector;
                IntVector lhsVector;
                IntBlock rhsBlock;
                block18: {
                    IntBlock intBlock2;
                    block19: {
                        block16: {
                            IntBlock intBlock3;
                            block17: {
                                rhsBlock = (IntBlock)this.rhs.eval(page);
                                try {
                                    lhsVector = lhsBlock.asVector();
                                    if (lhsVector != null) break block16;
                                    intBlock3 = this.eval(page.getPositionCount(), lhsBlock, rhsBlock);
                                    if (rhsBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (rhsBlock != null) {
                                        try {
                                            rhsBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rhsBlock.close();
                            }
                            return intBlock3;
                        }
                        rhsVector = rhsBlock.asVector();
                        if (rhsVector != null) break block18;
                        intBlock2 = this.eval(page.getPositionCount(), lhsBlock, rhsBlock);
                        if (rhsBlock == null) break block19;
                        rhsBlock.close();
                    }
                    return intBlock2;
                }
                intBlock = this.eval(page.getPositionCount(), lhsVector, rhsVector);
                if (rhsBlock == null) break block20;
                rhsBlock.close();
            }
            return intBlock;
        }
    }

    public IntBlock eval(int positionCount, IntBlock lhsBlock, IntBlock rhsBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (lhsBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (lhsBlock.getValueCount(p) != 1) {
                    if (lhsBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (rhsBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (rhsBlock.getValueCount(p) != 1) {
                    if (rhsBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendInt(Add.processInts(lhsBlock.getInt(lhsBlock.getFirstValueIndex(p)), rhsBlock.getInt(rhsBlock.getFirstValueIndex(p))));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntBlock eval(int positionCount, IntVector lhsVector, IntVector rhsVector) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendInt(Add.processInts(lhsVector.getInt(p), rhsVector.getInt(p)));
                    continue;
                }
                catch (ArithmeticException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public String toString() {
        return "AddIntsEvaluator[lhs=" + this.lhs + ", rhs=" + this.rhs + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.lhs, this.rhs});
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory lhs;
        private final EvalOperator.ExpressionEvaluator.Factory rhs;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory lhs, EvalOperator.ExpressionEvaluator.Factory rhs) {
            this.source = source;
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public AddIntsEvaluator get(DriverContext context) {
            return new AddIntsEvaluator(this.source, this.lhs.get(context), this.rhs.get(context), context);
        }

        public String toString() {
            return "AddIntsEvaluator[lhs=" + this.lhs + ", rhs=" + this.rhs + "]";
        }
    }
}

