/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.StartsWith;
import org.elasticsearch.xpack.ql.tree.Source;

public final class StartsWithEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator str;
    private final EvalOperator.ExpressionEvaluator prefix;
    private final DriverContext driverContext;

    public StartsWithEvaluator(Source source, EvalOperator.ExpressionEvaluator str, EvalOperator.ExpressionEvaluator prefix, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.str = str;
        this.prefix = prefix;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock strBlock = (BytesRefBlock)this.str.eval(page);){
            BooleanBlock booleanBlock;
            block20: {
                BytesRefVector prefixVector;
                BytesRefVector strVector;
                BytesRefBlock prefixBlock;
                block18: {
                    BooleanBlock booleanBlock2;
                    block19: {
                        block16: {
                            BooleanBlock booleanBlock3;
                            block17: {
                                prefixBlock = (BytesRefBlock)this.prefix.eval(page);
                                try {
                                    strVector = strBlock.asVector();
                                    if (strVector != null) break block16;
                                    booleanBlock3 = this.eval(page.getPositionCount(), strBlock, prefixBlock);
                                    if (prefixBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (prefixBlock != null) {
                                        try {
                                            prefixBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                prefixBlock.close();
                            }
                            return booleanBlock3;
                        }
                        prefixVector = prefixBlock.asVector();
                        if (prefixVector != null) break block18;
                        booleanBlock2 = this.eval(page.getPositionCount(), strBlock, prefixBlock);
                        if (prefixBlock == null) break block19;
                        prefixBlock.close();
                    }
                    return booleanBlock2;
                }
                booleanBlock = this.eval(page.getPositionCount(), strVector, prefixVector).asBlock();
                if (prefixBlock == null) break block20;
                prefixBlock.close();
            }
            return booleanBlock;
        }
    }

    public BooleanBlock eval(int positionCount, BytesRefBlock strBlock, BytesRefBlock prefixBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            BytesRef prefixScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (strBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (strBlock.getValueCount(p) != 1) {
                    if (strBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (prefixBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (prefixBlock.getValueCount(p) != 1) {
                    if (prefixBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendBoolean(StartsWith.process(strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch), prefixBlock.getBytesRef(prefixBlock.getFirstValueIndex(p), prefixScratch)));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, BytesRefVector strVector, BytesRefVector prefixVector) {
        try (BooleanVector.Builder result = this.driverContext.blockFactory().newBooleanVectorBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            BytesRef prefixScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                result.appendBoolean(StartsWith.process(strVector.getBytesRef(p, strScratch), prefixVector.getBytesRef(p, prefixScratch)));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "StartsWithEvaluator[str=" + this.str + ", prefix=" + this.prefix + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.str, this.prefix});
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory str;
        private final EvalOperator.ExpressionEvaluator.Factory prefix;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory str, EvalOperator.ExpressionEvaluator.Factory prefix) {
            this.source = source;
            this.str = str;
            this.prefix = prefix;
        }

        public StartsWithEvaluator get(DriverContext context) {
            return new StartsWithEvaluator(this.source, this.str.get(context), this.prefix.get(context), context);
        }

        public String toString() {
            return "StartsWithEvaluator[str=" + this.str + ", prefix=" + this.prefix + "]";
        }
    }
}

