/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Split;
import org.elasticsearch.xpack.ql.tree.Source;

public final class SplitVariableEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator str;
    private final EvalOperator.ExpressionEvaluator delim;
    private final BytesRef scratch;
    private final DriverContext driverContext;

    public SplitVariableEvaluator(Source source, EvalOperator.ExpressionEvaluator str, EvalOperator.ExpressionEvaluator delim, BytesRef scratch, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.str = str;
        this.delim = delim;
        this.scratch = scratch;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock strBlock = (BytesRefBlock)this.str.eval(page);){
            BytesRefBlock bytesRefBlock;
            block20: {
                BytesRefVector delimVector;
                BytesRefVector strVector;
                BytesRefBlock delimBlock;
                block18: {
                    BytesRefBlock bytesRefBlock2;
                    block19: {
                        block16: {
                            BytesRefBlock bytesRefBlock3;
                            block17: {
                                delimBlock = (BytesRefBlock)this.delim.eval(page);
                                try {
                                    strVector = strBlock.asVector();
                                    if (strVector != null) break block16;
                                    bytesRefBlock3 = this.eval(page.getPositionCount(), strBlock, delimBlock);
                                    if (delimBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (delimBlock != null) {
                                        try {
                                            delimBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                delimBlock.close();
                            }
                            return bytesRefBlock3;
                        }
                        delimVector = delimBlock.asVector();
                        if (delimVector != null) break block18;
                        bytesRefBlock2 = this.eval(page.getPositionCount(), strBlock, delimBlock);
                        if (delimBlock == null) break block19;
                        delimBlock.close();
                    }
                    return bytesRefBlock2;
                }
                bytesRefBlock = this.eval(page.getPositionCount(), strVector, delimVector);
                if (delimBlock == null) break block20;
                delimBlock.close();
            }
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock strBlock, BytesRefBlock delimBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            BytesRef delimScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (strBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (strBlock.getValueCount(p) != 1) {
                    if (strBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (delimBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (delimBlock.getValueCount(p) != 1) {
                    if (delimBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                Split.process(result, strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch), delimBlock.getBytesRef(delimBlock.getFirstValueIndex(p), delimScratch), this.scratch);
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefBlock eval(int positionCount, BytesRefVector strVector, BytesRefVector delimVector) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            BytesRef delimScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                Split.process(result, strVector.getBytesRef(p, strScratch), delimVector.getBytesRef(p, delimScratch), this.scratch);
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public String toString() {
        return "SplitVariableEvaluator[str=" + this.str + ", delim=" + this.delim + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.str, this.delim});
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory str;
        private final EvalOperator.ExpressionEvaluator.Factory delim;
        private final Function<DriverContext, BytesRef> scratch;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory str, EvalOperator.ExpressionEvaluator.Factory delim, Function<DriverContext, BytesRef> scratch) {
            this.source = source;
            this.str = str;
            this.delim = delim;
            this.scratch = scratch;
        }

        public SplitVariableEvaluator get(DriverContext context) {
            return new SplitVariableEvaluator(this.source, this.str.get(context), this.delim.get(context), this.scratch.apply(context), context);
        }

        public String toString() {
            return "SplitVariableEvaluator[str=" + this.str + ", delim=" + this.delim + "]";
        }
    }
}

