/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ReplaceConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ReplaceEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Replace
extends EsqlScalarFunction {
    private final Expression str;
    private final Expression newStr;
    private final Expression regex;

    @FunctionInfo(returnType={"keyword"}, description="The function substitutes in the string any match of the regular expression with the replacement string.")
    public Replace(Source source, @Param(name="string", type={"keyword", "text"}) Expression str, @Param(name="regex", type={"keyword", "text"}) Expression regex, @Param(name="newString", type={"keyword", "text"}) Expression newStr) {
        super(source, Arrays.asList(str, regex, newStr));
        this.str = str;
        this.regex = regex;
        this.newStr = newStr;
    }

    public DataType dataType() {
        return DataTypes.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isString((Expression)this.str, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isString((Expression)this.regex, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isString((Expression)this.newStr, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD);
    }

    public boolean foldable() {
        return this.str.foldable() && this.regex.foldable() && this.newStr.foldable();
    }

    static BytesRef process(BytesRef str, Pattern regex, BytesRef newStr) {
        if (str == null || regex == null || newStr == null) {
            return null;
        }
        return new BytesRef((CharSequence)regex.matcher(str.utf8ToString()).replaceAll(newStr.utf8ToString()));
    }

    static BytesRef process(BytesRef str, BytesRef regex, BytesRef newStr) {
        if (str == null) {
            return null;
        }
        if (regex == null || newStr == null) {
            return str;
        }
        return new BytesRef((CharSequence)str.utf8ToString().replaceAll(regex.utf8ToString(), newStr.utf8ToString()));
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Replace(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Replace::new, (Object)this.str, (Object)this.regex, (Object)this.newStr);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory strEval = toEvaluator.apply(this.str);
        EvalOperator.ExpressionEvaluator.Factory newStrEval = toEvaluator.apply(this.newStr);
        if (this.regex.foldable() && this.regex.dataType() == DataTypes.KEYWORD) {
            Pattern regexPattern = Pattern.compile(((BytesRef)this.regex.fold()).utf8ToString());
            return new ReplaceConstantEvaluator.Factory(this.source(), strEval, regexPattern, newStrEval);
        }
        EvalOperator.ExpressionEvaluator.Factory regexEval = toEvaluator.apply(this.regex);
        return new ReplaceEvaluator.Factory(this.source(), strEval, regexEval, newStrEval);
    }
}

