/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.List;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.RTrimEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class RTrim
extends UnaryScalarFunction {
    @FunctionInfo(returnType={"keyword", "text"}, description="Removes trailing whitespaces from a string.")
    public RTrim(Source source, @Param(name="string", type={"keyword", "text"}) Expression str) {
        super(source, str);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isString((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        return new RTrimEvaluator.Factory(this.source(), toEvaluator.apply(this.field()));
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new RTrim(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, RTrim::new, (Object)this.field());
    }

    static BytesRef process(BytesRef val) {
        int offset;
        int end = offset = val.offset;
        UnicodeUtil.UTF8CodePoint codePoint = new UnicodeUtil.UTF8CodePoint();
        while (offset < val.offset + val.length) {
            codePoint = UnicodeUtil.codePointAt((byte[])val.bytes, (int)offset, (UnicodeUtil.UTF8CodePoint)codePoint);
            if (!Character.isWhitespace(codePoint.codePoint)) {
                end = offset + codePoint.numBytes;
            }
            offset += codePoint.numBytes;
        }
        return new BytesRef(val.bytes, val.offset, end - val.offset);
    }
}

