/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.EndsWithEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class EndsWith
extends EsqlScalarFunction {
    private final Expression str;
    private final Expression suffix;

    @FunctionInfo(returnType={"boolean"}, description="Returns a boolean that indicates whether a keyword string ends with another string")
    public EndsWith(Source source, @Param(name="str", type={"keyword", "text"}) Expression str, @Param(name="suffix", type={"keyword", "text"}) Expression suffix) {
        super(source, Arrays.asList(str, suffix));
        this.str = str;
        this.suffix = suffix;
    }

    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isString((Expression)this.str, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isString((Expression)this.suffix, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
    }

    public boolean foldable() {
        return this.str.foldable() && this.suffix.foldable();
    }

    static boolean process(BytesRef str, BytesRef suffix) {
        if (str.length < suffix.length) {
            return false;
        }
        return Arrays.equals(str.bytes, str.offset + str.length - suffix.length, str.offset + str.length, suffix.bytes, suffix.offset, suffix.offset + suffix.length);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new EndsWith(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, EndsWith::new, (Object)this.str, (Object)this.suffix);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        return new EndsWithEvaluator.Factory(this.source(), toEvaluator.apply(this.str), toEvaluator.apply(this.suffix));
    }
}

