/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlClientException;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ConcatEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Concat
extends EsqlScalarFunction {
    static final long MAX_CONCAT_LENGTH = ByteSizeUnit.MB.toBytes(1L);

    @FunctionInfo(returnType={"keyword"}, description="Concatenates two or more strings.")
    public Concat(Source source, @Param(name="string1", type={"keyword", "text"}) Expression first, @Param(name="string2", type={"keyword", "text"}) List<? extends Expression> rest) {
        super(source, Stream.concat(Stream.of(first), rest.stream()).toList());
    }

    public DataType dataType() {
        return DataTypes.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = Expression.TypeResolution.TYPE_RESOLVED;
        for (Expression value : this.children()) {
            resolution = TypeResolutions.isString((Expression)value, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
            if (!resolution.unresolved()) continue;
            return resolution;
        }
        return resolution;
    }

    public boolean foldable() {
        return Expressions.foldable((List)this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory[] values = (EvalOperator.ExpressionEvaluator.Factory[])this.children().stream().map(toEvaluator).toArray(EvalOperator.ExpressionEvaluator.Factory[]::new);
        return new ConcatEvaluator.Factory(this.source(), context -> new BreakingBytesRefBuilder(context.breaker(), "concat"), values);
    }

    static BytesRef process(BreakingBytesRefBuilder scratch, BytesRef[] values) {
        scratch.grow(Concat.checkedTotalLength(values));
        scratch.clear();
        for (int i = 0; i < values.length; ++i) {
            scratch.append(values[i]);
        }
        return scratch.bytesRefView();
    }

    private static int checkedTotalLength(BytesRef[] values) {
        int length = 0;
        for (BytesRef v : values) {
            length += v.length;
        }
        if ((long)length > MAX_CONCAT_LENGTH) {
            throw new EsqlClientException("concatenating more than [" + MAX_CONCAT_LENGTH + "] bytes is not supported", new Object[0]);
        }
        return length;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Concat(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Concat::new, (Object)((Expression)this.children().get(0)), this.children().subList(1, this.children().size()));
    }
}

