/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.util.List;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StYFromWKBEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.SpatialCoordinateTypes;

public class StY
extends UnaryScalarFunction {
    @FunctionInfo(returnType={"double"}, description="Extracts the y-coordinate from a point geometry.")
    public StY(Source source, @Param(name="point", type={"geo_point", "cartesian_point"}) Expression field) {
        super(source, field);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return EsqlTypeResolutions.isSpatialPoint(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        return new StYFromWKBEvaluator.Factory(toEvaluator.apply(this.field()), this.source());
    }

    @Override
    public DataType dataType() {
        return DataTypes.DOUBLE;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new StY(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, StY::new, (Object)this.field());
    }

    static double fromWellKnownBinary(BytesRef in) {
        return SpatialCoordinateTypes.UNSPECIFIED.wkbAsPoint(in).getY();
    }
}

