/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.index.mapper.ShapeIndexer;
import org.elasticsearch.lucene.spatial.Component2DVisitor;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.GeometryDocValueReader;
import org.elasticsearch.lucene.spatial.TriangleTreeVisitor;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialEvaluatorFactory;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.SpatialCoordinateTypes;

public abstract class SpatialRelatesFunction
extends BinaryScalarFunction
implements EvaluatorMapper,
SpatialEvaluatorFactory.SpatialSourceSupplier {
    protected SpatialCrsType crsType;
    protected final boolean leftDocValues;
    protected final boolean rightDocValues;
    private static final String[] GEO_TYPE_NAMES = new String[]{EsqlDataTypes.GEO_POINT.typeName(), EsqlDataTypes.GEO_SHAPE.typeName()};
    private static final String[] CARTESIAN_TYPE_NAMES = new String[]{EsqlDataTypes.GEO_POINT.typeName(), EsqlDataTypes.GEO_SHAPE.typeName()};

    protected SpatialRelatesFunction(Source source, Expression left, Expression right, boolean leftDocValues, boolean rightDocValues) {
        super(source, left, right);
        this.leftDocValues = leftDocValues;
        this.rightDocValues = rightDocValues;
    }

    public abstract ShapeField.QueryRelation queryRelation();

    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    @Override
    public SpatialCrsType crsType() {
        if (this.crsType == null) {
            this.resolveType();
        }
        return this.crsType;
    }

    protected Expression.TypeResolution resolveType() {
        if (this.left().foldable() && !this.right().foldable() || DataTypes.isNull((DataType)this.left().dataType())) {
            return this.resolveType(this.right(), this.left(), TypeResolutions.ParamOrdinal.SECOND, TypeResolutions.ParamOrdinal.FIRST);
        }
        return this.resolveType(this.left(), this.right(), TypeResolutions.ParamOrdinal.FIRST, TypeResolutions.ParamOrdinal.SECOND);
    }

    private Expression.TypeResolution resolveType(Expression leftExpression, Expression rightExpression, TypeResolutions.ParamOrdinal leftOrdinal, TypeResolutions.ParamOrdinal rightOrdinal) {
        Expression.TypeResolution leftResolution = EsqlTypeResolutions.isSpatial(leftExpression, this.sourceText(), leftOrdinal);
        Expression.TypeResolution rightResolution = EsqlTypeResolutions.isSpatial(rightExpression, this.sourceText(), rightOrdinal);
        if (leftResolution.resolved()) {
            return this.resolveType(leftExpression, rightExpression, rightOrdinal);
        }
        if (rightResolution.resolved()) {
            return this.resolveType(rightExpression, leftExpression, leftOrdinal);
        }
        return leftResolution;
    }

    protected Expression.TypeResolution resolveType(Expression spatialExpression, Expression otherExpression, TypeResolutions.ParamOrdinal otherParamOrdinal) {
        if (DataTypes.isNull((DataType)spatialExpression.dataType())) {
            return EsqlTypeResolutions.isSpatial(otherExpression, this.sourceText(), otherParamOrdinal);
        }
        Expression.TypeResolution resolution = SpatialRelatesFunction.isSameSpatialType(spatialExpression.dataType(), otherExpression, this.sourceText(), otherParamOrdinal);
        if (resolution.unresolved()) {
            return resolution;
        }
        this.setCrsType(spatialExpression.dataType());
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    protected void setCrsType(DataType dataType) {
        this.crsType = SpatialCrsType.fromDataType(dataType);
    }

    public static Expression.TypeResolution isSameSpatialType(DataType spatialDataType, Expression expression, String operationName, TypeResolutions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType((Expression)expression, dt -> EsqlDataTypes.isSpatial(dt) && SpatialRelatesFunction.spatialCRSCompatible(spatialDataType, dt), (String)operationName, (TypeResolutions.ParamOrdinal)paramOrd, (String[])SpatialRelatesFunction.compatibleTypeNames(spatialDataType));
    }

    private static boolean spatialCRSCompatible(DataType spatialDataType, DataType otherDataType) {
        return EsqlDataTypes.isSpatialGeo(spatialDataType) && EsqlDataTypes.isSpatialGeo(otherDataType) || !EsqlDataTypes.isSpatialGeo(spatialDataType) && !EsqlDataTypes.isSpatialGeo(otherDataType);
    }

    static String[] compatibleTypeNames(DataType spatialDataType) {
        return EsqlDataTypes.isSpatialGeo(spatialDataType) ? GEO_TYPE_NAMES : CARTESIAN_TYPE_NAMES;
    }

    public boolean foldable() {
        return this.left().foldable() && this.right().foldable();
    }

    public abstract SpatialRelatesFunction withDocValues(Set<FieldAttribute> var1);

    public boolean canPushToSource(Predicate<FieldAttribute> isAggregatable) {
        return SpatialRelatesFunction.isPushableFieldAttribute(this.left(), isAggregatable) && this.right().foldable() || SpatialRelatesFunction.isPushableFieldAttribute(this.right(), isAggregatable) && this.left().foldable();
    }

    private static boolean isPushableFieldAttribute(Expression exp, Predicate<FieldAttribute> isAggregatable) {
        FieldAttribute fa;
        return exp instanceof FieldAttribute && (fa = (FieldAttribute)exp).getExactInfo().hasExact() && isAggregatable.test(fa) && EsqlDataTypes.isSpatial(fa.dataType());
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.children(), this.leftDocValues, this.rightDocValues);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            SpatialRelatesFunction other = (SpatialRelatesFunction)obj;
            return Objects.equals(other.children(), this.children()) && Objects.equals(other.leftDocValues, this.leftDocValues) && Objects.equals(other.rightDocValues, this.rightDocValues);
        }
        return false;
    }

    @Override
    public boolean leftDocValues() {
        return this.leftDocValues;
    }

    @Override
    public boolean rightDocValues() {
        return this.rightDocValues;
    }

    abstract Map<SpatialEvaluatorFactory.SpatialEvaluatorKey, SpatialEvaluatorFactory<?, ?>> evaluatorRules();

    public SpatialRelatesFunction surrogate() {
        return this;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        return SpatialEvaluatorFactory.makeSpatialEvaluator(this, this.evaluatorRules(), toEvaluator);
    }

    public boolean hasFieldAttribute(Set<FieldAttribute> foundAttributes) {
        return this.foundField(this.left(), foundAttributes) || this.foundField(this.right(), foundAttributes);
    }

    protected boolean foundField(Expression expression, Set<FieldAttribute> foundAttributes) {
        FieldAttribute field;
        return expression instanceof FieldAttribute && foundAttributes.contains(field = (FieldAttribute)expression);
    }

    protected static enum SpatialCrsType {
        GEO,
        CARTESIAN,
        UNSPECIFIED;


        public static SpatialCrsType fromDataType(DataType dataType) {
            return EsqlDataTypes.isSpatialGeo(dataType) ? GEO : (EsqlDataTypes.isSpatial(dataType) ? CARTESIAN : UNSPECIFIED);
        }
    }

    protected static class SpatialRelations {
        protected final ShapeField.QueryRelation queryRelation;
        protected final SpatialCoordinateTypes spatialCoordinateType;
        protected final CoordinateEncoder coordinateEncoder;
        protected final ShapeIndexer shapeIndexer;
        protected final SpatialCrsType crsType;

        protected SpatialRelations(ShapeField.QueryRelation queryRelation, SpatialCoordinateTypes spatialCoordinateType, CoordinateEncoder encoder, ShapeIndexer shapeIndexer) {
            this.queryRelation = queryRelation;
            this.spatialCoordinateType = spatialCoordinateType;
            this.coordinateEncoder = encoder;
            this.shapeIndexer = shapeIndexer;
            this.crsType = spatialCoordinateType.equals((Object)SpatialCoordinateTypes.GEO) ? SpatialCrsType.GEO : SpatialCrsType.CARTESIAN;
        }

        protected boolean geometryRelatesGeometry(BytesRef left, BytesRef right) throws IOException {
            Component2D rightComponent2D = SpatialRelatesUtils.asLuceneComponent2D(this.crsType, this.fromBytesRef(right));
            return this.geometryRelatesGeometry(left, rightComponent2D);
        }

        protected Geometry fromBytesRef(BytesRef bytesRef) {
            return SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(bytesRef);
        }

        protected boolean geometryRelatesGeometry(BytesRef left, Component2D rightComponent2D) throws IOException {
            Geometry leftGeom = this.fromBytesRef(left);
            return this.geometryRelatesGeometry(SpatialRelatesUtils.asGeometryDocValueReader(this.coordinateEncoder, this.shapeIndexer, leftGeom), rightComponent2D);
        }

        protected boolean geometryRelatesGeometry(GeometryDocValueReader reader, Component2D rightComponent2D) throws IOException {
            Component2DVisitor visitor = Component2DVisitor.getVisitor((Component2D)rightComponent2D, (ShapeField.QueryRelation)this.queryRelation, (CoordinateEncoder)this.coordinateEncoder);
            reader.visit((TriangleTreeVisitor)visitor);
            return visitor.matches();
        }

        protected boolean pointRelatesGeometry(long encoded, Geometry geometry) {
            Component2D component2D = SpatialRelatesUtils.asLuceneComponent2D(this.crsType, geometry);
            return this.pointRelatesGeometry(encoded, component2D);
        }

        protected boolean pointRelatesGeometry(long encoded, Component2D component2D) {
            Point point = this.spatialCoordinateType.longAsPoint(encoded);
            return this.pointRelatesGeometry(point, component2D);
        }

        protected boolean pointRelatesGeometry(Point point, Component2D component2D) {
            if (this.queryRelation == ShapeField.QueryRelation.CONTAINS) {
                return component2D.withinPoint(point.getX(), point.getY()) == Component2D.WithinRelation.CANDIDATE;
            }
            boolean contains = component2D.contains(point.getX(), point.getY());
            return this.queryRelation == ShapeField.QueryRelation.DISJOINT ? !contains : contains;
        }
    }
}

