/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.MultivalueDedupeBoolean;
import org.elasticsearch.compute.operator.MultivalueDedupeBytesRef;
import org.elasticsearch.compute.operator.MultivalueDedupeDouble;
import org.elasticsearch.compute.operator.MultivalueDedupeInt;
import org.elasticsearch.compute.operator.MultivalueDedupeLong;
import org.elasticsearch.xpack.esql.capabilities.Validatable;
import org.elasticsearch.xpack.esql.expression.Validations;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.common.Failures;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class MvSort
extends EsqlScalarFunction
implements OptionalArgument,
Validatable {
    private final Expression field;
    private final Expression order;
    private static final Literal ASC = new Literal(Source.EMPTY, (Object)"ASC", DataTypes.KEYWORD);

    @FunctionInfo(returnType={"boolean", "date", "double", "integer", "ip", "keyword", "long", "text", "version"}, description="Sorts a multivalued field in lexicographical order.")
    public MvSort(Source source, @Param(name="field", type={"boolean", "date", "double", "integer", "ip", "keyword", "long", "text", "version"}, description="A multivalued field") Expression field, @Param(name="order", type={"keyword"}, description="sort order", optional=true) Expression order) {
        super(source, order == null ? Arrays.asList(field, ASC) : Arrays.asList(field, order));
        this.field = field;
        this.order = order == null ? ASC : order;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isType((Expression)this.field, EsqlDataTypes::isRepresentable, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"representable"});
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isString((Expression)this.order, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
    }

    public boolean foldable() {
        return this.field.foldable() && (this.order == null || this.order.foldable());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        boolean ordering = !this.order.foldable() || !((BytesRef)this.order.fold()).utf8ToString().equalsIgnoreCase("DESC");
        return switch (PlannerUtils.toElementType(this.field.dataType())) {
            case ElementType.BOOLEAN -> new EvaluatorFactory(toEvaluator.apply(this.field), ordering, (TriFunction<BlockFactory, Block, Boolean, Block>)((TriFunction)(blockFactory, fieldBlock, sortOrder) -> new MultivalueDedupeBoolean((BooleanBlock)fieldBlock).sortToBlock(blockFactory, sortOrder.booleanValue())), ElementType.BOOLEAN);
            case ElementType.BYTES_REF -> new EvaluatorFactory(toEvaluator.apply(this.field), ordering, (TriFunction<BlockFactory, Block, Boolean, Block>)((TriFunction)(blockFactory, fieldBlock, sortOrder) -> new MultivalueDedupeBytesRef((BytesRefBlock)fieldBlock).sortToBlock(blockFactory, sortOrder.booleanValue())), ElementType.BYTES_REF);
            case ElementType.INT -> new EvaluatorFactory(toEvaluator.apply(this.field), ordering, (TriFunction<BlockFactory, Block, Boolean, Block>)((TriFunction)(blockFactory, fieldBlock, sortOrder) -> new MultivalueDedupeInt((IntBlock)fieldBlock).sortToBlock(blockFactory, sortOrder.booleanValue())), ElementType.INT);
            case ElementType.LONG -> new EvaluatorFactory(toEvaluator.apply(this.field), ordering, (TriFunction<BlockFactory, Block, Boolean, Block>)((TriFunction)(blockFactory, fieldBlock, sortOrder) -> new MultivalueDedupeLong((LongBlock)fieldBlock).sortToBlock(blockFactory, sortOrder.booleanValue())), ElementType.LONG);
            case ElementType.DOUBLE -> new EvaluatorFactory(toEvaluator.apply(this.field), ordering, (TriFunction<BlockFactory, Block, Boolean, Block>)((TriFunction)(blockFactory, fieldBlock, sortOrder) -> new MultivalueDedupeDouble((DoubleBlock)fieldBlock).sortToBlock(blockFactory, sortOrder.booleanValue())), ElementType.DOUBLE);
            case ElementType.NULL -> EvalOperator.CONSTANT_NULL_FACTORY;
            default -> throw new IllegalArgumentException("unsupported type [" + this.field.dataType() + "]");
        };
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvSort(this.source(), newChildren.get(0), newChildren.size() > 1 ? newChildren.get(1) : null);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvSort::new, (Object)this.field, (Object)this.order);
    }

    public DataType dataType() {
        return this.field.dataType();
    }

    public int hashCode() {
        return Objects.hash(this.field, this.order);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MvSort other = (MvSort)obj;
        return Objects.equals(other.field, this.field) && Objects.equals(other.order, this.order);
    }

    @Override
    public void validate(Failures failures) {
        String operation = this.sourceText();
        failures.add(Validations.isFoldable(this.order, operation, TypeResolutions.ParamOrdinal.SECOND));
    }

    private record EvaluatorFactory(EvalOperator.ExpressionEvaluator.Factory field, boolean order, TriFunction<BlockFactory, Block, Boolean, Block> sort, ElementType dataType) implements EvalOperator.ExpressionEvaluator.Factory
    {
        public EvalOperator.ExpressionEvaluator get(DriverContext context) {
            return new Evaluator(context.blockFactory(), this.field.get(context), this.order, this.sort, this.dataType);
        }

        @Override
        public String toString() {
            return "MvSort" + this.dataType + "[field=" + this.field + ", order=" + this.order + "]";
        }
    }

    private static class Evaluator
    implements EvalOperator.ExpressionEvaluator {
        private final BlockFactory blockFactory;
        private final EvalOperator.ExpressionEvaluator field;
        private final boolean order;
        private final TriFunction<BlockFactory, Block, Boolean, Block> sort;
        private final ElementType dataType;

        protected Evaluator(BlockFactory blockFactory, EvalOperator.ExpressionEvaluator field, boolean order, TriFunction<BlockFactory, Block, Boolean, Block> sort, ElementType dataType) {
            this.blockFactory = blockFactory;
            this.field = field;
            this.order = order;
            this.sort = sort;
            this.dataType = dataType;
        }

        public Block eval(Page page) {
            try (Block fieldBlock = this.field.eval(page);){
                Block block = (Block)this.sort.apply((Object)this.blockFactory, (Object)fieldBlock, (Object)this.order);
                return block;
            }
        }

        public String toString() {
            return "MvSort" + this.dataType + "[field=" + this.field + ", order=" + this.order + "]";
        }

        public void close() {
        }
    }
}

