/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSliceBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSliceBytesRefEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSliceDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSliceIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSliceLongEvaluator;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.InvalidArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;

public class MvSlice
extends EsqlScalarFunction
implements OptionalArgument,
EvaluatorMapper {
    private final Expression field;
    private final Expression start;
    private final Expression end;

    @FunctionInfo(returnType={"boolean", "cartesian_point", "cartesian_shape", "date", "double", "geo_point", "geo_shape", "integer", "ip", "keyword", "long", "text", "version"}, description="Returns a subset of the multivalued field using the start and end index values.")
    public MvSlice(Source source, @Param(name="field", type={"boolean", "cartesian_point", "cartesian_shape", "date", "double", "geo_point", "geo_shape", "integer", "ip", "keyword", "long", "text", "version"}, description="A multivalued field") Expression field, @Param(name="start", type={"integer"}, description="start index") Expression start, @Param(name="end", type={"integer"}, description="end index (included)", optional=true) Expression end) {
        super(source, end == null ? Arrays.asList(field, start, start) : Arrays.asList(field, start, end));
        this.field = field;
        this.start = start;
        this.end = end == null ? start : end;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isType((Expression)this.field, EsqlDataTypes::isRepresentable, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"representable"});
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isInteger((Expression)this.start, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.end != null && (resolution = TypeResolutions.isInteger((Expression)this.end, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD)).unresolved()) {
            return resolution;
        }
        return resolution;
    }

    public boolean foldable() {
        return this.field.foldable() && this.start.foldable() && (this.end == null || this.end.foldable());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        if (this.start.foldable() && this.end.foldable()) {
            int startOffset = EsqlDataTypeConverter.stringToInt(String.valueOf(this.start.fold()));
            int endOffset = EsqlDataTypeConverter.stringToInt(String.valueOf(this.end.fold()));
            MvSlice.checkStartEnd(startOffset, endOffset);
        }
        return switch (PlannerUtils.toElementType(this.field.dataType())) {
            case ElementType.BOOLEAN -> new MvSliceBooleanEvaluator.Factory(this.source(), toEvaluator.apply(this.field), toEvaluator.apply(this.start), toEvaluator.apply(this.end));
            case ElementType.BYTES_REF -> new MvSliceBytesRefEvaluator.Factory(this.source(), toEvaluator.apply(this.field), toEvaluator.apply(this.start), toEvaluator.apply(this.end));
            case ElementType.DOUBLE -> new MvSliceDoubleEvaluator.Factory(this.source(), toEvaluator.apply(this.field), toEvaluator.apply(this.start), toEvaluator.apply(this.end));
            case ElementType.INT -> new MvSliceIntEvaluator.Factory(this.source(), toEvaluator.apply(this.field), toEvaluator.apply(this.start), toEvaluator.apply(this.end));
            case ElementType.LONG -> new MvSliceLongEvaluator.Factory(this.source(), toEvaluator.apply(this.field), toEvaluator.apply(this.start), toEvaluator.apply(this.end));
            case ElementType.NULL -> EvalOperator.CONSTANT_NULL_FACTORY;
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.field.dataType());
        };
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvSlice(this.source(), newChildren.get(0), newChildren.get(1), newChildren.size() > 2 ? newChildren.get(2) : null);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvSlice::new, (Object)this.field, (Object)this.start, (Object)this.end);
    }

    public DataType dataType() {
        return this.field.dataType();
    }

    public int hashCode() {
        return Objects.hash(this.field, this.start, this.end);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MvSlice other = (MvSlice)obj;
        return Objects.equals(other.field, this.field) && Objects.equals(other.start, this.start) && Objects.equals(other.end, this.end);
    }

    static int adjustIndex(int oldOffset, int fieldValueCount, int first) {
        return oldOffset < 0 ? oldOffset + fieldValueCount + first : oldOffset + first;
    }

    static void checkStartEnd(int start, int end) throws InvalidArgumentException {
        if (start > end) {
            throw new InvalidArgumentException("Start offset is greater than end offset", new Object[0]);
        }
        if (start < 0 && end >= 0) {
            throw new InvalidArgumentException("Start and end offset have different signs", new Object[0]);
        }
    }

    static void process(BooleanBlock.Builder builder, int position, BooleanBlock field, int start, int end) {
        int fieldValueCount = field.getValueCount(position);
        MvSlice.checkStartEnd(start, end);
        int first = field.getFirstValueIndex(position);
        int mvStartIndex = MvSlice.adjustIndex(start, fieldValueCount, first);
        mvStartIndex = Math.max(first, mvStartIndex);
        int mvEndIndex = MvSlice.adjustIndex(end, fieldValueCount, first);
        mvEndIndex = Math.min(fieldValueCount + first - 1, mvEndIndex);
        if (mvStartIndex >= fieldValueCount + first || mvEndIndex < first) {
            builder.appendNull();
            return;
        }
        if (mvStartIndex == mvEndIndex) {
            builder.appendBoolean(field.getBoolean(mvStartIndex));
            return;
        }
        builder.beginPositionEntry();
        for (int i = mvStartIndex; i <= mvEndIndex; ++i) {
            builder.appendBoolean(field.getBoolean(i));
        }
        builder.endPositionEntry();
    }

    static void process(IntBlock.Builder builder, int position, IntBlock field, int start, int end) {
        int fieldValueCount = field.getValueCount(position);
        MvSlice.checkStartEnd(start, end);
        int first = field.getFirstValueIndex(position);
        int mvStartIndex = MvSlice.adjustIndex(start, fieldValueCount, first);
        mvStartIndex = Math.max(first, mvStartIndex);
        int mvEndIndex = MvSlice.adjustIndex(end, fieldValueCount, first);
        mvEndIndex = Math.min(fieldValueCount + first - 1, mvEndIndex);
        if (mvStartIndex >= fieldValueCount + first || mvEndIndex < first) {
            builder.appendNull();
            return;
        }
        if (mvStartIndex == mvEndIndex) {
            builder.appendInt(field.getInt(mvStartIndex));
            return;
        }
        builder.beginPositionEntry();
        for (int i = mvStartIndex; i <= mvEndIndex; ++i) {
            builder.appendInt(field.getInt(i));
        }
        builder.endPositionEntry();
    }

    static void process(LongBlock.Builder builder, int position, LongBlock field, int start, int end) {
        int fieldValueCount = field.getValueCount(position);
        MvSlice.checkStartEnd(start, end);
        int first = field.getFirstValueIndex(position);
        int mvStartIndex = MvSlice.adjustIndex(start, fieldValueCount, first);
        mvStartIndex = Math.max(first, mvStartIndex);
        int mvEndIndex = MvSlice.adjustIndex(end, fieldValueCount, first);
        mvEndIndex = Math.min(fieldValueCount + first - 1, mvEndIndex);
        if (mvStartIndex >= fieldValueCount + first || mvEndIndex < first) {
            builder.appendNull();
            return;
        }
        if (mvStartIndex == mvEndIndex) {
            builder.appendLong(field.getLong(mvStartIndex));
            return;
        }
        builder.beginPositionEntry();
        for (int i = mvStartIndex; i <= mvEndIndex; ++i) {
            builder.appendLong(field.getLong(i));
        }
        builder.endPositionEntry();
    }

    static void process(DoubleBlock.Builder builder, int position, DoubleBlock field, int start, int end) {
        int fieldValueCount = field.getValueCount(position);
        MvSlice.checkStartEnd(start, end);
        int first = field.getFirstValueIndex(position);
        int mvStartIndex = MvSlice.adjustIndex(start, fieldValueCount, first);
        mvStartIndex = Math.max(first, mvStartIndex);
        int mvEndIndex = MvSlice.adjustIndex(end, fieldValueCount, first);
        mvEndIndex = Math.min(fieldValueCount + first - 1, mvEndIndex);
        if (mvStartIndex >= fieldValueCount + first || mvEndIndex < first) {
            builder.appendNull();
            return;
        }
        if (mvStartIndex == mvEndIndex) {
            builder.appendDouble(field.getDouble(mvStartIndex));
            return;
        }
        builder.beginPositionEntry();
        for (int i = mvStartIndex; i <= mvEndIndex; ++i) {
            builder.appendDouble(field.getDouble(i));
        }
        builder.endPositionEntry();
    }

    static void process(BytesRefBlock.Builder builder, int position, BytesRefBlock field, int start, int end) {
        int fieldValueCount = field.getValueCount(position);
        MvSlice.checkStartEnd(start, end);
        int first = field.getFirstValueIndex(position);
        int mvStartIndex = MvSlice.adjustIndex(start, fieldValueCount, first);
        mvStartIndex = Math.max(first, mvStartIndex);
        int mvEndIndex = MvSlice.adjustIndex(end, fieldValueCount, first);
        mvEndIndex = Math.min(fieldValueCount + first - 1, mvEndIndex);
        if (mvStartIndex >= fieldValueCount + first || mvEndIndex < first) {
            builder.appendNull();
            return;
        }
        BytesRef fieldScratch = new BytesRef();
        if (mvStartIndex == mvEndIndex) {
            builder.appendBytesRef(field.getBytesRef(mvStartIndex, fieldScratch));
            return;
        }
        builder.beginPositionEntry();
        for (int i = mvStartIndex; i <= mvEndIndex; ++i) {
            builder.appendBytesRef(field.getBytesRef(i, fieldScratch));
        }
        builder.endPositionEntry();
    }
}

