/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvFirstBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvFirstBytesRefEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvFirstDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvFirstIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvFirstLongEvaluator;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class MvFirst
extends AbstractMultivalueFunction {
    @FunctionInfo(returnType={"boolean", "cartesian_point", "cartesian_shape", "date", "double", "geo_point", "geo_shape", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Reduce a multivalued field to a single valued field containing the first value.")
    public MvFirst(Source source, @Param(name="field", type={"boolean", "cartesian_point", "cartesian_shape", "date", "double", "geo_point", "geo_shape", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}) Expression field) {
        super(source, field);
    }

    @Override
    protected Expression.TypeResolution resolveFieldType() {
        return TypeResolutions.isType((Expression)this.field(), EsqlDataTypes::isRepresentable, (String)this.sourceText(), null, (String[])new String[]{"representable"});
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory fieldEval) {
        return switch (PlannerUtils.toElementType(this.field().dataType())) {
            case ElementType.BOOLEAN -> new MvFirstBooleanEvaluator.Factory(fieldEval);
            case ElementType.BYTES_REF -> new MvFirstBytesRefEvaluator.Factory(fieldEval);
            case ElementType.DOUBLE -> new MvFirstDoubleEvaluator.Factory(fieldEval);
            case ElementType.INT -> new MvFirstIntEvaluator.Factory(fieldEval);
            case ElementType.LONG -> new MvFirstLongEvaluator.Factory(fieldEval);
            case ElementType.NULL -> EvalOperator.CONSTANT_NULL_FACTORY;
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.field.dataType());
        };
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvFirst(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvFirst::new, (Object)this.field());
    }

    static boolean process(BooleanBlock block, int start, int end) {
        return block.getBoolean(start);
    }

    static long process(LongBlock block, int start, int end) {
        return block.getLong(start);
    }

    static int process(IntBlock block, int start, int end) {
        return block.getInt(start);
    }

    static double process(DoubleBlock block, int start, int end) {
        return block.getDouble(start);
    }

    static BytesRef process(BytesRefBlock block, int start, int end, BytesRef scratch) {
        return block.getBytesRef(start, scratch);
    }
}

