/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.SignumDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.SignumIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.SignumLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.SignumUnsignedLongEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class Signum
extends UnaryScalarFunction {
    @FunctionInfo(returnType={"double"}, description="Returns the sign of the given number.\nIt returns `-1` for negative numbers, `0` for `0` and `1` for positive numbers.", examples={@Example(file="math", tag="signum")})
    public Signum(Source source, @Param(name="number", type={"double", "integer", "long", "unsigned_long"}, description="Numeric expression. If `null`, the function returns `null`.") Expression n) {
        super(source, n);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory field = toEvaluator.apply(this.field());
        DataType fieldType = this.field().dataType();
        if (fieldType == DataTypes.DOUBLE) {
            return new SignumDoubleEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataTypes.INTEGER) {
            return new SignumIntEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataTypes.LONG) {
            return new SignumLongEvaluator.Factory(this.source(), field);
        }
        if (fieldType == DataTypes.UNSIGNED_LONG) {
            return new SignumUnsignedLongEvaluator.Factory(this.source(), field);
        }
        throw EsqlIllegalArgumentException.illegalDataType(fieldType);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Signum(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Signum::new, (Object)this.field());
    }

    @Override
    public DataType dataType() {
        return DataTypes.DOUBLE;
    }

    static double process(double val) {
        return Math.signum(val);
    }

    static double process(int val) {
        return Math.signum(val);
    }

    static double process(long val) {
        return Math.signum(val);
    }

    static double processUnsignedLong(long val) {
        return Math.signum(NumericUtils.unsignedLongToDouble((long)val));
    }
}

