/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Round;
import org.elasticsearch.xpack.ql.tree.Source;

public final class RoundDoubleEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator val;
    private final EvalOperator.ExpressionEvaluator decimals;
    private final DriverContext driverContext;

    public RoundDoubleEvaluator(Source source, EvalOperator.ExpressionEvaluator val, EvalOperator.ExpressionEvaluator decimals, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.val = val;
        this.decimals = decimals;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (DoubleBlock valBlock = (DoubleBlock)this.val.eval(page);){
            DoubleBlock doubleBlock;
            block20: {
                LongVector decimalsVector;
                DoubleVector valVector;
                LongBlock decimalsBlock;
                block18: {
                    DoubleBlock doubleBlock2;
                    block19: {
                        block16: {
                            DoubleBlock doubleBlock3;
                            block17: {
                                decimalsBlock = (LongBlock)this.decimals.eval(page);
                                try {
                                    valVector = valBlock.asVector();
                                    if (valVector != null) break block16;
                                    doubleBlock3 = this.eval(page.getPositionCount(), valBlock, decimalsBlock);
                                    if (decimalsBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (decimalsBlock != null) {
                                        try {
                                            decimalsBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                decimalsBlock.close();
                            }
                            return doubleBlock3;
                        }
                        decimalsVector = decimalsBlock.asVector();
                        if (decimalsVector != null) break block18;
                        doubleBlock2 = this.eval(page.getPositionCount(), valBlock, decimalsBlock);
                        if (decimalsBlock == null) break block19;
                        decimalsBlock.close();
                    }
                    return doubleBlock2;
                }
                doubleBlock = this.eval(page.getPositionCount(), valVector, decimalsVector).asBlock();
                if (decimalsBlock == null) break block20;
                decimalsBlock.close();
            }
            return doubleBlock;
        }
    }

    public DoubleBlock eval(int positionCount, DoubleBlock valBlock, LongBlock decimalsBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (valBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valBlock.getValueCount(p) != 1) {
                    if (valBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (decimalsBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (decimalsBlock.getValueCount(p) != 1) {
                    if (decimalsBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendDouble(Round.process(valBlock.getDouble(valBlock.getFirstValueIndex(p)), decimalsBlock.getLong(decimalsBlock.getFirstValueIndex(p))));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, DoubleVector valVector, LongVector decimalsVector) {
        try (DoubleVector.Builder result = this.driverContext.blockFactory().newDoubleVectorBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendDouble(Round.process(valVector.getDouble(p), decimalsVector.getLong(p)));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "RoundDoubleEvaluator[val=" + this.val + ", decimals=" + this.decimals + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.val, this.decimals});
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory val;
        private final EvalOperator.ExpressionEvaluator.Factory decimals;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory val, EvalOperator.ExpressionEvaluator.Factory decimals) {
            this.source = source;
            this.val = val;
            this.decimals = decimals;
        }

        public RoundDoubleEvaluator get(DriverContext context) {
            return new RoundDoubleEvaluator(this.source, this.val.get(context), this.decimals.get(context), context);
        }

        public String toString() {
            return "RoundDoubleEvaluator[val=" + this.val + ", decimals=" + this.decimals + "]";
        }
    }
}

