/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CastIntToDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CastIntToLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CastIntToUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CastLongToDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CastLongToUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CastUnsignedLongToDoubleEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Cast {
    public static EvalOperator.ExpressionEvaluator.Factory cast(Source source, DataType current, DataType required, EvalOperator.ExpressionEvaluator.Factory in) {
        if (current == required) {
            return in;
        }
        if (current == DataTypes.NULL || required == DataTypes.NULL) {
            return EvalOperator.CONSTANT_NULL_FACTORY;
        }
        if (required == DataTypes.DOUBLE) {
            if (current == DataTypes.LONG) {
                return new CastLongToDoubleEvaluator.Factory(source, in);
            }
            if (current == DataTypes.INTEGER) {
                return new CastIntToDoubleEvaluator.Factory(source, in);
            }
            if (current == DataTypes.UNSIGNED_LONG) {
                return new CastUnsignedLongToDoubleEvaluator.Factory(source, in);
            }
            throw Cast.cantCast(current, required);
        }
        if (required == DataTypes.UNSIGNED_LONG) {
            if (current == DataTypes.LONG) {
                return new CastLongToUnsignedLongEvaluator.Factory(source, in);
            }
            if (current == DataTypes.INTEGER) {
                return new CastIntToUnsignedLongEvaluator.Factory(source, in);
            }
        }
        if (required == DataTypes.LONG) {
            if (current == DataTypes.INTEGER) {
                return new CastIntToLongEvaluator.Factory(source, in);
            }
            throw Cast.cantCast(current, required);
        }
        throw Cast.cantCast(current, required);
    }

    private static EsqlIllegalArgumentException cantCast(DataType current, DataType required) {
        return new EsqlIllegalArgumentException("can't process [" + current.typeName() + " -> " + required.typeName() + "]");
    }

    static long castIntToLong(int v) {
        return v;
    }

    static double castIntToDouble(int v) {
        return v;
    }

    static double castLongToDouble(long v) {
        return v;
    }

    static double castUnsignedLongToDouble(long v) {
        return EsqlDataTypeConverter.unsignedLongToDouble(v);
    }

    static long castIntToUnsignedLong(int v) {
        return EsqlDataTypeConverter.intToUnsignedLong(v);
    }

    static long castLongToUnsignedLong(long v) {
        return EsqlDataTypeConverter.longToUnsignedLong(v, false);
    }
}

