/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.ip;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.network.CIDRUtils;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.ip.CIDRMatchEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public class CIDRMatch
extends EsqlScalarFunction {
    private final Expression ipField;
    private final List<Expression> matches;

    @FunctionInfo(returnType={"boolean"}, description="Returns true if the provided IP is contained in one of the provided CIDR blocks.")
    public CIDRMatch(Source source, @Param(name="ip", type={"ip"}) Expression ipField, @Param(name="blockX", type={"keyword", "text"}, description="CIDR block to test the IP against.") List<Expression> matches) {
        super(source, CollectionUtils.combine(Collections.singletonList(ipField), matches));
        this.ipField = ipField;
        this.matches = matches;
    }

    public Expression ipField() {
        return this.ipField;
    }

    public List<Expression> matches() {
        return this.matches;
    }

    public boolean foldable() {
        return Expressions.foldable((List)this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory ipEvaluatorSupplier = toEvaluator.apply(this.ipField);
        return new CIDRMatchEvaluator.Factory(this.source(), ipEvaluatorSupplier, (EvalOperator.ExpressionEvaluator.Factory[])this.matches.stream().map(x -> (EvalOperator.ExpressionEvaluator.Factory)toEvaluator.apply((Expression)x)).toArray(EvalOperator.ExpressionEvaluator.Factory[]::new));
    }

    static boolean process(BytesRef ip, BytesRef[] cidrs) {
        for (BytesRef cidr : cidrs) {
            if (!CIDRUtils.isInRange((byte[])Arrays.copyOfRange(ip.bytes, ip.offset, ip.offset + ip.length), (String)cidr.utf8ToString())) continue;
            return true;
        }
        return false;
    }

    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isIPAndExact((Expression)this.ipField, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        int i = 1;
        for (Expression m : this.matches) {
            resolution = EsqlTypeResolutions.isStringAndExact(m, this.sourceText(), TypeResolutions.ParamOrdinal.fromIndex((int)i++));
            if (!resolution.unresolved()) continue;
            return resolution;
        }
        return resolution;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new CIDRMatch(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, CIDRMatch::new, (Object)((Expression)this.children().get(0)), this.children().subList(1, this.children().size()));
    }
}

