/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlConfigurationFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.NowEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Now
extends EsqlConfigurationFunction {
    private final long now;

    @FunctionInfo(returnType={"date"}, description="Returns current date and time.", examples={@Example(file="date", tag="docsNow"), @Example(file="date", tag="docsNowWhere", description="To retrieve logs from the last hour:")})
    public Now(Source source, Configuration configuration) {
        super(source, List.of(), configuration);
        this.now = configuration.now() == null ? System.currentTimeMillis() : configuration.now().toInstant().toEpochMilli();
    }

    private Now(Source source, long now) {
        super(source, List.of(), null);
        this.now = now;
    }

    public static Now newInstance(Source source, long now) {
        return new Now(source, now);
    }

    @Override
    public Object fold() {
        return this.now;
    }

    public boolean foldable() {
        return true;
    }

    public DataType dataType() {
        return DataTypes.DATETIME;
    }

    static long process(long now) {
        return now;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return this;
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Now::new, (Object)this.configuration());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        return dvrCtx -> new NowEvaluator(this.source(), this.now, dvrCtx);
    }
}

