/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromCartesianPointEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromCartesianShapeEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromDatetimeEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromGeoPointEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromGeoShapeEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromIPEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromVersionEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class ToString
extends AbstractConvertFunction
implements EvaluatorMapper {
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataTypes.KEYWORD, (fieldEval, source) -> fieldEval), Map.entry(DataTypes.BOOLEAN, ToStringFromBooleanEvaluator.Factory::new), Map.entry(DataTypes.DATETIME, ToStringFromDatetimeEvaluator.Factory::new), Map.entry(DataTypes.IP, ToStringFromIPEvaluator.Factory::new), Map.entry(DataTypes.DOUBLE, ToStringFromDoubleEvaluator.Factory::new), Map.entry(DataTypes.LONG, ToStringFromLongEvaluator.Factory::new), Map.entry(DataTypes.INTEGER, ToStringFromIntEvaluator.Factory::new), Map.entry(DataTypes.TEXT, (fieldEval, source) -> fieldEval), Map.entry(DataTypes.VERSION, ToStringFromVersionEvaluator.Factory::new), Map.entry(DataTypes.UNSIGNED_LONG, ToStringFromUnsignedLongEvaluator.Factory::new), Map.entry(EsqlDataTypes.GEO_POINT, ToStringFromGeoPointEvaluator.Factory::new), Map.entry(EsqlDataTypes.CARTESIAN_POINT, ToStringFromCartesianPointEvaluator.Factory::new), Map.entry(EsqlDataTypes.CARTESIAN_SHAPE, ToStringFromCartesianShapeEvaluator.Factory::new), Map.entry(EsqlDataTypes.GEO_SHAPE, ToStringFromGeoShapeEvaluator.Factory::new));

    @FunctionInfo(returnType={"keyword"}, description="Converts a field into a string.")
    public ToString(Source source, @Param(name="field", type={"boolean", "cartesian_point", "cartesian_shape", "date", "double", "geo_point", "geo_shape", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}) Expression v) {
        super(source, v);
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataTypes.KEYWORD;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToString(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToString::new, (Object)this.field());
    }

    static BytesRef fromBoolean(boolean bool) {
        return EsqlDataTypeConverter.numericBooleanToString(bool);
    }

    static BytesRef fromIP(BytesRef ip) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.ipToString(ip));
    }

    static BytesRef fromDatetime(long datetime) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.dateTimeToString(datetime));
    }

    static BytesRef fromDouble(double dbl) {
        return EsqlDataTypeConverter.numericBooleanToString(dbl);
    }

    static BytesRef fromDouble(long lng) {
        return EsqlDataTypeConverter.numericBooleanToString(lng);
    }

    static BytesRef fromDouble(int integer) {
        return EsqlDataTypeConverter.numericBooleanToString(integer);
    }

    static BytesRef fromVersion(BytesRef version) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.versionToString(version));
    }

    static BytesRef fromUnsignedLong(long lng) {
        return EsqlDataTypeConverter.unsignedLongToString(lng);
    }

    static BytesRef fromGeoPoint(BytesRef wkb) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.spatialToString(wkb));
    }

    static BytesRef fromCartesianPoint(BytesRef wkb) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.spatialToString(wkb));
    }

    static BytesRef fromCartesianShape(BytesRef wkb) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.spatialToString(wkb));
    }

    static BytesRef fromGeoShape(BytesRef wkb) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.spatialToString(wkb));
    }
}

