/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToGeoPointFromStringEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class ToGeoPoint
extends AbstractConvertFunction {
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(EsqlDataTypes.GEO_POINT, (fieldEval, source) -> fieldEval), Map.entry(DataTypes.KEYWORD, ToGeoPointFromStringEvaluator.Factory::new), Map.entry(DataTypes.TEXT, ToGeoPointFromStringEvaluator.Factory::new));

    @FunctionInfo(returnType={"geo_point"}, description="Converts an input value to a geo_point value.")
    public ToGeoPoint(Source source, @Param(name="field", type={"geo_point", "keyword", "text"}) Expression field) {
        super(source, field);
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return EsqlDataTypes.GEO_POINT;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToGeoPoint(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToGeoPoint::new, (Object)this.field());
    }

    static BytesRef fromKeyword(BytesRef in) {
        return EsqlDataTypeConverter.stringToSpatial(in.utf8ToString());
    }
}

