/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDouble;
import org.elasticsearch.xpack.ql.tree.Source;

public final class ToDoubleFromBooleanEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    public ToDoubleFromBooleanEvaluator(EvalOperator.ExpressionEvaluator field, Source source, DriverContext driverContext) {
        super(driverContext, field, source);
    }

    @Override
    public String name() {
        return "ToDoubleFromBoolean";
    }

    @Override
    public Block evalVector(Vector v) {
        BooleanVector vector = (BooleanVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantDoubleBlockWith(ToDoubleFromBooleanEvaluator.evalValue(vector, 0), positionCount);
        }
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendDouble(ToDoubleFromBooleanEvaluator.evalValue(vector, p));
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private static double evalValue(BooleanVector container, int index) {
        boolean value = container.getBoolean(index);
        return ToDouble.fromBoolean(value);
    }

    @Override
    public Block evalBlock(Block b) {
        BooleanBlock block = (BooleanBlock)b;
        int positionCount = block.getPositionCount();
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    double value = ToDoubleFromBooleanEvaluator.evalValue(block, i);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendDouble(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private static double evalValue(BooleanBlock container, int index) {
        boolean value = container.getBoolean(index);
        return ToDouble.fromBoolean(value);
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field, Source source) {
            this.field = field;
            this.source = source;
        }

        public ToDoubleFromBooleanEvaluator get(DriverContext context) {
            return new ToDoubleFromBooleanEvaluator(this.field.get(context), this.source, context);
        }

        public String toString() {
            return "ToDoubleFromBooleanEvaluator[field=" + this.field + "]";
        }
    }
}

