/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.List;
import java.util.Map;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDegreesEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDoubleFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class ToDegrees
extends AbstractConvertFunction
implements EvaluatorMapper {
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataTypes.DOUBLE, ToDegreesEvaluator.Factory::new), Map.entry(DataTypes.INTEGER, (field, source) -> new ToDegreesEvaluator.Factory(new ToDoubleFromIntEvaluator.Factory(field, source), source)), Map.entry(DataTypes.LONG, (field, source) -> new ToDegreesEvaluator.Factory(new ToDoubleFromLongEvaluator.Factory(field, source), source)), Map.entry(DataTypes.UNSIGNED_LONG, (field, source) -> new ToDegreesEvaluator.Factory(new ToDoubleFromUnsignedLongEvaluator.Factory(field, source), source)));

    @FunctionInfo(returnType={"double"}, description="Converts a number in radians to degrees.")
    public ToDegrees(Source source, @Param(name="number", type={"double", "integer", "long", "unsigned_long"}) Expression field) {
        super(source, field);
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToDegrees(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToDegrees::new, (Object)this.field());
    }

    @Override
    public DataType dataType() {
        return DataTypes.DOUBLE;
    }

    static double process(double deg) {
        return NumericUtils.asFiniteNumber((double)Math.toDegrees(deg));
    }
}

