/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBooleanFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBooleanFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBooleanFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBooleanFromStringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBooleanFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class ToBoolean
extends AbstractConvertFunction {
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataTypes.BOOLEAN, (field, source) -> field), Map.entry(DataTypes.KEYWORD, ToBooleanFromStringEvaluator.Factory::new), Map.entry(DataTypes.TEXT, ToBooleanFromStringEvaluator.Factory::new), Map.entry(DataTypes.DOUBLE, ToBooleanFromDoubleEvaluator.Factory::new), Map.entry(DataTypes.LONG, ToBooleanFromLongEvaluator.Factory::new), Map.entry(DataTypes.UNSIGNED_LONG, ToBooleanFromUnsignedLongEvaluator.Factory::new), Map.entry(DataTypes.INTEGER, ToBooleanFromIntEvaluator.Factory::new));

    @FunctionInfo(returnType={"boolean"}, description="Converts an input value to a boolean value.")
    public ToBoolean(Source source, @Param(name="field", type={"boolean", "keyword", "text", "double", "long", "unsigned_long", "integer"}) Expression field) {
        super(source, field);
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToBoolean(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToBoolean::new, (Object)this.field());
    }

    static boolean fromKeyword(BytesRef keyword) {
        return EsqlDataTypeConverter.stringToBoolean(keyword.utf8ToString());
    }

    static boolean fromDouble(double d) {
        return d != 0.0;
    }

    static boolean fromLong(long l) {
        return l != 0L;
    }

    static boolean fromUnsignedLong(long ul) {
        return EsqlDataTypeConverter.unsignedLongToBoolean(ul);
    }

    static boolean fromInt(int i) {
        return ToBoolean.fromLong(i);
    }
}

