/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.GreatestBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.GreatestBytesRefEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.GreatestDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.GreatestIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.GreatestLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMax;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Greatest
extends EsqlScalarFunction
implements OptionalArgument {
    private DataType dataType;

    @FunctionInfo(returnType={"integer", "long", "double", "boolean", "keyword", "text", "ip", "version"}, description="Returns the maximum value from many columns.")
    public Greatest(Source source, @Param(name="first", type={"integer", "long", "double", "boolean", "keyword", "text", "ip", "version"}) Expression first, @Param(name="rest", type={"integer", "long", "double", "boolean", "keyword", "text", "ip", "version"}, optional=true) List<Expression> rest) {
        super(source, Stream.concat(Stream.of(first), rest.stream()).toList());
    }

    public DataType dataType() {
        if (this.dataType == null) {
            this.resolveType();
        }
        return this.dataType;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        for (int position = 0; position < this.children().size(); ++position) {
            Expression child = (Expression)this.children().get(position);
            if (this.dataType == null || this.dataType == DataTypes.NULL) {
                this.dataType = child.dataType();
                continue;
            }
            Expression.TypeResolution resolution = TypeResolutions.isType((Expression)child, t -> t == this.dataType, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.fromIndex((int)position), (String[])new String[]{this.dataType.typeName()});
            if (!resolution.unresolved()) continue;
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Greatest(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Greatest::new, (Object)((Expression)this.children().get(0)), this.children().subList(1, this.children().size()));
    }

    public boolean foldable() {
        return Expressions.foldable((List)this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        DataType dataType = this.dataType();
        EvalOperator.ExpressionEvaluator.Factory[] factories = (EvalOperator.ExpressionEvaluator.Factory[])this.children().stream().map(e -> (EvalOperator.ExpressionEvaluator.Factory)toEvaluator.apply((Expression)new MvMax(e.source(), (Expression)e))).toArray(EvalOperator.ExpressionEvaluator.Factory[]::new);
        if (dataType == DataTypes.BOOLEAN) {
            return new GreatestBooleanEvaluator.Factory(this.source(), factories);
        }
        if (dataType == DataTypes.DOUBLE) {
            return new GreatestDoubleEvaluator.Factory(this.source(), factories);
        }
        if (dataType == DataTypes.INTEGER) {
            return new GreatestIntEvaluator.Factory(this.source(), factories);
        }
        if (dataType == DataTypes.LONG) {
            return new GreatestLongEvaluator.Factory(this.source(), factories);
        }
        if (dataType == DataTypes.KEYWORD || dataType == DataTypes.TEXT || dataType == DataTypes.IP || dataType == DataTypes.VERSION || dataType == DataTypes.UNSUPPORTED) {
            return new GreatestBytesRefEvaluator.Factory(this.source(), factories);
        }
        throw EsqlIllegalArgumentException.illegalDataType(dataType);
    }

    static boolean process(boolean[] values) {
        for (boolean v : values) {
            if (!v) continue;
            return true;
        }
        return false;
    }

    static BytesRef process(BytesRef[] values) {
        BytesRef max = values[0];
        for (int i = 1; i < values.length; ++i) {
            max = max.compareTo(values[i]) > 0 ? max : values[i];
        }
        return max;
    }

    static int process(int[] values) {
        int max = values[0];
        for (int i = 1; i < values.length; ++i) {
            max = Math.max(max, values[i]);
        }
        return max;
    }

    static long process(long[] values) {
        long max = values[0];
        for (int i = 1; i < values.length; ++i) {
            max = Math.max(max, values[i]);
        }
        return max;
    }

    static double process(double[] values) {
        double max = values[0];
        for (int i = 1; i < values.length; ++i) {
            max = Math.max(max, values[i]);
        }
        return max;
    }
}

