/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.grouping;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.capabilities.Validatable;
import org.elasticsearch.xpack.esql.expression.Validations;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateTrunc;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Floor;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Div;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.common.Failures;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Foldables;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.TwoOptionalArguments;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Bucket
extends GroupingFunction
implements Validatable,
TwoOptionalArguments {
    private static final Rounding LARGEST_HUMAN_DATE_ROUNDING = Rounding.builder((Rounding.DateTimeUnit)Rounding.DateTimeUnit.YEAR_OF_CENTURY).build();
    private static final Rounding[] HUMAN_DATE_ROUNDINGS = new Rounding[]{Rounding.builder((Rounding.DateTimeUnit)Rounding.DateTimeUnit.MONTH_OF_YEAR).build(), Rounding.builder((Rounding.DateTimeUnit)Rounding.DateTimeUnit.WEEK_OF_WEEKYEAR).build(), Rounding.builder((Rounding.DateTimeUnit)Rounding.DateTimeUnit.DAY_OF_MONTH).build(), Rounding.builder((TimeValue)TimeValue.timeValueHours((long)12L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueHours((long)3L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueHours((long)1L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMinutes((long)30L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMinutes((long)10L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMinutes((long)5L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMinutes((long)1L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueSeconds((long)30L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueSeconds((long)10L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueSeconds((long)5L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueSeconds((long)1L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMillis((long)100L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMillis((long)50L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMillis((long)10L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMillis((long)1L)).build()};
    private static final ZoneId DEFAULT_TZ = ZoneOffset.UTC;
    private final Expression field;
    private final Expression buckets;
    private final Expression from;
    private final Expression to;

    @FunctionInfo(returnType={"double", "date"}, description="Creates groups of values - buckets - out of a datetime or numeric input. The size of the buckets can either\nbe provided directly, or chosen based on a recommended count and values range.")
    public Bucket(Source source, @Param(name="field", type={"integer", "long", "double", "date"}) Expression field, @Param(name="buckets", type={"integer", "double", "date_period", "time_duration"}) Expression buckets, @Param(name="from", type={"integer", "long", "double", "date"}, optional=true) Expression from, @Param(name="to", type={"integer", "long", "double", "date"}, optional=true) Expression to) {
        super(source, from != null && to != null ? List.of(field, buckets, from, to) : List.of(field, buckets));
        this.field = field;
        this.buckets = buckets;
        this.from = from;
        this.to = to;
    }

    public boolean foldable() {
        return !(!this.field.foldable() || !this.buckets.foldable() || this.from != null && !this.from.foldable() || this.to != null && !this.to.foldable());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        if (this.field.dataType() == DataTypes.DATETIME) {
            Rounding.Prepared preparedRounding;
            if (this.buckets.dataType().isInteger()) {
                int b = ((Number)this.buckets.fold()).intValue();
                long f = this.foldToLong(this.from);
                long t = this.foldToLong(this.to);
                preparedRounding = new DateRoundingPicker(b, f, t).pickRounding().prepareForUnknown();
            } else {
                assert (EsqlDataTypes.isTemporalAmount(this.buckets.dataType())) : "Unexpected span data type [" + this.buckets.dataType() + "]";
                preparedRounding = DateTrunc.createRounding(this.buckets.fold(), DEFAULT_TZ);
            }
            return DateTrunc.evaluator(this.source(), toEvaluator.apply(this.field), preparedRounding);
        }
        if (this.field.dataType().isNumeric()) {
            double roundTo;
            if (this.from != null) {
                int b = ((Number)this.buckets.fold()).intValue();
                double f = ((Number)this.from.fold()).doubleValue();
                double t = ((Number)this.to.fold()).doubleValue();
                roundTo = this.pickRounding(b, f, t);
            } else {
                assert (this.buckets.dataType().isRational()) : "Unexpected rounding data type [" + this.buckets.dataType() + "]";
                roundTo = ((Number)this.buckets.fold()).doubleValue();
            }
            Literal rounding = new Literal(this.source(), (Object)roundTo, DataTypes.DOUBLE);
            Div div = new Div(this.source(), this.field, (Expression)rounding);
            Floor floor = new Floor(this.source(), (Expression)div);
            Mul mul = new Mul(this.source(), (Expression)floor, (Expression)rounding);
            return toEvaluator.apply((Expression)mul);
        }
        throw EsqlIllegalArgumentException.illegalDataType(this.field.dataType());
    }

    private double pickRounding(int buckets, double from, double to) {
        double precise = (to - from) / (double)buckets;
        double nextPowerOfTen = Math.pow(10.0, Math.ceil(Math.log10(precise)));
        double halfPower = nextPowerOfTen / 2.0;
        return precise < halfPower ? halfPower : nextPowerOfTen;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        DataType fieldType = this.field.dataType();
        DataType bucketsType = this.buckets.dataType();
        if (fieldType == DataTypes.NULL || bucketsType == DataTypes.NULL) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        if (fieldType == DataTypes.DATETIME) {
            Expression.TypeResolution resolution = TypeResolutions.isType((Expression)this.buckets, dt -> dt.isInteger() || EsqlDataTypes.isTemporalAmount(dt), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"integral", "date_period", "time_duration"});
            return bucketsType.isInteger() ? resolution.and(this.checkArgsCount(4)).and(() -> Bucket.isStringOrDate(this.from, this.sourceText(), TypeResolutions.ParamOrdinal.THIRD)).and(() -> Bucket.isStringOrDate(this.to, this.sourceText(), TypeResolutions.ParamOrdinal.FOURTH)) : resolution.and(this.checkArgsCount(2));
        }
        if (fieldType.isNumeric()) {
            return bucketsType.isInteger() ? this.checkArgsCount(4).and(() -> TypeResolutions.isNumeric((Expression)this.from, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD)).and(() -> TypeResolutions.isNumeric((Expression)this.to, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FOURTH)) : TypeResolutions.isNumeric((Expression)this.buckets, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND).and(this.checkArgsCount(2));
        }
        return TypeResolutions.isType((Expression)this.field, e -> false, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"datetime", "numeric"});
    }

    private Expression.TypeResolution checkArgsCount(int expectedCount) {
        String expected = null;
        if (expectedCount == 2 && (this.from != null || this.to != null)) {
            expected = "two";
        } else if (expectedCount == 4 && (this.from == null || this.to == null)) {
            expected = "four";
        } else if (this.from == null && this.to != null || this.from != null && this.to == null) {
            expected = "two or four";
        }
        return expected == null ? Expression.TypeResolution.TYPE_RESOLVED : new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"function expects exactly {} arguments when the first one is of type [{}] and the second of type [{}]", (Object[])new Object[]{expected, this.field.dataType(), this.buckets.dataType()}));
    }

    private static Expression.TypeResolution isStringOrDate(Expression e, String operationName, TypeResolutions.ParamOrdinal paramOrd) {
        return TypeResolutions.isType((Expression)e, exp -> DataTypes.isString((DataType)exp) || DataTypes.isDateTime((DataType)exp), (String)operationName, (TypeResolutions.ParamOrdinal)paramOrd, (String[])new String[]{"datetime", "string"});
    }

    @Override
    public void validate(Failures failures) {
        String operation = this.sourceText();
        failures.add(Validations.isFoldable(this.buckets, operation, TypeResolutions.ParamOrdinal.SECOND)).add(this.from != null ? Validations.isFoldable(this.from, operation, TypeResolutions.ParamOrdinal.THIRD) : null).add(this.to != null ? Validations.isFoldable(this.to, operation, TypeResolutions.ParamOrdinal.FOURTH) : null);
    }

    private long foldToLong(Expression e) {
        Object value = Foldables.valueOf((Expression)e);
        return DataTypes.isDateTime((DataType)e.dataType()) ? ((Number)value).longValue() : EsqlDataTypeConverter.dateTimeToLong(((BytesRef)value).utf8ToString());
    }

    public DataType dataType() {
        if (this.field.dataType().isNumeric()) {
            return DataTypes.DOUBLE;
        }
        return this.field.dataType();
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        Expression from = newChildren.size() > 2 ? newChildren.get(2) : null;
        Expression to = newChildren.size() > 3 ? newChildren.get(3) : null;
        return new Bucket(this.source(), newChildren.get(0), newChildren.get(1), from, to);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Bucket::new, (Object)this.field, (Object)this.buckets, (Object)this.from, (Object)this.to);
    }

    public Expression field() {
        return this.field;
    }

    public Expression buckets() {
        return this.buckets;
    }

    public Expression from() {
        return this.from;
    }

    public Expression to() {
        return this.to;
    }

    public String toString() {
        return "Bucket{field=" + this.field + ", buckets=" + this.buckets + ", from=" + this.from + ", to=" + this.to + "}";
    }

    private record DateRoundingPicker(int buckets, long from, long to) {
        Rounding pickRounding() {
            Rounding prev = LARGEST_HUMAN_DATE_ROUNDING;
            for (Rounding r : HUMAN_DATE_ROUNDINGS) {
                if (!this.roundingIsOk(r)) {
                    return prev;
                }
                prev = r;
            }
            return prev;
        }

        boolean roundingIsOk(Rounding rounding) {
            Rounding.Prepared r = rounding.prepareForUnknown();
            long bucket = r.round(this.from);
            for (int used = 0; used < this.buckets; ++used) {
                bucket = r.nextRoundingValue(bucket);
                if (bucket <= this.to) continue;
                return true;
            }
            return false;
        }
    }
}

