/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesBooleanAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesBytesRefAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.ValuesLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.planner.ToAggregator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Values
extends AggregateFunction
implements ToAggregator {
    @FunctionInfo(returnType={"boolean|date|double|integer|ip|keyword|long|text|version"}, description="Collect values for a field.", isAggregation=true)
    public Values(Source source, @Param(name="field", type={"boolean|date|double|integer|ip|keyword|long|text|version"}) Expression v) {
        super(source, v);
    }

    protected NodeInfo<Values> info() {
        return NodeInfo.create((Node)this, Values::new, (Object)this.field());
    }

    public Values replaceChildren(List<Expression> newChildren) {
        return new Values(this.source(), newChildren.get(0));
    }

    public DataType dataType() {
        return this.field().dataType();
    }

    protected Expression.TypeResolution resolveType() {
        return EsqlTypeResolutions.isNotSpatial(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    public AggregatorFunctionSupplier supplier(List<Integer> inputChannels) {
        DataType type = this.field().dataType();
        if (type == DataTypes.INTEGER) {
            return new ValuesIntAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataTypes.LONG || type == DataTypes.DATETIME) {
            return new ValuesLongAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataTypes.DOUBLE) {
            return new ValuesDoubleAggregatorFunctionSupplier(inputChannels);
        }
        if (DataTypes.isString((DataType)type) || type == DataTypes.IP || type == DataTypes.VERSION) {
            return new ValuesBytesRefAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataTypes.BOOLEAN) {
            return new ValuesBooleanAggregatorFunctionSupplier(inputChannels);
        }
        throw EsqlIllegalArgumentException.illegalDataType(type);
    }
}

