/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.SumDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.SumIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.SumLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.function.aggregate.NumericAggregate;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSum;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Sum
extends NumericAggregate
implements SurrogateExpression {
    @FunctionInfo(returnType={"long"}, description="The sum of a numeric field.", isAggregation=true)
    public Sum(Source source, @Param(name="number", type={"double", "integer", "long"}) Expression field) {
        super(source, field);
    }

    protected NodeInfo<Sum> info() {
        return NodeInfo.create((Node)this, Sum::new, (Object)this.field());
    }

    public Sum replaceChildren(List<Expression> newChildren) {
        return new Sum(this.source(), newChildren.get(0));
    }

    @Override
    public DataType dataType() {
        DataType dt = this.field().dataType();
        return !dt.isInteger() || dt == DataTypes.UNSIGNED_LONG ? DataTypes.DOUBLE : DataTypes.LONG;
    }

    @Override
    protected AggregatorFunctionSupplier longSupplier(List<Integer> inputChannels) {
        return new SumLongAggregatorFunctionSupplier(inputChannels);
    }

    @Override
    protected AggregatorFunctionSupplier intSupplier(List<Integer> inputChannels) {
        return new SumIntAggregatorFunctionSupplier(inputChannels);
    }

    @Override
    protected AggregatorFunctionSupplier doubleSupplier(List<Integer> inputChannels) {
        return new SumDoubleAggregatorFunctionSupplier(inputChannels);
    }

    @Override
    public Expression surrogate() {
        Source s = this.source();
        Expression field = this.field();
        return field.foldable() ? new Mul(s, (Expression)new MvSum(s, field), (Expression)new Count(s, (Expression)new Literal(s, (Object)"*", DataTypes.KEYWORD))) : null;
    }
}

