/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.PercentileDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.PercentileIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.PercentileLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.NumericAggregate;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Percentile
extends NumericAggregate {
    private final Expression percentile;

    @FunctionInfo(returnType={"double", "integer", "long"}, description="The value at which a certain percentage of observed values occur.", isAggregation=true)
    public Percentile(Source source, @Param(name="number", type={"double", "integer", "long"}) Expression field, @Param(name="percentile", type={"double", "integer", "long"}) Expression percentile) {
        super(source, field, List.of(percentile));
        this.percentile = percentile;
    }

    protected NodeInfo<Percentile> info() {
        return NodeInfo.create((Node)this, Percentile::new, (Object)this.field(), (Object)this.percentile);
    }

    public Percentile replaceChildren(List<Expression> newChildren) {
        return new Percentile(this.source(), newChildren.get(0), newChildren.get(1));
    }

    public Expression percentile() {
        return this.percentile;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isType((Expression)this.field(), dt -> dt.isNumeric() && dt != DataTypes.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"numeric except unsigned_long"});
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isNumeric((Expression)this.percentile, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND).and(TypeResolutions.isFoldable((Expression)this.percentile, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
    }

    @Override
    protected AggregatorFunctionSupplier longSupplier(List<Integer> inputChannels) {
        return new PercentileLongAggregatorFunctionSupplier(inputChannels, (double)this.percentileValue());
    }

    @Override
    protected AggregatorFunctionSupplier intSupplier(List<Integer> inputChannels) {
        return new PercentileIntAggregatorFunctionSupplier(inputChannels, (double)this.percentileValue());
    }

    @Override
    protected AggregatorFunctionSupplier doubleSupplier(List<Integer> inputChannels) {
        return new PercentileDoubleAggregatorFunctionSupplier(inputChannels, (double)this.percentileValue());
    }

    private int percentileValue() {
        return ((Number)this.percentile.fold()).intValue();
    }
}

