/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.planner.ToAggregator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public abstract class NumericAggregate
extends AggregateFunction
implements ToAggregator {
    NumericAggregate(Source source, Expression field, List<Expression> parameters) {
        super(source, field, parameters);
    }

    NumericAggregate(Source source, Expression field) {
        super(source, field);
    }

    protected Expression.TypeResolution resolveType() {
        if (this.supportsDates()) {
            return TypeResolutions.isType((Expression)this, e -> e == DataTypes.DATETIME || e.isNumeric() && e != DataTypes.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"datetime", "numeric except unsigned_long"});
        }
        return TypeResolutions.isType((Expression)this.field(), dt -> dt.isNumeric() && dt != DataTypes.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"numeric except unsigned_long"});
    }

    protected boolean supportsDates() {
        return false;
    }

    public DataType dataType() {
        return DataTypes.DOUBLE;
    }

    @Override
    public final AggregatorFunctionSupplier supplier(List<Integer> inputChannels) {
        DataType type = this.field().dataType();
        if (this.supportsDates() && type == DataTypes.DATETIME) {
            return this.longSupplier(inputChannels);
        }
        if (type == DataTypes.LONG) {
            return this.longSupplier(inputChannels);
        }
        if (type == DataTypes.INTEGER) {
            return this.intSupplier(inputChannels);
        }
        if (type == DataTypes.DOUBLE) {
            return this.doubleSupplier(inputChannels);
        }
        throw EsqlIllegalArgumentException.illegalDataType(type);
    }

    protected abstract AggregatorFunctionSupplier longSupplier(List<Integer> var1);

    protected abstract AggregatorFunctionSupplier intSupplier(List<Integer> var1);

    protected abstract AggregatorFunctionSupplier doubleSupplier(List<Integer> var1);
}

