/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.util.List;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Percentile;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDouble;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMedian;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Median
extends AggregateFunction
implements SurrogateExpression {
    @FunctionInfo(returnType={"double", "integer", "long"}, description="The value that is greater than half of all values and less than half of all values.", isAggregation=true)
    public Median(Source source, @Param(name="number", type={"double", "integer", "long"}) Expression field) {
        super(source, field);
    }

    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), dt -> dt.isNumeric() && dt != DataTypes.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"numeric except unsigned_long"});
    }

    public DataType dataType() {
        return DataTypes.DOUBLE;
    }

    protected NodeInfo<Median> info() {
        return NodeInfo.create((Node)this, Median::new, (Object)this.field());
    }

    public Median replaceChildren(List<Expression> newChildren) {
        return new Median(this.source(), newChildren.get(0));
    }

    @Override
    public Expression surrogate() {
        Source s = this.source();
        Expression field = this.field();
        return field.foldable() ? new MvMedian(s, (Expression)new ToDouble(s, field)) : new Percentile(this.source(), this.field(), (Expression)new Literal(this.source(), (Object)50, DataTypes.INTEGER));
    }
}

