/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.CountAggregatorFunction;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvCount;
import org.elasticsearch.xpack.esql.expression.function.scalar.nulls.Coalesce;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.esql.planner.ToAggregator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.expression.function.aggregate.EnclosedAgg;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Count
extends AggregateFunction
implements EnclosedAgg,
ToAggregator,
SurrogateExpression {
    @FunctionInfo(returnType={"long"}, description="Returns the total number (count) of input values.", isAggregation=true)
    public Count(Source source, @Param(optional=true, name="field", type={"boolean", "cartesian_point", "date", "double", "geo_point", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Column or literal for which to count the number of values.") Expression field) {
        super(source, field);
    }

    protected NodeInfo<Count> info() {
        return NodeInfo.create((Node)this, Count::new, (Object)this.field());
    }

    public Count replaceChildren(List<Expression> newChildren) {
        return new Count(this.source(), newChildren.get(0));
    }

    public String innerName() {
        return "count";
    }

    public DataType dataType() {
        return DataTypes.LONG;
    }

    @Override
    public AggregatorFunctionSupplier supplier(List<Integer> inputChannels) {
        return CountAggregatorFunction.supplier(inputChannels);
    }

    public Nullability nullable() {
        return Nullability.FALSE;
    }

    protected Expression.TypeResolution resolveType() {
        return EsqlTypeResolutions.isExact(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    public Expression surrogate() {
        Source s = this.source();
        Expression field = this.field();
        if (field.foldable()) {
            Literal l;
            if (field instanceof Literal && (l = (Literal)field).value() != null && !(l.value() instanceof List)) {
                return null;
            }
            return new Mul(s, (Expression)new Coalesce(s, (Expression)new MvCount(s, field), List.of(new Literal(s, (Object)0, DataTypes.INTEGER))), (Expression)new Count(s, (Expression)new Literal(s, (Object)"*", DataTypes.KEYWORD)));
        }
        return null;
    }
}

