/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function;

import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.ql.tree.Source;

public class Warnings {
    static final int MAX_ADDED_WARNINGS = 20;
    private final String location;
    private final String first;
    private int addedWarnings;

    public Warnings(Source source) {
        this.location = LoggerMessageFormat.format((String)"Line {}:{}: ", (Object[])new Object[]{source.source().getLineNumber(), source.source().getColumnNumber()});
        this.first = LoggerMessageFormat.format(null, (String)"{}evaluation of [{}] failed, treating result as null. Only first {} failures recorded.", (Object[])new Object[]{this.location, source.text(), 20});
    }

    public void registerException(Exception exception) {
        if (this.addedWarnings < 20) {
            if (this.addedWarnings == 0) {
                HeaderWarning.addWarning((String)this.first, (Object[])new Object[0]);
            }
            HeaderWarning.addWarning((String)(this.location + exception.getClass().getName() + ": " + exception.getMessage()), (Object[])new Object[0]);
            ++this.addedWarnings;
        }
    }
}

