/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function;

import java.util.Objects;
import org.elasticsearch.xpack.ql.capabilities.Unresolvable;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.NameId;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.EsField;
import org.elasticsearch.xpack.ql.type.UnsupportedEsField;

public final class UnsupportedAttribute
extends FieldAttribute
implements Unresolvable {
    private final String message;
    private final boolean hasCustomMessage;

    private static String errorMessage(String name, UnsupportedEsField field) {
        return "Cannot use field [" + name + "] with unsupported type [" + field.getOriginalType() + "]";
    }

    public UnsupportedAttribute(Source source, String name, UnsupportedEsField field) {
        this(source, name, field, null);
    }

    public UnsupportedAttribute(Source source, String name, UnsupportedEsField field, String customMessage) {
        this(source, name, field, customMessage, null);
    }

    public UnsupportedAttribute(Source source, String name, UnsupportedEsField field, String customMessage, NameId id) {
        super(source, null, name, (EsField)field, null, Nullability.TRUE, id, false);
        this.hasCustomMessage = customMessage != null;
        this.message = customMessage == null ? UnsupportedAttribute.errorMessage(this.qualifiedName(), field) : customMessage;
    }

    public boolean resolved() {
        return false;
    }

    public UnsupportedEsField field() {
        return (UnsupportedEsField)super.field();
    }

    protected NodeInfo<FieldAttribute> info() {
        return NodeInfo.create((Node)this, UnsupportedAttribute::new, (Object)this.name(), (Object)this.field(), (Object)(this.hasCustomMessage ? this.message : null), (Object)this.id());
    }

    protected Attribute clone(Source source, String name, DataType type, String qualifier, Nullability nullability, NameId id, boolean synthetic) {
        return new UnsupportedAttribute(source, name, this.field(), this.hasCustomMessage ? this.message : null, id);
    }

    protected String label() {
        return "!";
    }

    public String toString() {
        return "!" + this.qualifiedName();
    }

    public String nodeString() {
        return this.toString();
    }

    public String unresolvedMessage() {
        return this.message;
    }

    public boolean hasCustomMessage() {
        return this.hasCustomMessage;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.hasCustomMessage, this.message);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            UnsupportedAttribute ua = (UnsupportedAttribute)((Object)obj);
            return Objects.equals(this.hasCustomMessage, ua.hasCustomMessage) && Objects.equals(this.message, ua.message);
        }
        return false;
    }
}

