/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison;

import java.time.ZoneId;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqualDoublesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqualIntsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqualKeywordsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqualLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.predicate.Negatable;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparisonProcessor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class LessThanOrEqual
extends EsqlBinaryComparison
implements Negatable<BinaryComparison> {
    private static final Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap = Map.ofEntries(Map.entry(DataTypes.INTEGER, LessThanOrEqualIntsEvaluator.Factory::new), Map.entry(DataTypes.DOUBLE, LessThanOrEqualDoublesEvaluator.Factory::new), Map.entry(DataTypes.LONG, LessThanOrEqualLongsEvaluator.Factory::new), Map.entry(DataTypes.UNSIGNED_LONG, LessThanOrEqualLongsEvaluator.Factory::new), Map.entry(DataTypes.DATETIME, LessThanOrEqualLongsEvaluator.Factory::new), Map.entry(DataTypes.KEYWORD, LessThanOrEqualKeywordsEvaluator.Factory::new), Map.entry(DataTypes.TEXT, LessThanOrEqualKeywordsEvaluator.Factory::new), Map.entry(DataTypes.VERSION, LessThanOrEqualKeywordsEvaluator.Factory::new), Map.entry(DataTypes.IP, LessThanOrEqualKeywordsEvaluator.Factory::new));

    public LessThanOrEqual(Source source, Expression left, Expression right, ZoneId zoneId) {
        super(source, left, right, BinaryComparisonProcessor.BinaryComparisonOperation.LTE, zoneId, evaluatorMap);
    }

    protected NodeInfo<LessThanOrEqual> info() {
        return NodeInfo.create((Node)this, LessThanOrEqual::new, (Object)this.left(), (Object)this.right(), (Object)this.zoneId());
    }

    protected LessThanOrEqual replaceChildren(Expression newLeft, Expression newRight) {
        return new LessThanOrEqual(this.source(), newLeft, newRight, this.zoneId());
    }

    public GreaterThanOrEqual swapLeftAndRight() {
        return new GreaterThanOrEqual(this.source(), this.right(), this.left(), this.zoneId());
    }

    public GreaterThan negate() {
        return new GreaterThan(this.source(), this.left(), this.right(), this.zoneId());
    }

    public BinaryComparison reverse() {
        return new GreaterThanOrEqual(this.source(), this.left(), this.right(), this.zoneId());
    }

    static boolean processInts(int lhs, int rhs) {
        return lhs <= rhs;
    }

    static boolean processLongs(long lhs, long rhs) {
        return lhs <= rhs;
    }

    static boolean processDoubles(double lhs, double rhs) {
        return lhs <= rhs;
    }

    static boolean processKeywords(BytesRef lhs, BytesRef rhs) {
        return lhs.compareTo(rhs) <= 0;
    }
}

