/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.evaluator.EvalMapper;
import org.elasticsearch.xpack.esql.evaluator.mapper.ExpressionMapper;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.InsensitiveEquals;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.InsensitiveEqualsConstantEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.InsensitiveEqualsEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;
import org.elasticsearch.xpack.esql.planner.Layout;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class InsensitiveEqualsMapper
extends ExpressionMapper<InsensitiveEquals> {
    private final TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> keywords = InsensitiveEqualsEvaluator.Factory::new;

    @Override
    public final EvalOperator.ExpressionEvaluator.Factory map(InsensitiveEquals bc, Layout layout) {
        DataType leftType = bc.left().dataType();
        DataType rightType = bc.right().dataType();
        EvalOperator.ExpressionEvaluator.Factory leftEval = EvalMapper.toEvaluator(bc.left(), layout);
        EvalOperator.ExpressionEvaluator.Factory rightEval = EvalMapper.toEvaluator(bc.right(), layout);
        if (leftType == DataTypes.KEYWORD || leftType == DataTypes.TEXT) {
            if (bc.right().foldable() && EsqlDataTypes.isString(rightType)) {
                BytesRef rightVal = BytesRefs.toBytesRef((Object)bc.right().fold());
                Automaton automaton = InsensitiveEquals.automaton(rightVal);
                return dvrCtx -> new InsensitiveEqualsConstantEvaluator(bc.source(), leftEval.get(dvrCtx), new ByteRunAutomaton(automaton), dvrCtx);
            }
            return (EvalOperator.ExpressionEvaluator.Factory)this.keywords.apply((Object)bc.source(), (Object)leftEval, (Object)rightEval);
        }
        throw new EsqlIllegalArgumentException("resolved type for [" + bc + "] but didn't implement mapping");
    }

    public static EvalOperator.ExpressionEvaluator.Factory castToEvaluator(InsensitiveEquals op, Layout layout, DataType required, TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> factory) {
        EvalOperator.ExpressionEvaluator.Factory lhs = Cast.cast(op.source(), op.left().dataType(), required, EvalMapper.toEvaluator(op.left(), layout));
        EvalOperator.ExpressionEvaluator.Factory rhs = Cast.cast(op.source(), op.right().dataType(), required, EvalMapper.toEvaluator(op.right(), layout));
        return (EvalOperator.ExpressionEvaluator.Factory)factory.apply((Object)op.source(), (Object)lhs, (Object)rhs);
    }
}

