/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.InsensitiveEquals;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.ql.tree.Source;

public final class InsensitiveEqualsConstantEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator lhs;
    private final ByteRunAutomaton rhs;
    private final DriverContext driverContext;

    public InsensitiveEqualsConstantEvaluator(Source source, EvalOperator.ExpressionEvaluator lhs, ByteRunAutomaton rhs, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.lhs = lhs;
        this.rhs = rhs;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock lhsBlock = (BytesRefBlock)this.lhs.eval(page);){
            BytesRefVector lhsVector = lhsBlock.asVector();
            if (lhsVector == null) {
                BooleanBlock booleanBlock = this.eval(page.getPositionCount(), lhsBlock);
                return booleanBlock;
            }
            BooleanBlock booleanBlock = this.eval(page.getPositionCount(), lhsVector).asBlock();
            return booleanBlock;
        }
    }

    public BooleanBlock eval(int positionCount, BytesRefBlock lhsBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            BytesRef lhsScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (lhsBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (lhsBlock.getValueCount(p) != 1) {
                    if (lhsBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendBoolean(InsensitiveEquals.processConstant(lhsBlock.getBytesRef(lhsBlock.getFirstValueIndex(p), lhsScratch), this.rhs));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, BytesRefVector lhsVector) {
        try (BooleanVector.Builder result = this.driverContext.blockFactory().newBooleanVectorBuilder(positionCount);){
            BytesRef lhsScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                result.appendBoolean(InsensitiveEquals.processConstant(lhsVector.getBytesRef(p, lhsScratch), this.rhs));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "InsensitiveEqualsConstantEvaluator[lhs=" + this.lhs + ", rhs=" + this.rhs + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.lhs);
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory lhs;
        private final ByteRunAutomaton rhs;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory lhs, ByteRunAutomaton rhs) {
            this.source = source;
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public InsensitiveEqualsConstantEvaluator get(DriverContext context) {
            return new InsensitiveEqualsConstantEvaluator(this.source, this.lhs.get(context), this.rhs, context);
        }

        public String toString() {
            return "InsensitiveEqualsConstantEvaluator[lhs=" + this.lhs + ", rhs=" + this.rhs + "]";
        }
    }
}

