/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison;

import java.time.ZoneId;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanDoublesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanIntsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanKeywordsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.GreaterThanLongsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.predicate.Negatable;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparisonProcessor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class GreaterThan
extends EsqlBinaryComparison
implements Negatable<BinaryComparison> {
    private static final Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap = Map.ofEntries(Map.entry(DataTypes.INTEGER, GreaterThanIntsEvaluator.Factory::new), Map.entry(DataTypes.DOUBLE, GreaterThanDoublesEvaluator.Factory::new), Map.entry(DataTypes.LONG, GreaterThanLongsEvaluator.Factory::new), Map.entry(DataTypes.UNSIGNED_LONG, GreaterThanLongsEvaluator.Factory::new), Map.entry(DataTypes.DATETIME, GreaterThanLongsEvaluator.Factory::new), Map.entry(DataTypes.KEYWORD, GreaterThanKeywordsEvaluator.Factory::new), Map.entry(DataTypes.TEXT, GreaterThanKeywordsEvaluator.Factory::new), Map.entry(DataTypes.VERSION, GreaterThanKeywordsEvaluator.Factory::new), Map.entry(DataTypes.IP, GreaterThanKeywordsEvaluator.Factory::new));

    public GreaterThan(Source source, Expression left, Expression right) {
        super(source, left, right, BinaryComparisonProcessor.BinaryComparisonOperation.GT, evaluatorMap);
    }

    public GreaterThan(Source source, Expression left, Expression right, ZoneId zoneId) {
        super(source, left, right, BinaryComparisonProcessor.BinaryComparisonOperation.GT, zoneId, evaluatorMap);
    }

    protected NodeInfo<GreaterThan> info() {
        return NodeInfo.create((Node)this, GreaterThan::new, (Object)this.left(), (Object)this.right(), (Object)this.zoneId());
    }

    protected GreaterThan replaceChildren(Expression newLeft, Expression newRight) {
        return new GreaterThan(this.source(), newLeft, newRight, this.zoneId());
    }

    public LessThan swapLeftAndRight() {
        return new LessThan(this.source(), this.right(), this.left(), this.zoneId());
    }

    public LessThanOrEqual negate() {
        return new LessThanOrEqual(this.source(), this.left(), this.right(), this.zoneId());
    }

    public BinaryComparison reverse() {
        return new LessThan(this.source(), this.left(), this.right(), this.zoneId());
    }

    static boolean processInts(int lhs, int rhs) {
        return lhs > rhs;
    }

    static boolean processLongs(long lhs, long rhs) {
        return lhs > rhs;
    }

    static boolean processDoubles(double lhs, double rhs) {
        return lhs > rhs;
    }

    static boolean processKeywords(BytesRef lhs, BytesRef rhs) {
        return lhs.compareTo(rhs) > 0;
    }
}

