/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.UnsupportedValueSource;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.esql.action.ColumnInfo;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public final class ResponseValueUtils {
    public static Iterator<Iterator<Object>> pagesToValues(List<String> dataTypes, List<Page> pages) {
        BytesRef scratch = new BytesRef();
        return Iterators.flatMap(pages.iterator(), page -> Iterators.forRange((int)0, (int)page.getPositionCount(), pos -> Iterators.forRange((int)0, (int)page.getBlockCount(), b -> ResponseValueUtils.valueAtPosition(page.getBlock(b), pos, (String)dataTypes.get(b), scratch))));
    }

    static Iterable<Iterable<Object>> valuesForRowsInPages(List<String> dataTypes, List<Page> pages) {
        BytesRef scratch = new BytesRef();
        return () -> Iterators.flatMap(pages.iterator(), page -> ResponseValueUtils.valuesForRowsInPage(dataTypes, page, scratch));
    }

    static Iterator<Iterable<Object>> valuesForRowsInPage(List<String> dataTypes, Page page, BytesRef scratch) {
        return Iterators.forRange((int)0, (int)page.getPositionCount(), position -> ResponseValueUtils.valuesForRow(dataTypes, page, position, scratch));
    }

    static Iterable<Object> valuesForRow(List<String> dataTypes, Page page, int position, BytesRef scratch) {
        return () -> Iterators.forRange((int)0, (int)page.getBlockCount(), blockIdx -> ResponseValueUtils.valueAtPosition(page.getBlock(blockIdx), position, (String)dataTypes.get(blockIdx), scratch));
    }

    static Iterator<Object> valuesForColumn(int columnIndex, String dataType, List<Page> pages) {
        BytesRef scratch = new BytesRef();
        return Iterators.flatMap(pages.iterator(), page -> Iterators.forRange((int)0, (int)page.getPositionCount(), pos -> ResponseValueUtils.valueAtPosition(page.getBlock(columnIndex), pos, dataType, scratch)));
    }

    static Object valueAtPosition(Block block, int position, String dataType, BytesRef scratch) {
        if (block.isNull(position)) {
            return null;
        }
        int count = block.getValueCount(position);
        int start = block.getFirstValueIndex(position);
        if (count == 1) {
            return ResponseValueUtils.valueAt(dataType, block, start, scratch);
        }
        ArrayList<Object> values = new ArrayList<Object>(count);
        int end = count + start;
        for (int i = start; i < end; ++i) {
            values.add(ResponseValueUtils.valueAt(dataType, block, i, scratch));
        }
        return values;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object valueAt(String dataType, Block block, int offset, BytesRef scratch) {
        switch (dataType) {
            case "unsigned_long": {
                Number number = NumericUtils.unsignedLongAsNumber((long)((LongBlock)block).getLong(offset));
                Object object = number;
                return object;
            }
            case "long": {
                Long l = ((LongBlock)block).getLong(offset);
                Object object = l;
                return object;
            }
            case "integer": {
                Integer n = ((IntBlock)block).getInt(offset);
                Object object = n;
                return object;
            }
            case "double": {
                Double d = ((DoubleBlock)block).getDouble(offset);
                Object object = d;
                return object;
            }
            case "keyword": 
            case "text": {
                String string = ((BytesRefBlock)block).getBytesRef(offset, scratch).utf8ToString();
                Object object = string;
                return object;
            }
            case "ip": {
                BytesRef val = ((BytesRefBlock)block).getBytesRef(offset, scratch);
                String string = EsqlDataTypeConverter.ipToString(val);
                Object object = string;
                return object;
            }
            case "date": {
                long longVal = ((LongBlock)block).getLong(offset);
                String string = EsqlDataTypeConverter.dateTimeToString(longVal);
                Object object = string;
                return object;
            }
            case "boolean": {
                Boolean bl = ((BooleanBlock)block).getBoolean(offset);
                Object object = bl;
                return object;
            }
            case "version": {
                String string = EsqlDataTypeConverter.versionToString(((BytesRefBlock)block).getBytesRef(offset, scratch));
                Object object = string;
                return object;
            }
            case "geo_point": 
            case "geo_shape": 
            case "cartesian_point": 
            case "cartesian_shape": {
                String string = EsqlDataTypeConverter.spatialToString(((BytesRefBlock)block).getBytesRef(offset, scratch));
                Object object = string;
                return object;
            }
            case "unsupported": {
                String string = UnsupportedValueSource.UNSUPPORTED_OUTPUT;
                Object object = string;
                return object;
            }
            case "_source": {
                Object object;
                BytesRef val = ((BytesRefBlock)block).getBytesRef(offset, scratch);
                try (XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)new BytesArray(val));){
                    parser.nextToken();
                    Map map = parser.mapOrdered();
                    object = map;
                    return object;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        throw EsqlIllegalArgumentException.illegalDataType(dataType);
    }

    static Page valuesToPage(BlockFactory blockFactory, List<ColumnInfo> columns, List<List<Object>> values) {
        List<String> dataTypes = columns.stream().map(ColumnInfo::type).toList();
        List<Block.Builder> results = dataTypes.stream().map(c -> PlannerUtils.toElementType(EsqlDataTypes.fromName(c)).newBlockBuilder(values.size(), blockFactory)).toList();
        for (List<Object> row : values) {
            block41: for (int c2 = 0; c2 < row.size(); ++c2) {
                Block.Builder builder = results.get(c2);
                Object value = row.get(c2);
                switch (dataTypes.get(c2)) {
                    case "unsigned_long": {
                        ((LongBlock.Builder)builder).appendLong(EsqlDataTypeConverter.longToUnsignedLong(((Number)value).longValue(), true));
                        continue block41;
                    }
                    case "long": {
                        ((LongBlock.Builder)builder).appendLong(((Number)value).longValue());
                        continue block41;
                    }
                    case "integer": {
                        ((IntBlock.Builder)builder).appendInt(((Number)value).intValue());
                        continue block41;
                    }
                    case "double": {
                        ((DoubleBlock.Builder)builder).appendDouble(((Number)value).doubleValue());
                        continue block41;
                    }
                    case "keyword": 
                    case "text": 
                    case "unsupported": {
                        ((BytesRefBlock.Builder)builder).appendBytesRef(new BytesRef((CharSequence)value.toString()));
                        continue block41;
                    }
                    case "ip": {
                        ((BytesRefBlock.Builder)builder).appendBytesRef(EsqlDataTypeConverter.stringToIP(value.toString()));
                        continue block41;
                    }
                    case "date": {
                        long longVal = EsqlDataTypeConverter.dateTimeToLong(value.toString());
                        ((LongBlock.Builder)builder).appendLong(longVal);
                        continue block41;
                    }
                    case "boolean": {
                        ((BooleanBlock.Builder)builder).appendBoolean(((Boolean)value).booleanValue());
                        continue block41;
                    }
                    case "null": {
                        builder.appendNull();
                        continue block41;
                    }
                    case "version": {
                        ((BytesRefBlock.Builder)builder).appendBytesRef(EsqlDataTypeConverter.stringToVersion(new BytesRef((CharSequence)value.toString())));
                        continue block41;
                    }
                    case "_source": {
                        Map o = (Map)value;
                        try (XContentBuilder sourceBuilder = JsonXContent.contentBuilder();){
                            sourceBuilder.map(o);
                            ((BytesRefBlock.Builder)builder).appendBytesRef(BytesReference.bytes((XContentBuilder)sourceBuilder).toBytesRef());
                            continue block41;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    case "geo_point": 
                    case "geo_shape": 
                    case "cartesian_point": 
                    case "cartesian_shape": {
                        BytesRef wkb = EsqlDataTypeConverter.stringToSpatial(value.toString());
                        ((BytesRefBlock.Builder)builder).appendBytesRef(wkb);
                        continue block41;
                    }
                    default: {
                        throw EsqlIllegalArgumentException.illegalDataType(dataTypes.get(c2));
                    }
                }
            }
        }
        return new Page((Block[])results.stream().map(Block.Builder::build).toArray(Block[]::new));
    }
}

