/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.lucene.UnsupportedValueSource;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.esql.action.ColumnInfo;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.ql.util.NumericUtils;

abstract class PositionToXContent {
    protected final Block block;

    PositionToXContent(Block block) {
        this.block = block;
    }

    public XContentBuilder positionToXContent(XContentBuilder builder, ToXContent.Params params, int position) throws IOException {
        if (this.block.isNull(position)) {
            return builder.nullValue();
        }
        int count = this.block.getValueCount(position);
        int start = this.block.getFirstValueIndex(position);
        if (count == 1) {
            return this.valueToXContent(builder, params, start);
        }
        builder.startArray();
        int end = start + count;
        for (int i = start; i < end; ++i) {
            this.valueToXContent(builder, params, i);
        }
        return builder.endArray();
    }

    protected abstract XContentBuilder valueToXContent(XContentBuilder var1, ToXContent.Params var2, int var3) throws IOException;

    public static PositionToXContent positionToXContent(ColumnInfo columnInfo, Block block, final BytesRef scratch) {
        return switch (columnInfo.type()) {
            case "long" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.value(((LongBlock)this.block).getLong(valueIndex));
                }
            };
            case "integer" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.value(((IntBlock)this.block).getInt(valueIndex));
                }
            };
            case "double" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.value(((DoubleBlock)this.block).getDouble(valueIndex));
                }
            };
            case "unsigned_long" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    long l = ((LongBlock)this.block).getLong(valueIndex);
                    return builder.value((Object)NumericUtils.unsignedLongAsNumber((long)l));
                }
            };
            case "keyword", "text" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    BytesRef val = ((BytesRefBlock)this.block).getBytesRef(valueIndex, scratch);
                    if (builder.contentType() == XContentType.CBOR && val.offset != 0) {
                        val = BytesRef.deepCopyOf((BytesRef)scratch);
                    }
                    return builder.utf8Value(val.bytes, val.offset, val.length);
                }
            };
            case "ip" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    BytesRef val = ((BytesRefBlock)this.block).getBytesRef(valueIndex, scratch);
                    return builder.value(EsqlDataTypeConverter.ipToString(val));
                }
            };
            case "date" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    long longVal = ((LongBlock)this.block).getLong(valueIndex);
                    return builder.value(EsqlDataTypeConverter.dateTimeToString(longVal));
                }
            };
            case "geo_point", "geo_shape", "cartesian_point", "cartesian_shape" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.value(EsqlDataTypeConverter.spatialToString(((BytesRefBlock)this.block).getBytesRef(valueIndex, scratch)));
                }
            };
            case "boolean" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.value(((BooleanBlock)this.block).getBoolean(valueIndex));
                }
            };
            case "version" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    BytesRef val = ((BytesRefBlock)this.block).getBytesRef(valueIndex, scratch);
                    return builder.value(EsqlDataTypeConverter.versionToString(val));
                }
            };
            case "null" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.nullValue();
                }
            };
            case "unsupported" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    return builder.value(UnsupportedValueSource.UNSUPPORTED_OUTPUT);
                }
            };
            case "_source" -> new PositionToXContent(block){

                @Override
                protected XContentBuilder valueToXContent(XContentBuilder builder, ToXContent.Params params, int valueIndex) throws IOException {
                    BytesRef val = ((BytesRefBlock)this.block).getBytesRef(valueIndex, scratch);
                    try (XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)new BytesArray(val));){
                        parser.nextToken();
                        XContentBuilder xContentBuilder = builder.copyCurrentStructure(parser);
                        return xContentBuilder;
                    }
                }
            };
            default -> throw new IllegalArgumentException("can't convert values of type [" + columnInfo.type() + "]");
        };
    }
}

