/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.rest.ChunkedRestResponseBody;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;
import org.elasticsearch.xcontent.MediaType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.action.EsqlQueryResponse;
import org.elasticsearch.xpack.esql.formatter.TextFormat;
import org.elasticsearch.xpack.esql.plugin.EsqlMediaTypeParser;
import org.elasticsearch.xpack.ql.util.LoggingUtils;

public final class EsqlResponseListener
extends RestRefCountedChunkedToXContentListener<EsqlQueryResponse> {
    private static final Logger LOGGER = LogManager.getLogger(EsqlResponseListener.class);
    private static final String HEADER_NAME_TOOK_NANOS = "Took-nanos";
    private final RestChannel channel;
    private final RestRequest restRequest;
    private final MediaType mediaType;
    private final String esqlQuery;
    private final ThreadSafeStopWatch stopWatch = new ThreadSafeStopWatch();

    public EsqlResponseListener(RestChannel channel, RestRequest restRequest, EsqlQueryRequest esqlRequest) {
        super(channel);
        this.channel = channel;
        this.restRequest = restRequest;
        this.esqlQuery = esqlRequest.query();
        this.mediaType = EsqlMediaTypeParser.getResponseMediaType(restRequest, esqlRequest);
        if (this.mediaType != TextFormat.CSV && restRequest.hasParam("delimiter")) {
            String message = String.format(Locale.ROOT, "parameter: [%s] can only be used with the format [%s] for request [%s]", "delimiter", TextFormat.CSV.queryParameter(), restRequest.path());
            throw new IllegalArgumentException(message);
        }
    }

    protected void processResponse(EsqlQueryResponse esqlQueryResponse) throws IOException {
        this.channel.sendResponse(this.buildResponse(esqlQueryResponse));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestResponse buildResponse(EsqlQueryResponse esqlResponse) throws IOException {
        boolean success = false;
        Releasable releasable = this.releasableFromResponse((ChunkedToXContent)esqlResponse);
        try {
            RestResponse restResponse;
            MediaType mediaType = this.mediaType;
            if (mediaType instanceof TextFormat) {
                TextFormat format = (TextFormat)mediaType;
                restResponse = RestResponse.chunked((RestStatus)RestStatus.OK, (ChunkedRestResponseBody)ChunkedRestResponseBody.fromTextChunks((String)format.contentType(this.restRequest), format.format(this.restRequest, esqlResponse)), (Releasable)releasable);
            } else {
                restResponse = RestResponse.chunked((RestStatus)RestStatus.OK, (ChunkedRestResponseBody)ChunkedRestResponseBody.fromXContent((ChunkedToXContent)esqlResponse, (ToXContent.Params)this.channel.request(), (RestChannel)this.channel), (Releasable)releasable);
            }
            long tookNanos = this.stopWatch.stop().getNanos();
            restResponse.addHeader(HEADER_NAME_TOOK_NANOS, Long.toString(tookNanos));
            success = true;
            RestResponse restResponse2 = restResponse;
            return restResponse2;
        }
        finally {
            if (!success) {
                releasable.close();
            }
        }
    }

    public ActionListener<EsqlQueryResponse> wrapWithLogging() {
        ActionListener listener = ActionListener.wrap(arg_0 -> ((EsqlResponseListener)this).onResponse(arg_0), ex -> {
            LoggingUtils.logOnFailure((Logger)LOGGER, (Throwable)ex);
            this.onFailure((Exception)ex);
        });
        if (!LOGGER.isDebugEnabled()) {
            return listener;
        }
        return ActionListener.wrap(r -> {
            listener.onResponse((Object)r);
            LOGGER.debug("Finished execution of ESQL query.\nQuery string: [{}]\nExecution time: [{}]ms", new Object[]{this.esqlQuery, this.stopWatch.stop().getMillis()});
        }, ex -> {
            long timeMillis = this.stopWatch.stop().getMillis();
            LOGGER.debug("Failed execution of ESQL query.\nQuery string: [{}]\nExecution time: [{}]ms", new Object[]{this.esqlQuery, timeMillis});
            listener.onFailure(ex);
        });
    }

    private static class ThreadSafeStopWatch {
        private final long startTimeNS = System.nanoTime();
        private long endTimeNS;
        private boolean running = true;

        ThreadSafeStopWatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TimeValue stop() {
            ThreadSafeStopWatch threadSafeStopWatch = this;
            synchronized (threadSafeStopWatch) {
                if (this.running) {
                    this.endTimeNS = System.nanoTime();
                    this.running = false;
                }
                return new TimeValue(this.endTimeNS - this.startTimeNS, TimeUnit.NANOSECONDS);
            }
        }
    }
}

