/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.core.esql.action.internal.SharedSecrets;
import org.elasticsearch.xpack.esql.action.EsqlQueryAction;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.action.EsqlQueryResponse;
import org.elasticsearch.xpack.esql.plugin.QueryPragmas;

public class EsqlQueryRequestBuilder
extends org.elasticsearch.xpack.core.esql.action.EsqlQueryRequestBuilder<EsqlQueryRequest, EsqlQueryResponse> {
    public static EsqlQueryRequestBuilder newAsyncEsqlQueryRequestBuilder(ElasticsearchClient client) {
        return new EsqlQueryRequestBuilder(client, EsqlQueryRequest.asyncEsqlQueryRequest());
    }

    public static EsqlQueryRequestBuilder newSyncEsqlQueryRequestBuilder(ElasticsearchClient client) {
        return new EsqlQueryRequestBuilder(client, EsqlQueryRequest.syncEsqlQueryRequest());
    }

    private EsqlQueryRequestBuilder(ElasticsearchClient client, EsqlQueryRequest request) {
        super(client, (ActionType)EsqlQueryAction.INSTANCE, (org.elasticsearch.xpack.core.esql.action.EsqlQueryRequest)request);
    }

    public EsqlQueryRequestBuilder query(String query) {
        ((EsqlQueryRequest)this.request).query(query);
        return this;
    }

    public EsqlQueryRequestBuilder columnar(boolean columnar) {
        ((EsqlQueryRequest)this.request).columnar(columnar);
        return this;
    }

    public EsqlQueryRequestBuilder filter(QueryBuilder filter) {
        ((EsqlQueryRequest)this.request).filter(filter);
        return this;
    }

    public EsqlQueryRequestBuilder pragmas(QueryPragmas pragmas) {
        ((EsqlQueryRequest)this.request).pragmas(pragmas);
        return this;
    }

    public EsqlQueryRequestBuilder waitForCompletionTimeout(TimeValue waitForCompletionTimeout) {
        ((EsqlQueryRequest)this.request).waitForCompletionTimeout(waitForCompletionTimeout);
        return this;
    }

    public EsqlQueryRequestBuilder keepAlive(TimeValue keepAlive) {
        ((EsqlQueryRequest)this.request).keepAlive(keepAlive);
        return this;
    }

    public EsqlQueryRequestBuilder keepOnCompletion(boolean keepOnCompletion) {
        ((EsqlQueryRequest)this.request).keepOnCompletion(keepOnCompletion);
        return this;
    }

    static {
        SharedSecrets.setEsqlQueryRequestBuilderAccess(EsqlQueryRequestBuilder::newSyncEsqlQueryRequestBuilder);
    }
}

