/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.extras;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SourceValueFetcherSortedDoubleIndexFieldData;
import org.elasticsearch.index.fielddata.plain.LeafDoubleFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.BlockDocValuesReader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SortedNumericDocValuesSyntheticFieldLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.ScaledFloatDocValuesField;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.TimeSeriesValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ScaledFloatFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "scaled_float";
    private static final Setting<Boolean> COERCE_SETTING = NumberFieldMapper.COERCE_SETTING;
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.getSettings(), c.getIndexSettings().getMode()));
    private final Explicit<Boolean> ignoreMalformed;
    private final Explicit<Boolean> coerce;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final Double nullValue;
    private final double scalingFactor;
    private final boolean ignoreMalformedByDefault;
    private final boolean coerceByDefault;
    private final TimeSeriesParams.MetricType metricType;
    private final IndexMode indexMode;

    private static ScaledFloatFieldMapper toType(FieldMapper in) {
        return (ScaledFloatFieldMapper)in;
    }

    private ScaledFloatFieldMapper(String simpleName, ScaledFloatFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, (MappedFieldType)mappedFieldType, multiFields, copyTo);
        this.indexed = (Boolean)builder.indexed.getValue();
        this.hasDocValues = (Boolean)builder.hasDocValues.getValue();
        this.stored = (Boolean)builder.stored.getValue();
        this.scalingFactor = (Double)builder.scalingFactor.getValue();
        this.nullValue = (Double)builder.nullValue.getValue();
        this.ignoreMalformed = (Explicit)builder.ignoreMalformed.getValue();
        this.coerce = (Explicit)builder.coerce.getValue();
        this.ignoreMalformedByDefault = (Boolean)((Explicit)builder.ignoreMalformed.getDefaultValue()).value();
        this.coerceByDefault = (Boolean)((Explicit)builder.coerce.getDefaultValue()).value();
        this.metricType = (TimeSeriesParams.MetricType)builder.metric.getValue();
        this.indexMode = builder.indexMode;
    }

    boolean coerce() {
        return (Boolean)this.coerce.value();
    }

    public boolean ignoreMalformed() {
        return (Boolean)this.ignoreMalformed.value();
    }

    public ScaledFloatFieldType fieldType() {
        return (ScaledFloatFieldType)super.fieldType();
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.ignoreMalformedByDefault, this.coerceByDefault, this.indexMode).metric(this.metricType).init(this);
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        double doubleValue;
        Number value;
        XContentParser parser = context.parser();
        Number numericValue = null;
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            value = null;
        } else if (((Boolean)this.coerce.value()).booleanValue() && parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
            value = null;
        } else {
            try {
                numericValue = parser.doubleValue(((Boolean)this.coerce.value()).booleanValue());
            }
            catch (IllegalArgumentException e) {
                if (((Boolean)this.ignoreMalformed.value()).booleanValue()) {
                    context.addIgnoredField(this.mappedFieldType.name());
                    return;
                }
                throw e;
            }
            value = numericValue;
        }
        if (value == null) {
            value = this.nullValue;
        }
        if (value == null) {
            return;
        }
        if (numericValue == null) {
            numericValue = NumberFieldMapper.NumberType.objectToDouble((Object)value);
        }
        if (!Double.isFinite(doubleValue = numericValue.doubleValue())) {
            if (((Boolean)this.ignoreMalformed.value()).booleanValue()) {
                context.addIgnoredField(this.mappedFieldType.name());
                return;
            }
            throw new IllegalArgumentException("[scaled_float] only supports finite values, but got [" + doubleValue + "]");
        }
        long scaledValue = ScaledFloatFieldMapper.encode(doubleValue, this.scalingFactor);
        NumberFieldMapper.NumberType.LONG.addFields(context.doc(), this.fieldType().name(), (Number)scaledValue, this.indexed, this.hasDocValues, this.stored);
        if (!this.hasDocValues && (this.indexed || this.stored)) {
            context.addToFieldNames(this.fieldType().name());
        }
    }

    static long encode(double value, double scalingFactor) {
        return Math.round(value * scalingFactor);
    }

    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        if (!this.hasDocValues) {
            throw new IllegalArgumentException("field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support synthetic source because it doesn't have doc values");
        }
        if (((Boolean)this.ignoreMalformed.value()).booleanValue()) {
            throw new IllegalArgumentException("field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support synthetic source because it ignores malformed numbers");
        }
        if (!this.copyTo.copyToFields().isEmpty()) {
            throw new IllegalArgumentException("field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support synthetic source because it declares copy_to");
        }
        return new SortedNumericDocValuesSyntheticFieldLoader(this.name(), this.simpleName(), (Boolean)this.ignoreMalformed.value()){

            protected void writeValue(XContentBuilder b, long value) throws IOException {
                b.value(ScaledFloatFieldMapper.decodeForSyntheticSource(value, ScaledFloatFieldMapper.this.scalingFactor));
            }
        };
    }

    static double decodeForSyntheticSource(long scaledValue, double scalingFactor) {
        double v = (double)scaledValue / scalingFactor;
        if (Double.isInfinite(v)) {
            int sign = v == Double.POSITIVE_INFINITY ? 1 : -1;
            return (double)sign * Double.MAX_VALUE;
        }
        long reenc = Math.round(v * scalingFactor);
        if (reenc != scaledValue) {
            v = reenc > scaledValue ? (v -= Math.ulp(v)) : (v += Math.ulp(v));
            assert (Math.round(v * scalingFactor) == scaledValue) : Math.round(v * scalingFactor) + " != " + scaledValue;
        }
        return v;
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> indexed;
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> ScaledFloatFieldMapper.toType((FieldMapper)m).hasDocValues, (boolean)true);
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> ScaledFloatFieldMapper.toType((FieldMapper)m).stored, (boolean)false);
        private final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        private final FieldMapper.Parameter<Explicit<Boolean>> coerce;
        private final FieldMapper.Parameter<Double> scalingFactor = new FieldMapper.Parameter("scaling_factor", false, () -> null, (n, c, o) -> XContentMapValues.nodeDoubleValue((Object)o), m -> ScaledFloatFieldMapper.toType((FieldMapper)m).scalingFactor, XContentBuilder::field, Objects::toString).addValidator(v -> {
            if (v == null) {
                throw new IllegalArgumentException("Field [scaling_factor] is required");
            }
            if (!Double.isFinite(v) || v <= 0.0) {
                throw new IllegalArgumentException("[scaling_factor] must be a positive number, got [" + v + "]");
            }
        });
        private final FieldMapper.Parameter<Double> nullValue = new FieldMapper.Parameter("null_value", false, () -> null, (n, c, o) -> o == null ? null : Double.valueOf(XContentMapValues.nodeDoubleValue((Object)o)), m -> ScaledFloatFieldMapper.toType((FieldMapper)m).nullValue, XContentBuilder::field, Objects::toString).acceptsNull();
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<TimeSeriesParams.MetricType> metric;
        private final IndexMode indexMode;

        public Builder(String name, Settings settings, IndexMode indexMode) {
            this(name, (Boolean)FieldMapper.IGNORE_MALFORMED_SETTING.get(settings), (Boolean)COERCE_SETTING.get(settings), indexMode);
        }

        public Builder(String name, boolean ignoreMalformedByDefault, boolean coerceByDefault, IndexMode indexMode) {
            super(name);
            this.ignoreMalformed = FieldMapper.Parameter.explicitBoolParam((String)"ignore_malformed", (boolean)true, m -> ScaledFloatFieldMapper.toType((FieldMapper)m).ignoreMalformed, (boolean)ignoreMalformedByDefault);
            this.coerce = FieldMapper.Parameter.explicitBoolParam((String)"coerce", (boolean)true, m -> ScaledFloatFieldMapper.toType((FieldMapper)m).coerce, (boolean)coerceByDefault);
            this.indexMode = indexMode;
            this.indexed = FieldMapper.Parameter.indexParam(m -> ScaledFloatFieldMapper.toType((FieldMapper)m).indexed, () -> {
                if (indexMode == IndexMode.TIME_SERIES) {
                    TimeSeriesParams.MetricType metricType = (TimeSeriesParams.MetricType)this.getMetric().getValue();
                    return metricType != TimeSeriesParams.MetricType.COUNTER && metricType != TimeSeriesParams.MetricType.GAUGE;
                }
                return true;
            });
            this.metric = TimeSeriesParams.metricParam(m -> ScaledFloatFieldMapper.toType((FieldMapper)m).metricType, (TimeSeriesParams.MetricType[])new TimeSeriesParams.MetricType[]{TimeSeriesParams.MetricType.GAUGE, TimeSeriesParams.MetricType.COUNTER}).addValidator(v -> {
                if (v != null && !((Boolean)this.hasDocValues.getValue()).booleanValue()) {
                    throw new IllegalArgumentException("Field [time_series_metric] requires that [" + this.hasDocValues.name + "] is true");
                }
            });
        }

        Builder scalingFactor(double scalingFactor) {
            this.scalingFactor.setValue((Object)scalingFactor);
            return this;
        }

        Builder nullValue(double nullValue) {
            this.nullValue.setValue((Object)nullValue);
            return this;
        }

        public Builder metric(TimeSeriesParams.MetricType metric) {
            this.metric.setValue((Object)metric);
            return this;
        }

        private FieldMapper.Parameter<TimeSeriesParams.MetricType> getMetric() {
            return this.metric;
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.meta, this.scalingFactor, this.coerce, this.nullValue, this.metric};
        }

        public ScaledFloatFieldMapper build(MapperBuilderContext context) {
            ScaledFloatFieldType type = new ScaledFloatFieldType(context.buildFullName(this.name()), (Boolean)this.indexed.getValue(), (Boolean)this.stored.getValue(), (Boolean)this.hasDocValues.getValue(), (Map)this.meta.getValue(), (Double)this.scalingFactor.getValue(), (Double)this.nullValue.getValue(), (TimeSeriesParams.MetricType)this.metric.getValue(), this.indexMode);
            return new ScaledFloatFieldMapper(this.name(), type, this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo, this);
        }
    }

    public static final class ScaledFloatFieldType
    extends SimpleMappedFieldType {
        private final double scalingFactor;
        private final Double nullValue;
        private final TimeSeriesParams.MetricType metricType;
        private final IndexMode indexMode;

        public ScaledFloatFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, Map<String, String> meta, double scalingFactor, Double nullValue, TimeSeriesParams.MetricType metricType, IndexMode indexMode) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
            this.scalingFactor = scalingFactor;
            this.nullValue = nullValue;
            this.metricType = metricType;
            this.indexMode = indexMode;
        }

        public ScaledFloatFieldType(String name, double scalingFactor) {
            this(name, scalingFactor, true);
        }

        public ScaledFloatFieldType(String name, double scalingFactor, boolean indexed) {
            this(name, indexed, false, true, Collections.emptyMap(), scalingFactor, null, null, null);
        }

        public double getScalingFactor() {
            return this.scalingFactor;
        }

        public String typeName() {
            return ScaledFloatFieldMapper.CONTENT_TYPE;
        }

        public boolean mayExistInIndex(SearchExecutionContext context) {
            return context.fieldExistsInIndex(this.name());
        }

        public boolean isSearchable() {
            return this.isIndexed() || this.hasDocValues();
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            long scaledValue = Math.round(this.scale(value));
            return NumberFieldMapper.NumberType.LONG.termQuery(this.name(), (Object)scaledValue, this.isIndexed());
        }

        public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.isIndexed()) {
                ArrayList<Long> scaledValues = new ArrayList<Long>(values.size());
                for (Object value : values) {
                    long scaledValue = Math.round(this.scale(value));
                    scaledValues.add(scaledValue);
                }
                return NumberFieldMapper.NumberType.LONG.termsQuery(this.name(), Collections.unmodifiableList(scaledValues));
            }
            return super.termsQuery(values, context);
        }

        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            Long lo = null;
            if (lowerTerm != null) {
                double dValue = this.scale(lowerTerm);
                if (!includeLower) {
                    dValue = Math.nextUp(dValue);
                }
                lo = Math.round(Math.ceil(dValue));
            }
            Long hi = null;
            if (upperTerm != null) {
                double dValue = this.scale(upperTerm);
                if (!includeUpper) {
                    dValue = Math.nextDown(dValue);
                }
                hi = Math.round(Math.floor(dValue));
            }
            return NumberFieldMapper.NumberType.LONG.rangeQuery(this.name(), (Object)lo, (Object)hi, true, true, this.hasDocValues(), context, this.isIndexed());
        }

        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.indexMode == IndexMode.TIME_SERIES && this.metricType == TimeSeriesParams.MetricType.COUNTER) {
                return BlockLoader.CONSTANT_NULLS;
            }
            if (this.hasDocValues()) {
                double scalingFactorInverse = 1.0 / this.scalingFactor;
                return new BlockDocValuesReader.DoublesBlockLoader(this.name(), l -> (double)l * scalingFactorInverse);
            }
            SourceValueFetcher valueFetcher = this.sourceValueFetcher(blContext.sourcePaths(this.name()));
            BlockSourceReader.LeafIteratorLookup lookup = this.isStored() || this.isIndexed() ? BlockSourceReader.lookupFromFieldNames((FieldNamesFieldMapper.FieldNamesFieldType)blContext.fieldNames(), (String)this.name()) : BlockSourceReader.lookupMatchingAll();
            return new BlockSourceReader.DoublesBlockLoader((ValueFetcher)valueFetcher, lookup);
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            ValuesSourceType valuesSourceType;
            MappedFieldType.FielddataOperation operation = fieldDataContext.fielddataOperation();
            if (operation == MappedFieldType.FielddataOperation.SEARCH) {
                this.failIfNoDocValues();
            }
            Object object = valuesSourceType = this.indexMode == IndexMode.TIME_SERIES && this.metricType == TimeSeriesParams.MetricType.COUNTER ? TimeSeriesValuesSourceType.COUNTER : IndexNumericFieldData.NumericType.LONG.getValuesSourceType();
            if ((operation == MappedFieldType.FielddataOperation.SEARCH || operation == MappedFieldType.FielddataOperation.SCRIPT) && this.hasDocValues()) {
                return (cache, breakerService) -> {
                    SortedNumericIndexFieldData scaledValues = new SortedNumericIndexFieldData.Builder(this.name(), IndexNumericFieldData.NumericType.LONG, valuesSourceType, (dv, n) -> {
                        throw new UnsupportedOperationException();
                    }, this.isIndexed()).build(cache, breakerService);
                    return new ScaledFloatIndexFieldData((IndexNumericFieldData)scaledValues, this.scalingFactor, (ToScriptFieldFactory<SortedNumericDoubleValues>)((ToScriptFieldFactory)ScaledFloatDocValuesField::new));
                };
            }
            if (operation == MappedFieldType.FielddataOperation.SCRIPT) {
                SearchLookup searchLookup = (SearchLookup)fieldDataContext.lookupSupplier().get();
                Set sourcePaths = (Set)fieldDataContext.sourcePathsLookup().apply(this.name());
                return new SourceValueFetcherSortedDoubleIndexFieldData.Builder(this.name(), valuesSourceType, (ValueFetcher)this.sourceValueFetcher(sourcePaths), (SourceProvider)searchLookup, ScaledFloatDocValuesField::new);
            }
            throw new IllegalStateException("unknown field data type [" + operation.name() + "]");
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return this.sourceValueFetcher(context.isSourceEnabled() ? context.sourcePath(this.name()) : Collections.emptySet());
        }

        private SourceValueFetcher sourceValueFetcher(Set<String> sourcePaths) {
            return new SourceValueFetcher(sourcePaths, this.nullValue){

                protected Double parseSourceValue(Object value) {
                    double doubleValue;
                    if (value.equals("")) {
                        if (nullValue == null) {
                            return null;
                        }
                        doubleValue = nullValue;
                    } else {
                        doubleValue = NumberFieldMapper.NumberType.objectToDouble((Object)value);
                    }
                    double factor = this.getScalingFactor();
                    return (double)Math.round(doubleValue * factor) / factor;
                }
            };
        }

        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return (double)((Number)value).longValue() / this.scalingFactor;
        }

        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            this.checkNoTimeZone(timeZone);
            if (format == null) {
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }

        private double scale(Object input) {
            return new BigDecimal(Double.toString(NumberFieldMapper.NumberType.objectToDouble((Object)input))).multiply(BigDecimal.valueOf(this.scalingFactor)).doubleValue();
        }

        public TimeSeriesParams.MetricType getMetricType() {
            return this.metricType;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("ScaledFloatFieldType[").append(this.scalingFactor);
            if (this.nullValue != null) {
                b.append(", nullValue=").append(this.nullValue);
            }
            if (this.metricType != null) {
                b.append(", metricType=").append(this.metricType);
            }
            return b.append("]").toString();
        }
    }

    private static class ScaledFloatLeafFieldData
    extends LeafDoubleFieldData {
        private final LeafNumericFieldData scaledFieldData;
        private final double scalingFactorInverse;
        private final ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory;

        ScaledFloatLeafFieldData(LeafNumericFieldData scaledFieldData, double scalingFactor, ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory) {
            this.scaledFieldData = scaledFieldData;
            this.scalingFactorInverse = 1.0 / scalingFactor;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
            return this.toScriptFieldFactory.getScriptFieldFactory((Object)this.getDoubleValues(), name);
        }

        public long ramBytesUsed() {
            return this.scaledFieldData.ramBytesUsed();
        }

        public void close() {
            this.scaledFieldData.close();
        }

        public SortedNumericDoubleValues getDoubleValues() {
            final SortedNumericDocValues values = this.scaledFieldData.getLongValues();
            final NumericDocValues singleValues = DocValues.unwrapSingleton((SortedNumericDocValues)values);
            if (singleValues != null) {
                return FieldData.singleton((NumericDoubleValues)new NumericDoubleValues(){

                    public boolean advanceExact(int doc) throws IOException {
                        return singleValues.advanceExact(doc);
                    }

                    public double doubleValue() throws IOException {
                        return (double)singleValues.longValue() * scalingFactorInverse;
                    }
                });
            }
            return new SortedNumericDoubleValues(){

                public boolean advanceExact(int target) throws IOException {
                    return values.advanceExact(target);
                }

                public double nextValue() throws IOException {
                    return (double)values.nextValue() * scalingFactorInverse;
                }

                public int docValueCount() {
                    return values.docValueCount();
                }
            };
        }
    }

    private static class ScaledFloatIndexFieldData
    extends IndexNumericFieldData {
        private final IndexNumericFieldData scaledFieldData;
        private final double scalingFactor;
        private final ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory;

        ScaledFloatIndexFieldData(IndexNumericFieldData scaledFieldData, double scalingFactor, ToScriptFieldFactory<SortedNumericDoubleValues> toScriptFieldFactory) {
            this.scaledFieldData = scaledFieldData;
            this.scalingFactor = scalingFactor;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }

        public String getFieldName() {
            return this.scaledFieldData.getFieldName();
        }

        public ValuesSourceType getValuesSourceType() {
            return this.scaledFieldData.getValuesSourceType();
        }

        public LeafNumericFieldData load(LeafReaderContext context) {
            return new ScaledFloatLeafFieldData((LeafNumericFieldData)this.scaledFieldData.load(context), this.scalingFactor, this.toScriptFieldFactory);
        }

        public LeafNumericFieldData loadDirect(LeafReaderContext context) throws Exception {
            return new ScaledFloatLeafFieldData((LeafNumericFieldData)this.scaledFieldData.loadDirect(context), this.scalingFactor, this.toScriptFieldFactory);
        }

        protected boolean sortRequiresCustomComparator() {
            return true;
        }

        protected boolean isIndexed() {
            return false;
        }

        public IndexNumericFieldData.NumericType getNumericType() {
            return IndexNumericFieldData.NumericType.DOUBLE;
        }
    }
}

