/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.textstructure.transport;

import java.util.ArrayList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.grok.Grok;
import org.elasticsearch.grok.GrokBuiltinPatterns;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xpack.core.textstructure.action.TestGrokPatternAction;

public class TransportTestGrokPatternAction
extends TransportAction<TestGrokPatternAction.Request, TestGrokPatternAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportTestGrokPatternAction.class);
    private final ThreadPool threadPool;

    @Inject
    public TransportTestGrokPatternAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool) {
        super(TestGrokPatternAction.INSTANCE.name(), actionFilters, transportService.getTaskManager());
        this.threadPool = threadPool;
    }

    protected void doExecute(Task task, TestGrokPatternAction.Request request, ActionListener<TestGrokPatternAction.Response> listener) {
        this.threadPool.generic().execute((Runnable)ActionRunnable.supply(listener, () -> this.getResponse(request)));
    }

    private TestGrokPatternAction.Response getResponse(TestGrokPatternAction.Request request) {
        assert (Transports.assertNotTransportThread((String)"matching regexes is too expensive for a network thread"));
        boolean ecsCompatibility = "v1".equals(request.getEcsCompatibility());
        Grok grok = new Grok(GrokBuiltinPatterns.get((boolean)ecsCompatibility), request.getGrokPattern(), arg_0 -> ((Logger)logger).debug(arg_0));
        ArrayList<Map> ranges = new ArrayList<Map>();
        for (String text : request.getText()) {
            ranges.add(grok.captureRanges(text));
        }
        return new TestGrokPatternAction.Response(ranges);
    }
}

