/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto.content;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class CborFactory {
    private static final CBORFactory cborFactory = new CBORFactory();

    CborFactory() {
    }

    public static JsonGenerator generator(OutputStream out) throws IOException {
        return cborFactory.createGenerator(out, JsonEncoding.UTF8);
    }

    public static JsonParser parser(InputStream in) throws IOException {
        return cborFactory.createParser(in);
    }

    static {
        cborFactory.configure(JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW, false);
        cborFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
        cborFactory.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true);
    }
}

