/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.assembler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.xpack.eql.execution.ExecutionUtils;
import org.elasticsearch.xpack.eql.execution.search.Ordinal;
import org.elasticsearch.xpack.eql.execution.search.QueryRequest;
import org.elasticsearch.xpack.eql.execution.search.RuntimeUtils;
import org.elasticsearch.xpack.eql.expression.OptionalMissingAttribute;
import org.elasticsearch.xpack.eql.expression.OptionalResolvedAttribute;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public class SampleQueryRequest
implements QueryRequest {
    public static final String COMPOSITE_AGG_NAME = "keys";
    private SearchSourceBuilder searchSource;
    private final List<String> keys;
    private final List<Attribute> keyFields;
    private CompositeAggregationBuilder agg;
    private List<QueryBuilder> multipleKeyFilters;
    private List<QueryBuilder> singleKeyPairFilters;
    private final int fetchSize;

    public SampleQueryRequest(QueryRequest original, List<String> keyNames, List<Attribute> keyFields, int fetchSize) {
        this.searchSource = original.searchSource();
        this.keys = keyNames;
        this.keyFields = keyFields;
        this.fetchSize = fetchSize;
    }

    @Override
    public SearchSourceBuilder searchSource() {
        return this.searchSource;
    }

    @Override
    public void nextAfter(Ordinal ordinal) {
    }

    public void nextAfter(Map<String, Object> afterKeys) {
        this.agg.aggregateAfter(afterKeys);
    }

    public List<String> keys() {
        return this.keys;
    }

    public void multipleKeyPairs(List<Map<String, Object>> values, List<String> previousCriterionKeys) {
        List<Object> newFilters;
        assert (previousCriterionKeys != null && previousCriterionKeys.size() == this.keys.size());
        if (values.isEmpty()) {
            if (CollectionUtils.isEmpty(this.multipleKeyFilters)) {
                return;
            }
            newFilters = Collections.emptyList();
        } else {
            BoolQueryBuilder orKeys = QueryBuilders.boolQuery();
            newFilters = Collections.singletonList(orKeys);
            for (Map<String, Object> bucket : values) {
                BoolQueryBuilder joinKeyBoolQuery = null;
                for (int i = 0; i < this.keys.size(); ++i) {
                    String key = this.keys.get(i);
                    Object value = bucket.get(previousCriterionKeys.get(i));
                    if (value == null && !SampleQueryRequest.isOptionalAttribute(this.keyFields.get(i))) continue;
                    if (joinKeyBoolQuery == null) {
                        joinKeyBoolQuery = QueryBuilders.boolQuery();
                    }
                    if (value != null) {
                        joinKeyBoolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)value));
                        continue;
                    }
                    joinKeyBoolQuery.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)key));
                }
                if (joinKeyBoolQuery == null) continue;
                orKeys.should(joinKeyBoolQuery);
            }
        }
        RuntimeUtils.replaceFilter(this.searchSource, this.multipleKeyFilters, newFilters);
        this.multipleKeyFilters = newFilters;
    }

    public void singleKeyPair(List<Object> compositeKeyValues, int maxStages, int maxSamplesPerKey) {
        ArrayList<QueryBuilder> newFilters = new ArrayList();
        if (compositeKeyValues.isEmpty()) {
            if (CollectionUtils.isEmpty(this.singleKeyPairFilters)) {
                return;
            }
            newFilters = Collections.emptyList();
        } else {
            for (int i = 0; i < this.keys.size(); ++i) {
                String key = this.keys.get(i);
                Object value = compositeKeyValues.get(i);
                if (value != null) {
                    newFilters.add((QueryBuilder)QueryBuilders.termQuery((String)key, (Object)value));
                    continue;
                }
                if (!SampleQueryRequest.isOptionalAttribute(this.keyFields.get(i))) continue;
                newFilters.add((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)key)));
            }
        }
        SearchSourceBuilder newSource = ExecutionUtils.copySource(this.searchSource);
        RuntimeUtils.replaceFilter(newSource, this.singleKeyPairFilters, newFilters);
        int minResultsNeeded = maxStages + maxSamplesPerKey - 1;
        newSource.size(minResultsNeeded).terminateAfter(minResultsNeeded).fetchSource(FetchSourceContext.DO_NOT_FETCH_SOURCE).trackTotalHits(false).trackScores(false);
        this.singleKeyPairFilters = newFilters;
        this.searchSource = newSource;
    }

    public void withCompositeAggregation() {
        if (this.agg != null) {
            return;
        }
        ArrayList<CompositeValuesSourceBuilder> compositeAggSources = new ArrayList<CompositeValuesSourceBuilder>(this.keys.size());
        for (int i = 0; i < this.keys.size(); ++i) {
            String key = this.keys.get(i);
            Attribute field = this.keyFields.get(i);
            boolean isOptionalKey = SampleQueryRequest.isOptionalAttribute(field);
            compositeAggSources.add(((TermsValuesSourceBuilder)new TermsValuesSourceBuilder(key).field(key)).missingBucket(isOptionalKey));
        }
        this.agg = new CompositeAggregationBuilder(COMPOSITE_AGG_NAME, compositeAggSources);
        this.agg.size(this.fetchSize);
        this.searchSource.aggregation((AggregationBuilder)this.agg);
    }

    private static boolean isOptionalAttribute(Attribute a) {
        return a instanceof OptionalMissingAttribute || a instanceof OptionalResolvedAttribute;
    }
}

