/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.allocation;

import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.blobcache.shared.SharedBlobCacheService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshots;
import org.elasticsearch.xpack.searchablesnapshots.allocation.SearchableSnapshotIndexEventListener;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.CacheKey;
import org.elasticsearch.xpack.searchablesnapshots.cache.full.CacheService;

public class SearchableSnapshotIndexFoldersDeletionListener
implements IndexStorePlugin.IndexFoldersDeletionListener {
    private static final Logger logger = LogManager.getLogger(SearchableSnapshotIndexEventListener.class);
    private final Supplier<CacheService> cacheServiceSupplier;
    private final Supplier<SharedBlobCacheService<CacheKey>> frozenCacheServiceSupplier;

    public SearchableSnapshotIndexFoldersDeletionListener(Supplier<CacheService> cacheServiceSupplier, Supplier<SharedBlobCacheService<CacheKey>> frozenCacheServiceSupplier) {
        this.cacheServiceSupplier = Objects.requireNonNull(cacheServiceSupplier);
        this.frozenCacheServiceSupplier = Objects.requireNonNull(frozenCacheServiceSupplier);
    }

    public void beforeIndexFoldersDeleted(Index index, IndexSettings indexSettings, Path[] indexPaths) {
        if (indexSettings.getIndexMetadata().isSearchableSnapshot()) {
            for (int shard = 0; shard < indexSettings.getNumberOfShards(); ++shard) {
                this.markShardAsEvictedInCache(new ShardId(index, shard), indexSettings);
            }
        }
    }

    public void beforeShardFoldersDeleted(ShardId shardId, IndexSettings indexSettings, Path[] shardPaths) {
        if (indexSettings.getIndexMetadata().isSearchableSnapshot()) {
            this.markShardAsEvictedInCache(shardId, indexSettings);
        }
    }

    private void markShardAsEvictedInCache(ShardId shardId, IndexSettings indexSettings) {
        CacheService cacheService = this.cacheServiceSupplier.get();
        assert (cacheService != null) : "cache service not initialized";
        logger.debug("{} marking shard as evicted in searchable snapshots cache (reason: cache files deleted from disk)", (Object)shardId);
        cacheService.markShardAsEvictedInCache((String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSettings.getSettings()), (String)SearchableSnapshots.SNAPSHOT_INDEX_NAME_SETTING.get(indexSettings.getSettings()), shardId);
        SharedBlobCacheService<CacheKey> sharedBlobCacheService = this.frozenCacheServiceSupplier.get();
        assert (sharedBlobCacheService != null) : "frozen cache service not initialized";
        sharedBlobCacheService.forceEvict(SearchableSnapshots.forceEvictPredicate(shardId, indexSettings.getSettings()));
    }
}

