/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.action;

import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.autoscaling.AutoscalingLicenseChecker;
import org.elasticsearch.xpack.autoscaling.AutoscalingMetadata;
import org.elasticsearch.xpack.autoscaling.action.GetAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicy;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicyMetadata;

public class TransportGetAutoscalingPolicyAction
extends TransportMasterNodeAction<GetAutoscalingPolicyAction.Request, GetAutoscalingPolicyAction.Response> {
    private final AutoscalingLicenseChecker autoscalingLicenseChecker;

    @Inject
    public TransportGetAutoscalingPolicyAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutoscalingLicenseChecker autoscalingLicenseChecker) {
        super("cluster:admin/autoscaling/get_autoscaling_policy", transportService, clusterService, threadPool, actionFilters, GetAutoscalingPolicyAction.Request::new, indexNameExpressionResolver, GetAutoscalingPolicyAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.autoscalingLicenseChecker = Objects.requireNonNull(autoscalingLicenseChecker);
    }

    protected void masterOperation(Task task, GetAutoscalingPolicyAction.Request request, ClusterState state, ActionListener<GetAutoscalingPolicyAction.Response> listener) {
        if (!this.autoscalingLicenseChecker.isAutoscalingAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"autoscaling"));
            return;
        }
        listener.onResponse((Object)new GetAutoscalingPolicyAction.Response(TransportGetAutoscalingPolicyAction.getAutoscalingPolicy(state, request.name())));
    }

    static AutoscalingPolicy getAutoscalingPolicy(ClusterState state, String name) {
        AutoscalingMetadata metadata = state.metadata().custom("autoscaling") != null ? (AutoscalingMetadata)state.metadata().custom("autoscaling") : AutoscalingMetadata.EMPTY;
        if (!metadata.policies().containsKey(name)) {
            throw new ResourceNotFoundException("autoscaling policy with name [" + name + "] does not exist", new Object[0]);
        }
        return ((AutoscalingPolicyMetadata)metadata.policies().get(name)).policy();
    }

    protected ClusterBlockException checkBlock(GetAutoscalingPolicyAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

