/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.topn.SortableTopNEncoder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;

class FixedLengthTopNEncoder
extends SortableTopNEncoder {
    private final int length;

    FixedLengthTopNEncoder(int length) {
        this.length = length;
    }

    @Override
    public int encodeBytesRef(BytesRef value, BreakingBytesRefBuilder bytesRefBuilder) {
        if (value.length != this.length) {
            throw new IllegalArgumentException("expected exactly [" + this.length + "] bytes but got [" + value.length + "]");
        }
        bytesRefBuilder.append(value);
        return this.length;
    }

    @Override
    public BytesRef decodeBytesRef(BytesRef bytes, BytesRef scratch) {
        if (bytes.length < this.length) {
            throw new IllegalArgumentException("expected [" + this.length + "] bytes but only [" + bytes.length + "] remain");
        }
        scratch.bytes = bytes.bytes;
        scratch.offset = bytes.offset;
        scratch.length = this.length;
        bytes.offset += this.length;
        bytes.length -= this.length;
        return scratch;
    }

    public String toString() {
        return "FixedLengthTopNEncoder[" + this.length + "]";
    }

    @Override
    public TopNEncoder toSortable() {
        return this;
    }

    @Override
    public TopNEncoder toUnsortable() {
        return this;
    }
}

